/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderLivingEvent;
import net.minecraftforge.client.event.RenderNameTagEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.hadean.breathe.client.layer.HadeanGhastEntityGlowLayer;
import vzling.hadean.breathe.client.model.HadeanGhastEntityModel;
import vzling.hadean.breathe.entity.HadeanGhastEntity;

@OnlyIn(value=Dist.CLIENT)
public class HadeanGhastEntityRenderer<T extends HadeanGhastEntity>
extends MobRenderer<T, HadeanGhastEntityModel<T>> {
    public HadeanGhastEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new HadeanGhastEntityModel(context.m_174023_(HadeanGhastEntityModel.LAYER_LOCATION)), 1.5f);
        this.m_115326_((RenderLayer)new HadeanGhastEntityGlowLayer(this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/entity/hadean_ghast_shooting_glow.png")));
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        return ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)(((HadeanGhastEntity)((Object)entity)).isCharging() ? "textures/entity/hadean_ghast_shooting.png" : "textures/entity/hadean_ghast.png"));
    }

    public void render(@NotNull T entity, float entityYaw, float partialTicks, @NotNull PoseStack stack, @NotNull MultiBufferSource bufferSource, int light) {
        Entity entity1;
        if (!MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Pre(entity, (LivingEntityRenderer)this, partialTicks, stack, bufferSource, light))) {
            Direction bedDir;
            Entity entity2;
            boolean shouldSit;
            stack.m_85836_();
            ((HadeanGhastEntityModel)this.f_115290_).f_102608_ = this.m_115342_((LivingEntity)entity, partialTicks);
            ((HadeanGhastEntityModel)this.f_115290_).f_102609_ = shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
            ((HadeanGhastEntityModel)this.f_115290_).f_102610_ = entity.m_6162_();
            float bodyYaw = Mth.m_14189_((float)partialTicks, (float)((HadeanGhastEntity)((Object)entity)).f_20884_, (float)((HadeanGhastEntity)((Object)entity)).f_20883_);
            float headYaw = Mth.m_14189_((float)partialTicks, (float)((HadeanGhastEntity)((Object)entity)).f_20886_, (float)((HadeanGhastEntity)((Object)entity)).f_20885_);
            float netHeadYaw = headYaw - bodyYaw;
            if (shouldSit && (entity2 = entity.m_20202_()) instanceof LivingEntity) {
                LivingEntity vehicle = (LivingEntity)entity2;
                bodyYaw = Mth.m_14189_((float)partialTicks, (float)vehicle.f_20884_, (float)vehicle.f_20883_);
                netHeadYaw = headYaw - bodyYaw;
                float deltaYaw = Mth.m_14177_((float)netHeadYaw);
                if (deltaYaw < -85.0f) {
                    deltaYaw = -85.0f;
                }
                if (deltaYaw >= 85.0f) {
                    deltaYaw = 85.0f;
                }
                bodyYaw = headYaw - deltaYaw;
                if (deltaYaw * deltaYaw > 2500.0f) {
                    bodyYaw += deltaYaw * 0.2f;
                }
                netHeadYaw = headYaw - bodyYaw;
            }
            float pitch = Mth.m_14179_((float)partialTicks, (float)((HadeanGhastEntity)((Object)entity)).f_19860_, (float)entity.m_146909_());
            if (HadeanGhastEntityRenderer.m_194453_(entity)) {
                pitch *= -1.0f;
                netHeadYaw *= -1.0f;
            }
            if (entity.m_217003_(Pose.SLEEPING) && (bedDir = entity.m_21259_()) != null) {
                float eyeOffset = entity.m_20236_(Pose.STANDING) - 0.1f;
                stack.m_252880_((float)(-bedDir.m_122429_()) * eyeOffset, 0.0f, (float)(-bedDir.m_122431_()) * eyeOffset);
            }
            float bob = this.m_6930_((LivingEntity)entity, partialTicks);
            this.m_7523_((LivingEntity)entity, stack, bob, bodyYaw, partialTicks);
            stack.m_85841_(-1.0f, -1.0f, 1.0f);
            this.scale(entity, stack, partialTicks);
            stack.m_252880_(0.0f, -1.501f, 0.0f);
            float limbSwingAmount = 0.0f;
            float limbSwing = 0.0f;
            if (!shouldSit && entity.m_6084_()) {
                limbSwingAmount = ((HadeanGhastEntity)((Object)entity)).f_267362_.m_267711_(partialTicks);
                limbSwing = ((HadeanGhastEntity)((Object)entity)).f_267362_.m_267590_(partialTicks);
                if (entity.m_6162_()) {
                    limbSwing *= 3.0f;
                }
                if (limbSwingAmount > 1.0f) {
                    limbSwingAmount = 1.0f;
                }
            }
            ((HadeanGhastEntityModel)this.f_115290_).m_6839_((Entity)entity, limbSwing, limbSwingAmount, partialTicks);
            ((HadeanGhastEntityModel)this.f_115290_).setupAnim(entity, limbSwing, limbSwingAmount, bob, netHeadYaw, pitch);
            Minecraft minecraft = Minecraft.m_91087_();
            boolean bodyVisible = this.m_5933_((LivingEntity)entity);
            boolean invisibleToPlayer = false;
            if (minecraft.f_91074_ != null) {
                invisibleToPlayer = !bodyVisible && !entity.m_20177_((Player)minecraft.f_91074_);
            }
            boolean glowing = minecraft.m_91314_(entity);
            RenderType renderType = this.getRenderType(entity, bodyVisible, invisibleToPlayer, glowing);
            float alpha = 1.0f;
            if (!((HadeanGhastEntity)((Object)entity)).isSpawned() && ((HadeanGhastEntity)((Object)entity)).f_19797_ < 100) {
                alpha = ((float)((HadeanGhastEntity)((Object)entity)).f_19797_ + partialTicks) / 100.0f % 1.0f;
            }
            alpha *= 1.0f - (float)((HadeanGhastEntity)((Object)entity)).f_20916_ / 10.0f;
            if (((HadeanGhastEntity)((Object)entity)).getRemoveTime() > 0) {
                alpha *= (float)((HadeanGhastEntity)((Object)entity)).getRemoveTime() / 20.0f;
            }
            alpha = Math.min(alpha, 0.5f);
            if (renderType != null) {
                VertexConsumer vertexConsumer = bufferSource.m_6299_(renderType);
                int overlay = HadeanGhastEntityRenderer.m_115338_(entity, (float)this.getWhiteOverlayProgress(entity, partialTicks));
                ((HadeanGhastEntityModel)this.f_115290_).m_7695_(stack, vertexConsumer, light, overlay, 1.0f, 1.0f, 1.0f, (invisibleToPlayer ? 0.15f : 1.0f) * alpha);
            }
            if (!entity.m_5833_()) {
                for (RenderLayer layer : this.f_115291_) {
                    layer.m_6494_(stack, bufferSource, light, entity, limbSwing, limbSwingAmount, partialTicks, bob, netHeadYaw, pitch);
                }
            }
            stack.m_85849_();
            RenderNameTagEvent renderNameTagEvent = new RenderNameTagEvent(entity, entity.m_5446_(), (EntityRenderer)this, stack, bufferSource, light, partialTicks);
            MinecraftForge.EVENT_BUS.post((Event)renderNameTagEvent);
            if (renderNameTagEvent.getResult() != Event.Result.DENY && (renderNameTagEvent.getResult() == Event.Result.ALLOW || this.m_6512_((Mob)entity))) {
                this.m_7649_((Entity)entity, renderNameTagEvent.getContent(), stack, bufferSource, light);
            }
            MinecraftForge.EVENT_BUS.post((Event)new RenderLivingEvent.Post(entity, (LivingEntityRenderer)this, partialTicks, stack, bufferSource, light));
        }
        if ((entity1 = entity.m_21524_()) != null) {
            this.m_115461_((Mob)entity, partialTicks, stack, bufferSource, entity1);
        }
    }

    protected float getFlipDegrees(@NotNull T entity) {
        return 0.0f;
    }

    protected float getWhiteOverlayProgress(@NotNull T entity, float partialTicks) {
        if (!((HadeanGhastEntity)((Object)entity)).isSpawned() && ((HadeanGhastEntity)((Object)entity)).f_19797_ < 100) {
            float progress = ((float)((HadeanGhastEntity)((Object)entity)).f_19797_ + partialTicks) / 10.0f % 2.0f;
            if (progress > 1.0f) {
                return (1.0f - (progress - 1.0f)) * 0.7f;
            }
            return progress * 0.7f;
        }
        if (((HadeanGhastEntity)((Object)entity)).f_20919_ > 0) {
            return entity.m_217043_().m_188501_();
        }
        return super.m_6931_(entity, partialTicks);
    }

    protected void scale(@NotNull T entity, @NotNull PoseStack stack, float partialTicks) {
        super.m_7546_(entity, stack, partialTicks);
        stack.m_85841_(6.75f, 6.75f, 6.75f);
        if (!((HadeanGhastEntity)((Object)entity)).isSpawned() && ((HadeanGhastEntity)((Object)entity)).f_19797_ < 100) {
            stack.m_85841_(Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.98f, (float)1.02f), Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.98f, (float)1.02f), Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.98f, (float)1.02f));
        }
        if (((HadeanGhastEntity)((Object)entity)).f_20916_ > 0) {
            stack.m_85841_(Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.96f, (float)1.04f), Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.96f, (float)1.04f), Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.96f, (float)1.04f));
        }
        if (((HadeanGhastEntity)((Object)entity)).f_20919_ > 0) {
            stack.m_85841_(Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.92f, (float)1.08f), Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.92f, (float)1.08f), Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.92f, (float)1.08f));
        }
        if (((HadeanGhastEntity)((Object)entity)).f_20919_ > 5) {
            float progress = 1.0f - (float)(((HadeanGhastEntity)((Object)entity)).f_20919_ - 5) / 15.0f;
            stack.m_85841_(progress, progress, progress);
        }
    }

    @Nullable
    protected RenderType getRenderType(@NotNull T entity, boolean bodyVisible, boolean translucent, boolean glowing) {
        return RenderType.m_110473_((ResourceLocation)this.getTextureLocation(entity));
    }
}

