/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.hadean.breathe.client.animation.FlameGuardianEntityAnimation;
import vzling.hadean.breathe.entity.attack.flame_guardian.HeavyAttack;
import vzling.hadean.breathe.entity.attack.flame_guardian.StepAttack;
import vzling.hadean.breathe.entity.attack.flame_guardian.SweepAttack;
import vzling.hadean.breathe.init.HBItem;
import vzling.lib.animation.VzlingAnimatable;
import vzling.lib.animation.VzlingAnimation;
import vzling.lib.entity.AbstractAttackEntity;
import vzling.lib.entity.IAttackEntity;
import vzling.lib.entity.attack.AttackManager;
import vzling.lib.entity.goal.EmptyMeleeAttackGoal;
import vzling.lib.entity.goal.LookAtTargetGoal;
import vzling.lib.platform.VzlingPlatform;
import vzling.lib.util.MiscUtil;

public class FlameGuardianEntity
extends AbstractAttackEntity {
    public static final EntityDataAccessor<Boolean> IS_DORMANCY = SynchedEntityData.m_135353_(FlameGuardianEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final VzlingAnimation IDLE = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"flame_guardian_idle"));
    public final VzlingAnimation DORMANCY = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"flame_guardian_dormancy"));
    public final VzlingAnimation AWAKENING = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"flame_guardian_awakening"));
    public final VzlingAnimation HEAVY_ATTACK = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"flame_guardian_attack"));
    public final VzlingAnimation SWEEP = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"flame_guardian_sweep"));
    public final VzlingAnimation STEP = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"flame_guardian_step"));
    private final AttackManager<FlameGuardianEntity> attackManager = new AttackManager((Monster)this, List.of(new HeavyAttack(), new SweepAttack(), new StepAttack()));
    public int awakeningTick = 0;
    public boolean isAwakening = false;

    public FlameGuardianEntity(EntityType<? extends Monster> entityType, Level level) {
        super(entityType, level);
        if (VzlingPlatform.INSTANCE.isClientSide()) {
            this.IDLE.setDefinition(FlameGuardianEntityAnimation.IDLE);
            this.DORMANCY.setDefinition(FlameGuardianEntityAnimation.DORMANCY);
            this.AWAKENING.setDefinition(FlameGuardianEntityAnimation.AWAKENING);
            this.HEAVY_ATTACK.setDefinition(FlameGuardianEntityAnimation.HEAVY_ATTACK);
            this.SWEEP.setDefinition(FlameGuardianEntityAnimation.SWEEP);
            this.STEP.setDefinition(FlameGuardianEntityAnimation.STEP);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(IS_DORMANCY, (Object)true);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("IsDormancy", this.isDormancy());
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("IsDormancy")) {
            this.setDormancy(tag.m_128471_("IsDormancy"));
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.isDormancy()) {
            this.playAnimationIfStopped((LivingEntity)this, this.DORMANCY);
        } else {
            this.playAnimationIfStopped((LivingEntity)this, this.IDLE);
        }
        if (this.isAwakening) {
            ++this.awakeningTick;
        }
        if (this.awakeningTick >= 20) {
            this.m_20256_(Vec3.f_82478_);
            this.m_21557_(false);
            this.isAwakening = false;
            this.awakeningTick = 0;
        }
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player player, @NotNull InteractionHand hand) {
        if (this.isDormancy()) {
            MiscUtil.sendAnimationPacket((Level)this.m_9236_(), (int)2, (int)this.m_19879_(), (ResourceLocation)this.DORMANCY.getId());
            MiscUtil.sendAnimationPacket((Level)this.m_9236_(), (int)0, (int)this.m_19879_(), (ResourceLocation)this.AWAKENING.getId());
            this.isAwakening = true;
            this.setDormancy(false);
            this.m_216990_(SoundEvents.f_11880_);
        }
        return super.m_6071_(player, hand);
    }

    protected boolean m_8028_() {
        return !this.isDormancy();
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (accessor.equals((Object)ATTACKING) && this.isAttacking()) {
            this.stopAllAnimStates();
            switch (this.getAttackType()) {
                case 0: {
                    this.playAnimation((LivingEntity)this, this.HEAVY_ATTACK);
                    break;
                }
                case 1: {
                    this.playAnimation((LivingEntity)this, this.SWEEP);
                    break;
                }
                case 2: {
                    this.playAnimation((LivingEntity)this, this.STEP);
                }
            }
        }
    }

    private void stopAllAnimStates() {
        this.stopAnimation((LivingEntity)this, this.HEAVY_ATTACK);
        this.stopAnimation((LivingEntity)this, this.SWEEP);
        this.stopAnimation((LivingEntity)this, this.STEP);
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return SoundEvents.f_12008_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12059_;
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        super.m_7355_(pos, state);
        this.m_5496_(SoundEvents.f_12009_, 0.5f, Mth.m_216267_((RandomSource)this.m_217043_(), (float)0.7f, (float)0.9f));
        MiscUtil.startShake((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)32.0, (float)1.0f, (int)5);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_21552_().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 1.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22281_, 7.0);
    }

    public boolean m_6469_(@NotNull DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        if (source.m_269533_(DamageTypeTags.f_268745_)) {
            return false;
        }
        if (this.isDormancy()) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_6785_(double distance) {
        return false;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EmptyMeleeAttackGoal((AbstractAttackEntity)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
    }

    public void selectAttackType() {
        this.setAttackType(this.f_19796_.m_188503_(3));
    }

    public AttackManager<? extends IAttackEntity> getAttackManager() {
        return this.attackManager;
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor levelAccessor, @NotNull DifficultyInstance instance, @NotNull MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.m_21557_(true);
        this.m_21008_(InteractionHand.MAIN_HAND, ((Item)HBItem.GUARDIAN_GREATSWORD.get()).m_7968_());
        return groupData;
    }

    public boolean isDormancy() {
        return (Boolean)this.f_19804_.m_135370_(IS_DORMANCY);
    }

    public void setDormancy(boolean dormancy) {
        this.f_19804_.m_135381_(IS_DORMANCY, (Object)dormancy);
    }
}

