/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.entity;

import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.hadean.breathe.client.animation.HadeanBlasterEntityAnimation;
import vzling.hadean.breathe.client.event.HEClientEvent;
import vzling.hadean.breathe.entity.attack.hadean_blaster.ShootAttack;
import vzling.hadean.breathe.entity.boss_event.HEServerBossEvent;
import vzling.hadean.breathe.init.HBItem;
import vzling.lib.animation.VzlingAnimatable;
import vzling.lib.animation.VzlingAnimation;
import vzling.lib.entity.BossEntity;
import vzling.lib.entity.IAttackEntity;
import vzling.lib.entity.attack.AttackManager;
import vzling.lib.platform.VzlingPlatform;

public class HadeanBlasterEntity
extends BossEntity {
    public final VzlingAnimation IDLE = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_blaster_idle"));
    private final HEServerBossEvent bossEvent = new HEServerBossEvent((Mob)this, BossEvent.BossBarColor.RED, true);
    private final AttackManager<HadeanBlasterEntity> attackManager = new AttackManager((Monster)this, List.of(new ShootAttack()));
    private int waitTick = 0;
    public static final EntityDataAccessor<Integer> BULLET_COUNT = SynchedEntityData.m_135353_(HadeanBlasterEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public HadeanBlasterEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        if (level.f_46443_) {
            HEClientEvent.BOSSES.add((Mob)this);
        }
        if (VzlingPlatform.INSTANCE.isClientSide()) {
            this.IDLE.setDefinition(HadeanBlasterEntityAnimation.IDLE);
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(BULLET_COUNT, (Object)20);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22284_, 16.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22277_, 1024.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8119_() {
        super.m_8119_();
        this.playAnimationIfStopped((LivingEntity)this, this.IDLE);
    }

    public void m_8107_() {
        super.m_8107_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (!this.m_9236_().f_46443_ && !this.m_21525_() && this.m_6084_()) {
            if (this.m_5448_() == null) {
                if (this.waitTick < 600) {
                    ++this.waitTick;
                } else if (this.f_19797_ % 20 == 0) {
                    this.m_5634_(5.0f);
                }
            } else {
                this.waitTick = 0;
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (accessor.equals((Object)ATTACKING) && this.isAttacking()) {
            this.stopAllAnimStates();
            this.getAttackType();
        }
        super.m_7350_(accessor);
    }

    private void stopAllAnimStates() {
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("BulletCount", this.getBulletCount());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.bossEvent.setId(this.m_20148_());
        if (tag.m_128441_("BulletCount")) {
            this.setBulletCount(tag.m_128451_("BulletCount"));
        }
    }

    public void updatePhase() {
    }

    public void spawn() {
    }

    public boolean hasSpawnProcess() {
        return false;
    }

    public void selectAttackType() {
    }

    public AttackManager<? extends IAttackEntity> getAttackManager() {
        return this.attackManager;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268549_) || source.m_269533_(DamageTypeTags.f_268745_) || source.m_269533_(DamageTypeTags.f_268415_) || source.m_269533_(DamageTypeTags.f_268524_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.m_8061_(EquipmentSlot.MAINHAND, ((Item)HBItem.FURY.get()).m_7968_());
        return super.m_6518_(levelAccessor, instance, spawnType, groupData, tag);
    }

    public int getBulletCount() {
        return (Integer)this.f_19804_.m_135370_(BULLET_COUNT);
    }

    public void setBulletCount(int bulletCount) {
        this.f_19804_.m_135381_(BULLET_COUNT, (Object)bulletCount);
    }

    public int getDamageTime() {
        return 25;
    }

    public float getDamageMap() {
        return 12.0f;
    }
}

