/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.entity;

import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.PowerableMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import vzling.hadean.breathe.HBConfig;
import vzling.hadean.breathe.block.EnforcerTreasureChestBlock;
import vzling.hadean.breathe.block.entity.EnforcerTreasureChestBlockEntity;
import vzling.hadean.breathe.client.animation.HadeanEnforcerEntityAnimation;
import vzling.hadean.breathe.client.animation.HadeanEnforcerEntityAnimation2;
import vzling.hadean.breathe.client.event.HEClientEvent;
import vzling.hadean.breathe.client.particle.AttackParticle;
import vzling.hadean.breathe.entity.FlameGuardianEntity;
import vzling.hadean.breathe.entity.FlamedHuskEntity;
import vzling.hadean.breathe.entity.HadeanBlasterEntity;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.BarrageAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.BlockAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.ChargeAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.ComboAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.DodgeAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.FistAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.KickAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.ShootAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.SlashAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.SpinAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.SprintAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.SprintPhase2Attack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.SummonAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.SweepAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.ThrowAttack;
import vzling.hadean.breathe.entity.attack.hadean_enforcer.UppercutAttack;
import vzling.hadean.breathe.entity.boss_event.HEServerBossEvent;
import vzling.hadean.breathe.init.HBBlock;
import vzling.hadean.breathe.init.HBEntity;
import vzling.hadean.breathe.init.HBItem;
import vzling.hadean.breathe.init.HBParticle;
import vzling.lib.animation.VzlingAnimatable;
import vzling.lib.animation.VzlingAnimation;
import vzling.lib.entity.AbstractAttackEntity;
import vzling.lib.entity.BossEntity;
import vzling.lib.entity.attack.AttackManager;
import vzling.lib.entity.attack.BaseAttack;
import vzling.lib.entity.goal.EmptyMeleeAttackGoal;
import vzling.lib.entity.goal.LookAtTargetGoal;
import vzling.lib.platform.VzlingPlatform;
import vzling.lib.util.EntityUtil;
import vzling.lib.util.MiscUtil;

public class HadeanEnforcerEntity
extends BossEntity
implements PowerableMob {
    public final VzlingAnimation IDLE = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_idle"));
    public final VzlingAnimation FIST = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_fist"));
    public final VzlingAnimation KICK = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_kick"));
    public final VzlingAnimation SPRINT = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_sprint"));
    public final VzlingAnimation DODGE = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_dodge"));
    public final VzlingAnimation BARRAGE = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_barrage"));
    public final VzlingAnimation SWEEP = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_sweep"));
    public final VzlingAnimation SPRINT_PHASE_2 = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_sprint_phase_2"));
    public final VzlingAnimation UPPERCUT = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_uppercut"));
    public final VzlingAnimation COMBO = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_combo1"));
    public final VzlingAnimation BLOCK = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_block"));
    public final VzlingAnimation BLOCK_HURT = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_block_hurt"));
    public final VzlingAnimation SWORD_BLOCK = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_sword_block"));
    public final VzlingAnimation THROW = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_throw"));
    public final VzlingAnimation CHARGE = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_charge"));
    public final VzlingAnimation SLASH = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_slash"));
    public final VzlingAnimation SHOOT = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_shoot"));
    public final VzlingAnimation SUMMON = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_summon"));
    public final VzlingAnimation SPIN = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_spin"));
    public final VzlingAnimation STOP = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_stop"));
    public final VzlingAnimation PHASE = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_phase"));
    public final VzlingAnimation SPAWN = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_spawn"));
    public final VzlingAnimation DEATH = new VzlingAnimation((VzlingAnimatable)this, ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_enforcer_death"));
    private final HEServerBossEvent bossEvent = new HEServerBossEvent((Mob)this, BossEvent.BossBarColor.RED, true);
    private final AttackManager<HadeanEnforcerEntity> attackManager = new AttackManager((Monster)this, List.of(new BaseAttack[]{new FistAttack(), new KickAttack(), new SprintAttack(), new DodgeAttack(), new BarrageAttack(), new SweepAttack(), new SprintPhase2Attack(), new UppercutAttack(), new ComboAttack(), new BlockAttack(), new ThrowAttack(), new ChargeAttack(), new SlashAttack(), new ShootAttack(), new SummonAttack(), new SpinAttack()}));
    private int waitTick = 0;
    public static final EntityDataAccessor<Boolean> HAS_SPAWN_PROCESS = SynchedEntityData.m_135353_(HadeanEnforcerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public HadeanEnforcerEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        if (level.f_46443_) {
            HEClientEvent.BOSSES.add((Mob)this);
        }
        if (VzlingPlatform.INSTANCE.isClientSide()) {
            this.IDLE.setDefinition(HadeanEnforcerEntityAnimation.IDLE);
            this.FIST.setDefinition(HadeanEnforcerEntityAnimation.FIST);
            this.KICK.setDefinition(HadeanEnforcerEntityAnimation.KICK);
            this.SPRINT.setDefinition(HadeanEnforcerEntityAnimation2.SPRINT);
            this.DODGE.setDefinition(HadeanEnforcerEntityAnimation.DODGE);
            this.BARRAGE.setDefinition(HadeanEnforcerEntityAnimation2.BARRAGE);
            this.SWEEP.setDefinition(HadeanEnforcerEntityAnimation.SWEEP);
            this.SPRINT_PHASE_2.setDefinition(HadeanEnforcerEntityAnimation2.PHASE2SPRINT);
            this.UPPERCUT.setDefinition(HadeanEnforcerEntityAnimation2.UPPERCUT);
            this.COMBO.setDefinition(HadeanEnforcerEntityAnimation.IDLE);
            this.BLOCK.setDefinition(HadeanEnforcerEntityAnimation.BLOCK);
            this.BLOCK_HURT.setDefinition(HadeanEnforcerEntityAnimation2.BLOCKHURT);
            this.SWORD_BLOCK.setDefinition(HadeanEnforcerEntityAnimation2.SWORDBLOCK);
            this.THROW.setDefinition(HadeanEnforcerEntityAnimation2.THROW);
            this.CHARGE.setDefinition(HadeanEnforcerEntityAnimation2.CHARGE);
            this.SLASH.setDefinition(HadeanEnforcerEntityAnimation.SLASH);
            this.SHOOT.setDefinition(HadeanEnforcerEntityAnimation.SHOOT);
            this.SUMMON.setDefinition(HadeanEnforcerEntityAnimation2.SUMMON);
            this.SPIN.setDefinition(HadeanEnforcerEntityAnimation.SPIN);
            this.STOP.setDefinition(HadeanEnforcerEntityAnimation.STOP);
            this.PHASE.setDefinition(HadeanEnforcerEntityAnimation2.PHASE2);
            this.SPAWN.setDefinition(HadeanEnforcerEntityAnimation.SPAWN);
            this.DEATH.setDefinition(HadeanEnforcerEntityAnimation.DEAD);
        }
    }

    public HadeanEnforcerEntity(Level level, boolean hasSpawnProcess) {
        this(HBEntity.HADEAN_ENFORCER.get(), level);
        this.setHasSpawnProcess(hasSpawnProcess);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(HAS_SPAWN_PROCESS, (Object)false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22284_, 16.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22277_, 1024.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new EmptyMeleeAttackGoal((AbstractAttackEntity)this, 1.0, false));
        this.f_21345_.m_25352_(2, (Goal)new LookAtTargetGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
        this.f_21346_.m_25352_(0, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, false, entity -> !(entity instanceof FlamedHuskEntity) && !(entity instanceof FlameGuardianEntity) && !(entity instanceof HadeanBlasterEntity)));
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8119_() {
        super.m_8119_();
        this.playAnimationIfStopped((LivingEntity)this, this.IDLE);
    }

    public void m_8107_() {
        super.m_8107_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (this.getPhase() == 2 && !this.isAttacking() && this.m_21205_().m_150930_(Items.f_41852_)) {
            this.m_21008_(InteractionHand.MAIN_HAND, ((Item)HBItem.EMBER.get()).m_7968_());
        }
        if (!this.m_9236_().f_46443_ && !this.m_21525_() && this.m_6084_()) {
            if (this.m_5448_() == null) {
                if (this.waitTick < 600) {
                    ++this.waitTick;
                } else if (this.f_19797_ % 20 == 0) {
                    this.m_5634_(5.0f);
                }
            } else {
                this.waitTick = 0;
                if (!this.isAttacking()) {
                    if (this.m_20186_() == this.m_5448_().m_20186_()) {
                        if (this.m_20280_((Entity)this.m_5448_()) >= 128.0) {
                            this.setAttackType(this.getPhase() == 2 ? 6 : 2);
                        }
                    } else if (this.getPhase() == 2) {
                        double random = this.f_19796_.m_188500_();
                        if (random <= 0.4) {
                            this.setAttackType(10);
                        } else if (random <= 0.6) {
                            this.setAttackType(11);
                        } else {
                            this.setAttackType(13);
                        }
                    }
                }
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (accessor.equals((Object)ATTACKING) && this.isAttacking()) {
            this.stopAllAnimStates();
            switch (this.getAttackType()) {
                case 0: {
                    this.playAnimation((LivingEntity)this, this.FIST);
                    break;
                }
                case 1: {
                    this.playAnimation((LivingEntity)this, this.KICK);
                    break;
                }
                case 2: {
                    this.playAnimation((LivingEntity)this, this.SPRINT);
                    break;
                }
                case 3: {
                    this.playAnimation((LivingEntity)this, this.DODGE);
                    break;
                }
                case 4: {
                    this.playAnimation((LivingEntity)this, this.BARRAGE);
                    break;
                }
                case 5: {
                    this.playAnimation((LivingEntity)this, this.SWEEP);
                    break;
                }
                case 6: {
                    this.playAnimation((LivingEntity)this, this.SPRINT_PHASE_2);
                    break;
                }
                case 7: {
                    this.playAnimation((LivingEntity)this, this.UPPERCUT);
                    break;
                }
                case 8: {
                    this.playAnimation((LivingEntity)this, this.COMBO);
                    break;
                }
                case 9: {
                    if (this.getPhase() == 2) {
                        this.playAnimation((LivingEntity)this, this.SWORD_BLOCK);
                        break;
                    }
                    this.playAnimation((LivingEntity)this, this.BLOCK);
                    break;
                }
                case 10: {
                    this.playAnimation((LivingEntity)this, this.THROW);
                    break;
                }
                case 11: {
                    this.playAnimation((LivingEntity)this, this.CHARGE);
                    break;
                }
                case 12: {
                    this.playAnimation((LivingEntity)this, this.SLASH);
                    break;
                }
                case 13: {
                    this.playAnimation((LivingEntity)this, this.SHOOT);
                    break;
                }
                case 14: {
                    this.playAnimation((LivingEntity)this, this.SUMMON);
                    break;
                }
                case 15: {
                    this.playAnimation((LivingEntity)this, this.SPIN);
                }
            }
        }
        super.m_7350_(accessor);
    }

    private void stopAllAnimStates() {
        this.stopAnimation((LivingEntity)this, this.FIST);
        this.stopAnimation((LivingEntity)this, this.KICK);
        this.stopAnimation((LivingEntity)this, this.SPRINT);
        this.stopAnimation((LivingEntity)this, this.DODGE);
        this.stopAnimation((LivingEntity)this, this.BARRAGE);
        this.stopAnimation((LivingEntity)this, this.SWEEP);
        this.stopAnimation((LivingEntity)this, this.SPRINT_PHASE_2);
        this.stopAnimation((LivingEntity)this, this.UPPERCUT);
        this.stopAnimation((LivingEntity)this, this.COMBO);
        this.stopAnimation((LivingEntity)this, this.BLOCK);
        this.stopAnimation((LivingEntity)this, this.SWORD_BLOCK);
        this.stopAnimation((LivingEntity)this, this.THROW);
        this.stopAnimation((LivingEntity)this, this.CHARGE);
        this.stopAnimation((LivingEntity)this, this.SLASH);
        this.stopAnimation((LivingEntity)this, this.SHOOT);
        this.stopAnimation((LivingEntity)this, this.SUMMON);
        this.stopAnimation((LivingEntity)this, this.SPIN);
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.bossEvent.setId(this.m_20148_());
    }

    public void updatePhase() {
        if ((this.m_21223_() <= this.m_21233_() / 2.0f || this.updatePhase) && (this.getPhase() != 2 || this.updatePhase) && this.isSpawned()) {
            if (!this.updatePhase) {
                this.stopAllAnimStates();
                this.playAnimation((LivingEntity)this, this.PHASE);
                this.phaseTick = 0;
                this.updatePhase = true;
            }
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, 0.0, 0.0);
            this.setAttacking(false);
            this.setAttackTick(0);
            ++this.phaseTick;
            if (!this.m_9236_().f_46443_) {
                this.f_19802_ = 20;
            }
            if (this.phaseTick == 12) {
                this.m_216990_(SoundEvents.f_12557_);
            }
            if (this.phaseTick == 40) {
                this.m_21008_(InteractionHand.MAIN_HAND, ((Item)HBItem.EMBER.get()).m_7968_());
                this.m_216990_(SoundEvents.f_11880_);
                MiscUtil.startShake((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)32.0, (float)4.0f, (int)10);
            }
            if (this.phaseTick >= 45) {
                this.setPhase(2);
            }
            if (this.phaseTick == 45) {
                this.selectAttackType();
            }
            if (this.phaseTick == 80) {
                this.m_216990_(SoundEvents.f_12563_);
                this.m_216990_(SoundEvents.f_12554_);
                MiscUtil.startShake((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)32.0, (float)8.0f, (int)20);
                for (float i = -5.0f; i <= 5.0f; i += 1.0f) {
                    for (float j = -5.0f; j <= 5.0f; j += 1.0f) {
                        for (float k = -5.0f; k <= 5.0f; k += 1.0f) {
                            double d0 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            double d1 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            double d2 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            double d3 = (double)Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2))) / 0.5 + this.f_19796_.m_188500_() - this.f_19796_.m_188500_() * 0.05;
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), d0 / d3, d1 / d3, d2 / d3);
                            if (i == -5.0f || i == 5.0f || j == -5.0f || j == 5.0f) continue;
                            k += 9.0f;
                        }
                    }
                }
            }
            if (this.phaseTick >= 120) {
                this.updatePhase = false;
            }
        }
    }

    public void spawn() {
        if (!this.isSpawned()) {
            double d3;
            double d2;
            double d1;
            double d0;
            float k;
            this.m_21573_().m_26573_();
            this.m_20334_(0.0, 0.0, 0.0);
            this.setAttacking(false);
            this.setAttackTick(0);
            ++this.spawnTick;
            if (!this.m_9236_().f_46443_) {
                this.f_19802_ = 20;
            }
            if (this.spawnTick == 1) {
                this.m_21153_(1.0f);
            }
            if (this.spawnTick == 20) {
                this.m_9236_().m_7106_((ParticleOptions)HBParticle.CRACK.get(), this.m_20185_(), this.m_20186_() + 0.01, this.m_20189_(), 0.0, 0.0, 0.0);
                this.m_216990_(SoundEvents.f_12513_);
                MiscUtil.startShake((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)32.0, (float)4.0f, (int)10);
                for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(32.0))) {
                    if (this.m_9236_().f_46443_) continue;
                    player.m_5661_((Component)Component.m_237115_((String)"dialog.hadean_breathe.hadean_enforcer.0").m_130940_(ChatFormatting.DARK_RED), false);
                }
            }
            if (this.spawnTick == 60) {
                this.m_216990_(SoundEvents.f_12513_);
                MiscUtil.startShake((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)32.0, (float)5.0f, (int)15);
                for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(32.0))) {
                    if (this.m_9236_().f_46443_) continue;
                    player.m_5661_((Component)Component.m_237115_((String)"dialog.hadean_breathe.hadean_enforcer.1").m_130940_(ChatFormatting.DARK_RED), false);
                }
            }
            if (this.spawnTick == 100) {
                this.m_216990_(SoundEvents.f_12513_);
                MiscUtil.startShake((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)32.0, (float)6.0f, (int)20);
                this.m_216990_(SoundEvents.f_12563_);
                for (Player player : this.m_9236_().m_45976_(Player.class, this.m_20191_().m_82400_(32.0))) {
                    if (this.m_9236_().f_46443_) continue;
                    player.m_5661_((Component)Component.m_237115_((String)"dialog.hadean_breathe.hadean_enforcer.2").m_130940_(ChatFormatting.DARK_RED), false);
                }
            }
            if (this.spawnTick >= 20 && this.spawnTick <= 285) {
                int i;
                for (i = 0; i <= 5; ++i) {
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.25, (double)1.25), this.m_20186_(), this.m_20189_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.25, (double)1.25), 0.0, 0.5, 0.0);
                }
                if (this.spawnTick >= 40) {
                    for (i = 0; i <= 8; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.5, (double)1.5), this.m_20186_(), this.m_20189_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.5, (double)1.5), 0.0, 0.5, 0.0);
                    }
                }
                if (this.spawnTick >= 60) {
                    for (i = 0; i <= 12; ++i) {
                        this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.75, (double)1.75), this.m_20186_(), this.m_20189_() + Mth.m_216263_((RandomSource)this.f_19796_, (double)-1.75, (double)1.75), 0.0, 0.5, 0.0);
                    }
                }
            }
            if (this.spawnTick >= 60 && this.spawnTick <= 260) {
                this.m_5634_(this.m_21233_() / 200.0f);
                if (this.f_19797_ % 40 == 0) {
                    this.m_216990_(SoundEvents.f_12557_);
                }
            }
            if (this.spawnTick == 260) {
                this.m_21153_(this.m_21233_());
            }
            if (this.spawnTick == 65) {
                this.m_216990_(SoundEvents.f_12554_);
            }
            if (this.spawnTick == 325) {
                this.m_216990_(SoundEvents.f_12554_);
                MiscUtil.startShake((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)32.0, (float)6.0f, (int)20);
                for (float i = -5.0f; i <= 5.0f; i += 1.0f) {
                    for (float j = -5.0f; j <= 5.0f; j += 1.0f) {
                        for (k = -5.0f; k <= 5.0f; k += 1.0f) {
                            d0 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            d1 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            d2 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            d3 = (double)Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2))) / 0.5 + this.f_19796_.m_188500_() - this.f_19796_.m_188500_() * 0.05;
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), d0 / d3, d1 / d3, d2 / d3);
                            if (i == -5.0f || i == 5.0f || j == -5.0f || j == 5.0f) continue;
                            k += 9.0f;
                        }
                    }
                }
            }
            if (this.spawnTick == 330) {
                for (float i = -5.0f; i <= 5.0f; i += 1.0f) {
                    for (float j = -5.0f; j <= 5.0f; j += 1.0f) {
                        for (k = -5.0f; k <= 5.0f; k += 1.0f) {
                            d0 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            d1 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            d2 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            d3 = (double)Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2))) / 0.5 + this.f_19796_.m_188500_() - this.f_19796_.m_188500_() * 0.05;
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123762_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), d0 / d3, d1 / d3, d2 / d3);
                            if (i == -5.0f || i == 5.0f || j == -5.0f || j == 5.0f) continue;
                            k += 9.0f;
                        }
                    }
                }
            }
            if (this.spawnTick == 335) {
                for (float i = -5.0f; i <= 5.0f; i += 1.0f) {
                    for (float j = -5.0f; j <= 5.0f; j += 1.0f) {
                        for (k = -5.0f; k <= 5.0f; k += 1.0f) {
                            d0 = (double)j + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            d1 = (double)i + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            d2 = (double)k + (this.f_19796_.m_188500_() - this.f_19796_.m_188500_()) * 0.5;
                            d3 = (double)Mth.m_14116_((float)((float)(d0 * d0 + d1 * d1 + d2 * d2))) / 0.5 + this.f_19796_.m_188500_() - this.f_19796_.m_188500_() * 0.05;
                            this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123744_, this.m_20185_(), this.m_20186_() + 1.0, this.m_20189_(), d0 / d3, d1 / d3, d2 / d3);
                            if (i == -5.0f || i == 5.0f || j == -5.0f || j == 5.0f) continue;
                            k += 9.0f;
                        }
                    }
                }
            }
            if (this.spawnTick >= 360) {
                this.setSpawned(true);
            }
        }
    }

    public boolean hasSpawnProcess() {
        return (Boolean)this.f_19804_.m_135370_(HAS_SPAWN_PROCESS);
    }

    public void setHasSpawnProcess(boolean hasSpawnProcess) {
        this.f_19804_.m_135381_(HAS_SPAWN_PROCESS, (Object)hasSpawnProcess);
    }

    public void m_6677_(@NotNull DamageSource source) {
        this.m_21551_();
        SoundEvent soundEvent = this.getPhase() == 2 ? SoundEvents.f_12557_ : SoundEvents.f_12231_;
        this.m_5496_(soundEvent, this.m_6121_(), Mth.m_216267_((RandomSource)this.m_217043_(), (float)0.7f, (float)0.9f));
    }

    protected void m_7355_(@NotNull BlockPos pos, @NotNull BlockState state) {
        super.m_7355_(pos, state);
        this.m_5496_(SoundEvents.f_12009_, 0.5f, Mth.m_216267_((RandomSource)this.m_217043_(), (float)0.7f, (float)0.9f));
    }

    @NotNull
    public SoundEvent m_5592_() {
        return SoundEvents.f_12556_;
    }

    public void selectAttackType() {
        if (this.getPhase() == 1) {
            double random = this.m_217043_().m_188500_();
            if (random <= 0.05) {
                this.setAttackType(0);
            } else if (random <= 0.25) {
                this.setAttackType(1);
            } else if (random <= 0.4) {
                this.setAttackType(3);
            } else if (random <= 0.5) {
                this.setAttackType(7);
            } else if (random <= 0.6) {
                this.selectAttackType();
            } else if (random <= 0.7) {
                this.setAttackType(9);
            } else if (random <= 0.85) {
                this.setAttackType(4);
            } else {
                this.setAttackType(13);
            }
        } else if (this.getPhase() == 2) {
            double random = this.m_217043_().m_188500_();
            if (random <= 0.15) {
                this.setAttackType(5);
            } else if (random <= 0.35) {
                this.setAttackType(9);
            } else if (random <= 0.4) {
                this.setAttackType(14);
            } else if (random <= 0.6) {
                this.setAttackType(12);
            } else if (random <= 0.7) {
                this.setAttackType(11);
            } else if (random <= 0.9) {
                this.setAttackType(13);
            } else {
                this.setAttackType(15);
            }
        }
    }

    public AttackManager<? extends AbstractAttackEntity> getAttackManager() {
        return this.attackManager;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        Vec3 vec32;
        if (!source.m_269533_(DamageTypeTags.f_268738_) && this.getAttackType() == 9 && this.getAttackTick() >= 10 && this.getAttackTick() <= 71 && (vec32 = source.m_7270_()) != null) {
            Vec3 vec3 = this.m_20252_(1.0f);
            Vec3 vec31 = vec32.m_82505_(this.m_20182_()).m_82541_();
            vec31 = new Vec3(vec31.f_82479_, 0.0, vec31.f_82481_);
            if (vec31.m_82526_(vec3) < 0.0) {
                this.m_5496_(SoundEvents.f_11669_, 1.0f, Mth.m_216267_((RandomSource)this.m_217043_(), (float)0.7f, (float)0.9f));
                Level level = this.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    double rot = Math.toRadians(this.f_20883_);
                    double x = this.m_20185_() - (double)Mth.m_14031_((float)((float)rot));
                    double y = this.m_20186_() + 1.0;
                    double z = this.m_20189_() + (double)Mth.m_14089_((float)((float)rot));
                    level2.m_8767_((ParticleOptions)new AttackParticle.RotData(0.0f, -this.f_20883_, 0.0f), x, y, z, 0, 0.0, 0.0, 0.0, 1.0);
                }
                if (this.getPhase() == 2 && (level = source.m_7639_()) instanceof LivingEntity) {
                    LivingEntity target = (LivingEntity)level;
                    EntityUtil.forceHurt((LivingEntity)target, (DamageSource)this.m_269291_().m_269333_((LivingEntity)this), (float)(amount * 0.25f));
                    this.m_5634_(3.0f);
                }
                MiscUtil.sendAnimationPacket((Level)this.m_9236_(), (int)0, (int)this.m_19879_(), (ResourceLocation)this.BLOCK_HURT.getId());
                return false;
            }
        }
        if (source.m_269533_(DamageTypeTags.f_268549_) || source.m_269533_(DamageTypeTags.f_268745_) || source.m_269533_(DamageTypeTags.f_268415_) || source.m_269533_(DamageTypeTags.f_268524_)) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    protected void m_6153_() {
        this.playAnimationIfStopped((LivingEntity)this, this.DEATH);
        this.setAttacking(false);
        this.setAttackTick(0);
        ++this.f_20919_;
        if (this.f_20919_ == 1) {
            for (VzlingAnimation animation : this.getAnimations()) {
                if (this.shouldPlayAnimation((LivingEntity)this, animation)) continue;
                this.stopAnimation((LivingEntity)this, animation);
            }
            MiscUtil.startShake((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)32.0, (float)2.0f, (int)90);
        }
        if (this.f_20919_ <= 90) {
            this.m_20334_(0.0, 0.05, 0.0);
        }
        if (this.f_20919_ == 120) {
            MiscUtil.startShake((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)32.0, (float)12.0f, (int)15);
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 8.0f, Level.ExplosionInteraction.MOB);
            }
            this.m_9236_().m_7106_((ParticleOptions)HBParticle.RIPPLE.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
        if (this.f_20919_ >= 120 && !this.m_9236_().m_5776_() && !this.m_213877_()) {
            this.m_9236_().m_7605_((Entity)this, (byte)60);
            this.m_9236_().m_7731_(this.m_20183_(), (BlockState)((Block)HBBlock.ENFORCER_TREASURE_CHEST.get()).m_49966_().m_61124_((Property)EnforcerTreasureChestBlock.f_56183_, (Comparable)this.m_6350_()), 3);
            BlockEntity blockEntity = this.m_9236_().m_7702_(this.m_20183_());
            if (blockEntity instanceof EnforcerTreasureChestBlockEntity) {
                EnforcerTreasureChestBlockEntity chestBlockEntity = (EnforcerTreasureChestBlockEntity)blockEntity;
                chestBlockEntity.m_59626_(ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"chests/enforcer_treasure_chest"), this.f_19796_.m_188505_());
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_7090_() {
        return this.getAttackType() == 14 && this.isAttacking() && this.getAttackTick() >= 20 && this.getAttackTick() < 470;
    }

    public boolean shouldPlayAnimation(LivingEntity entity, VzlingAnimation animation) {
        if (animation == this.DEATH) {
            return true;
        }
        return super.shouldPlayAnimation(entity, animation);
    }

    public int getDamageTime() {
        return (Integer)HBConfig.COMMON_CONFIG.hadeanEnforcerDamageTime.get();
    }

    public float getDamageMap() {
        return ((Double)HBConfig.COMMON_CONFIG.hadeanEnforcerDamageCap.get()).floatValue();
    }
}

