/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.client.event;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.LerpingBossEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ComputeFovModifierEvent;
import net.minecraftforge.client.event.CustomizeGuiOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import vzling.hadean.breathe.entity.HadeanBlasterEntity;
import vzling.hadean.breathe.entity.HadeanEnforcerEntity;

@Mod.EventBusSubscriber(modid="hadean_breathe", value={Dist.CLIENT})
public class HEClientEvent {
    public static final Set<Mob> BOSSES = Collections.newSetFromMap(new WeakHashMap());

    @SubscribeEvent
    public static void renderBossBar(CustomizeGuiOverlayEvent.BossEventProgress event) {
        ResourceLocation outside;
        ResourceLocation inner;
        ResourceLocation innerEmpty;
        HadeanEnforcerEntity entity;
        LerpingBossEvent bossEvent = event.getBossEvent();
        Mob boss = null;
        if (BOSSES.isEmpty()) {
            return;
        }
        for (Mob mob : BOSSES) {
            if (!mob.m_20148_().equals(bossEvent.m_18860_())) continue;
            boss = mob;
            break;
        }
        GuiGraphics guiGraphics = event.getGuiGraphics();
        MutableComponent component = event.getBossEvent().m_18861_().m_6881_().m_130940_(ChatFormatting.DARK_RED);
        int barX = event.getX() - 10;
        int barY = event.getY() - 7;
        int textWidth = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)component);
        int textX = Minecraft.m_91087_().m_91268_().m_85445_() / 2 - textWidth / 2;
        int textY = event.getY() - 10;
        if (boss instanceof HadeanEnforcerEntity && (entity = (HadeanEnforcerEntity)boss).getPhase() == 2) {
            barX = (int)((double)barX + (Math.random() * 2.0 - 1.0));
            barY = (int)((double)barY + (Math.random() * 2.0 - 1.0));
            textX = (int)((double)textX + (Math.random() * 2.0 - 1.0));
            textY = (int)((double)textY + (Math.random() * 2.0 - 1.0));
        }
        if (boss instanceof HadeanEnforcerEntity) {
            innerEmpty = ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/gui/hadean_enforcer_bar_inner_empty.png");
            inner = ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/gui/hadean_enforcer_bar_inner.png");
            outside = ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/gui/hadean_enforcer_bar_outside.png");
        } else if (boss instanceof HadeanBlasterEntity) {
            innerEmpty = ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/gui/hadean_blaster_bar_inner_empty.png");
            inner = ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/gui/hadean_blaster_bar_inner.png");
            outside = ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/gui/hadean_blaster_bar_outside.png");
        } else {
            innerEmpty = null;
            inner = null;
            outside = null;
        }
        if (boss != null) {
            event.setCanceled(true);
            if (innerEmpty != null) {
                guiGraphics.m_280163_(innerEmpty, barX, barY, 0.0f, 0.0f, 202, 19, 202, 19);
            }
            if (inner != null) {
                guiGraphics.m_280163_(inner, barX, barY, 0.0f, 0.0f, (int)(event.getBossEvent().m_142717_() * 183.0f), 19, 202, 19);
            }
            if (outside != null) {
                guiGraphics.m_280163_(outside, barX, barY, 0.0f, 0.0f, 202, 19, 202, 19);
            }
            guiGraphics.m_280430_(Minecraft.m_91087_().f_91062_, (Component)component, textX, textY, 0xFFFFFF);
        }
    }

    @SubscribeEvent
    public static void computeFov(ComputeFovModifierEvent event) {
        ItemStack stack = event.getPlayer().m_21205_();
    }
}

