/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.ItemInHandLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4f;
import vzling.hadean.breathe.client.layer.HadeanEnforcerEntityArmorLayer;
import vzling.hadean.breathe.client.model.HadeanEnforcerEntityModel;
import vzling.hadean.breathe.entity.HadeanEnforcerEntity;
import vzling.lib.client.renderer.GeoEntityRenderer;

public class HadeanEnforcerEntityRenderer<T extends HadeanEnforcerEntity>
extends GeoEntityRenderer<T, HadeanEnforcerEntityModel<T>> {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public HadeanEnforcerEntityRenderer(EntityRendererProvider.Context context) {
        super(context, new HadeanEnforcerEntityModel(), 0.5f);
        this.m_115326_((RenderLayer)new ItemInHandLayer((RenderLayerParent)this, context.m_234598_()));
        this.m_115326_((RenderLayer)new HadeanEnforcerEntityArmorLayer(this, context.m_174027_()));
    }

    private static void vertex01(VertexConsumer vertexConsumer, Matrix4f matrix4f, int i) {
        vertexConsumer.m_252986_(matrix4f, 0.0f, 0.0f, 0.0f).m_6122_(121, 0, 44, i).m_5752_();
    }

    private static void vertex2(VertexConsumer vertexConsumer, Matrix4f matrix4f, float f, float g) {
        vertexConsumer.m_252986_(matrix4f, -HALF_SQRT_3 * g, f, -0.5f * g).m_6122_(121, 0, 44, 0).m_5752_();
    }

    private static void vertex3(VertexConsumer vertexConsumer, Matrix4f matrix4f, float f, float g) {
        vertexConsumer.m_252986_(matrix4f, HALF_SQRT_3 * g, f, -0.5f * g).m_6122_(121, 0, 44, 0).m_5752_();
    }

    private static void vertex4(VertexConsumer vertexConsumer, Matrix4f matrix4f, float f, float g) {
        vertexConsumer.m_252986_(matrix4f, 0.0f, f, g).m_6122_(121, 0, 44, 0).m_5752_();
    }

    @NotNull
    public ResourceLocation getTextureLocation(@NotNull T entity) {
        if (entity.m_7755_().getString().equals("Golden")) {
            if (entity.getAttackType() == 4 && entity.getAttackTick() >= 10 && entity.getAttackTick() <= 80 || entity.getAttackType() == 8 && entity.getAttackTick() >= 35 && entity.getAttackTick() <= 105) {
                return ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/entity/hadean_enforcer_golden_barrage.png");
            }
            return ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/entity/hadean_enforcer_golden.png");
        }
        if (entity.getAttackType() == 4 && entity.getAttackTick() >= 10 && entity.getAttackTick() <= 80 || entity.getAttackType() == 8 && entity.getAttackTick() >= 35 && entity.getAttackTick() <= 105) {
            return ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/entity/hadean_enforcer_barrage.png");
        }
        return ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"textures/entity/hadean_enforcer.png");
    }

    protected float getFlipDegrees(@NotNull T entity) {
        return 0.0f;
    }

    protected float getWhiteOverlayProgress(T entity, float partialTick) {
        if ((float)((HadeanEnforcerEntity)((Object)entity)).f_20919_ > 94.0f) {
            return 0.0f;
        }
        if (entity.getAttackType() == 11 && entity.getAttackTick() >= 40 && entity.getAttackTick() <= 115 || entity.getAttackType() == 13 && entity.getAttackTick() >= 17 && entity.getAttackTick() <= 43) {
            float progress = ((float)((HadeanEnforcerEntity)((Object)entity)).f_19797_ + partialTick) / 10.0f % 2.0f;
            if (progress > 1.0f) {
                return (1.0f - (progress - 1.0f)) * 0.7f;
            }
            return progress * 0.7f;
        }
        return super.m_6931_(entity, partialTick) * Math.min(((float)((HadeanEnforcerEntity)((Object)entity)).f_20919_ + partialTick) / 94.0f, 1.0f);
    }

    public void render(@NotNull T entity, float entityYaw, float partialTick, @NotNull PoseStack stack, @NotNull MultiBufferSource bufferSource, int light) {
        super.m_7392_(entity, entityYaw, partialTick, stack, bufferSource, light);
        if (((HadeanEnforcerEntity)((Object)entity)).f_20919_ > 0) {
            float l = ((float)((HadeanEnforcerEntity)((Object)entity)).f_20919_ + partialTick) / 94.0f;
            float m = Math.min(l > 0.8f ? (l - 0.8f) / 0.2f : 0.0f, 1.0f);
            RandomSource randomSource = RandomSource.m_216335_((long)432L);
            VertexConsumer vertexConsumer4 = bufferSource.m_6299_(RenderType.m_110502_());
            stack.m_85836_();
            stack.m_252880_(0.0f, 1.25f, 0.0f);
            int n = 0;
            while ((float)n < (l + l * l) / 6.0f * 60.0f) {
                stack.m_252781_(Axis.f_252529_.m_252977_(randomSource.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(randomSource.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(randomSource.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252529_.m_252977_(randomSource.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(randomSource.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(randomSource.m_188501_() * 360.0f + l * 90.0f));
                float o = randomSource.m_188501_() * 20.0f + 5.0f + m * 10.0f;
                float p = randomSource.m_188501_() * 2.0f + 1.0f + m * 2.0f;
                Matrix4f matrix4f = stack.m_85850_().m_252922_();
                int q = (int)(255.0f * (1.0f - m));
                HadeanEnforcerEntityRenderer.vertex01(vertexConsumer4, matrix4f, q);
                HadeanEnforcerEntityRenderer.vertex2(vertexConsumer4, matrix4f, o, p);
                HadeanEnforcerEntityRenderer.vertex3(vertexConsumer4, matrix4f, o, p);
                HadeanEnforcerEntityRenderer.vertex01(vertexConsumer4, matrix4f, q);
                HadeanEnforcerEntityRenderer.vertex3(vertexConsumer4, matrix4f, o, p);
                HadeanEnforcerEntityRenderer.vertex4(vertexConsumer4, matrix4f, o, p);
                HadeanEnforcerEntityRenderer.vertex01(vertexConsumer4, matrix4f, q);
                HadeanEnforcerEntityRenderer.vertex4(vertexConsumer4, matrix4f, o, p);
                HadeanEnforcerEntityRenderer.vertex2(vertexConsumer4, matrix4f, o, p);
                ++n;
            }
            stack.m_85849_();
        }
    }

    protected void setupRotations(@NotNull T entity, @NotNull PoseStack stack, float ageInTicks, float rotationYaw, float partialTicks) {
        super.m_7523_(entity, stack, ageInTicks, rotationYaw, partialTicks);
        if (!entity.isSpawned() && ((HadeanEnforcerEntity)((Object)entity)).hasSpawnProcess()) {
            entity.playAnimationIfStopped(entity, ((HadeanEnforcerEntity)((Object)entity)).SPAWN);
        }
    }

    protected void scale(@NotNull T entity, @NotNull PoseStack stack, float partialTicks) {
        super.m_7546_(entity, stack, partialTicks);
        stack.m_85841_(1.25f, 1.25f, 1.25f);
        if (entity.getAttackType() == 11 && entity.getAttackTick() >= 40 && entity.getAttackTick() <= 115 || entity.getAttackType() == 13 && entity.getAttackTick() >= 17 && entity.getAttackTick() <= 43) {
            stack.m_85841_(Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.98f, (float)1.02f), Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.98f, (float)1.02f), Mth.m_216267_((RandomSource)entity.m_217043_(), (float)0.98f, (float)1.02f));
        }
    }
}

