/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.entity;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.BossEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.hadean.breathe.client.event.HEClientEvent;
import vzling.hadean.breathe.entity.boss_event.HEServerBossEvent;
import vzling.hadean.breathe.init.HBItem;
import vzling.lib.entity.BossEntity;
import vzling.lib.entity.IAttackEntity;
import vzling.lib.entity.attack.AttackManager;

public class HadeanBlasterEntity
extends BossEntity {
    private final HEServerBossEvent bossEvent = new HEServerBossEvent((Mob)this, BossEvent.BossBarColor.RED, true);
    private int waitTick = 0;

    public HadeanBlasterEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
        if (level.f_46443_) {
            HEClientEvent.BOSSES.add((Mob)this);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 250.0).m_22268_(Attributes.f_22281_, 7.0).m_22268_(Attributes.f_22284_, 16.0).m_22268_(Attributes.f_22279_, 0.35).m_22268_(Attributes.f_22277_, 1024.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_8119_() {
        super.m_8119_();
    }

    public void m_8107_() {
        super.m_8107_();
        this.bossEvent.m_142711_(this.m_21223_() / this.m_21233_());
        if (!this.m_9236_().f_46443_ && !this.m_21525_() && this.m_6084_()) {
            if (this.m_5448_() == null) {
                if (this.waitTick < 600) {
                    ++this.waitTick;
                } else if (this.f_19797_ % 20 == 0) {
                    this.m_5634_(5.0f);
                }
            } else {
                this.waitTick = 0;
            }
        }
    }

    public void m_7350_(EntityDataAccessor<?> accessor) {
        if (accessor.equals((Object)ATTACKING) && this.isAttacking()) {
            this.stopAllAnimStates();
            this.getAttackType();
        }
        super.m_7350_(accessor);
    }

    private void stopAllAnimStates() {
    }

    public void m_6457_(@NotNull ServerPlayer player) {
        super.m_6457_(player);
        this.bossEvent.m_6543_(player);
    }

    public void m_6452_(@NotNull ServerPlayer player) {
        super.m_6452_(player);
        this.bossEvent.m_6539_(player);
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        this.bossEvent.setId(this.m_20148_());
    }

    public void updatePhase() {
    }

    public void spawn() {
    }

    public boolean hasSpawnProcess() {
        return false;
    }

    public void selectAttackType() {
    }

    public AttackManager<? extends IAttackEntity> getAttackManager() {
        return null;
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        if (source.m_269533_(DamageTypeTags.f_268549_) || source.m_269533_(DamageTypeTags.f_268745_) || source.m_269533_(DamageTypeTags.f_268415_) || source.m_269533_(DamageTypeTags.f_268524_)) {
            return false;
        }
        return super.m_6469_(source, Math.min(amount, 12.0f));
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor levelAccessor, DifficultyInstance instance, MobSpawnType spawnType, @Nullable SpawnGroupData groupData, @Nullable CompoundTag tag) {
        this.m_8061_(EquipmentSlot.MAINHAND, ((Item)HBItem.FURY.get()).m_7968_());
        return super.m_6518_(levelAccessor, instance, spawnType, groupData, tag);
    }
}

