/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.block.entity;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import vzling.hadean.breathe.entity.HadeanEnforcerEntity;
import vzling.hadean.breathe.init.HBBlockEntity;
import vzling.hadean.breathe.init.HBEntity;
import vzling.hadean.breathe.init.HBItem;
import vzling.lib.client.particle.TrailParticle;
import vzling.lib.util.MiscUtil;

public class EnforcerAltarBlockEntity
extends BlockEntity {
    private boolean summoning = false;
    private int summonTick = 0;
    private ItemEntity summonItem;

    public EnforcerAltarBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)HBBlockEntity.ENFORCER_ALTAR.get(), pos, state);
    }

    public static void tick(Level level, BlockPos pos, BlockState state, EnforcerAltarBlockEntity blockEntity) {
        if (!level.f_46443_) {
            if (!blockEntity.isSummoning()) {
                List itemEntities;
                if (blockEntity.getSummonTick() < 20 && blockEntity.getSummonItem() == null && !(itemEntities = level.m_6443_(ItemEntity.class, new AABB(pos.m_7494_()), item -> item.m_32055_().m_150930_((Item)HBItem.HADEAN_ECHO.get()))).isEmpty()) {
                    blockEntity.setSummonItem((ItemEntity)itemEntities.get(0));
                    blockEntity.setSummoning(true);
                }
            } else {
                blockEntity.setSummonTick(blockEntity.getSummonTick() + 1);
                if (!blockEntity.getSummonItem().m_213877_()) {
                    if (blockEntity.getSummonTick() == 20) {
                        blockEntity.getSummonItem().m_32062_();
                        blockEntity.getSummonItem().m_20242_(true);
                        blockEntity.getSummonItem().m_146915_(true);
                        blockEntity.getSummonItem().m_20331_(true);
                    }
                    if (blockEntity.getSummonTick() == 20) {
                        blockEntity.getSummonItem().m_216990_(SoundEvents.f_11736_);
                    }
                    if (blockEntity.getSummonTick() >= 20 && blockEntity.getSummonTick() < 80) {
                        blockEntity.getSummonItem().m_20334_(0.0, 0.05, 0.0);
                        blockEntity.getSummonItem().f_19864_ = true;
                    }
                    if (blockEntity.getSummonTick() == 80) {
                        blockEntity.getSummonItem().m_20334_(0.0, 0.0, 0.0);
                        blockEntity.getSummonItem().f_19864_ = true;
                    }
                    if (blockEntity.getSummonTick() == 100) {
                        level.m_5594_(null, pos, SoundEvents.f_11860_, SoundSource.BLOCKS, 1.0f, 1.0f);
                        MiscUtil.startShake((Level)level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)32.0, (float)4.0f, (int)20);
                        if (level instanceof ServerLevel) {
                            ServerLevel serverLevel = (ServerLevel)level;
                            for (int i = 0; i < 10; ++i) {
                                serverLevel.m_8767_((ParticleOptions)new TrailParticle.ColorData(255, 0, 0), (double)pos.m_123341_() + 0.25, (double)pos.m_123342_() + 0.25, (double)pos.m_123343_() + 0.25, 0, (double)pos.m_123341_() + (level.f_46441_.m_188500_() * 8.0 - 4.0) + 0.25, (double)pos.m_123342_() + (level.f_46441_.m_188500_() * 8.0 - 4.0) + 0.25, (double)pos.m_123343_() + (level.f_46441_.m_188500_() * 8.0 - 4.0) + 0.25, 1.0);
                            }
                        }
                        level.m_46961_(pos, false);
                        HadeanEnforcerEntity entity = new HadeanEnforcerEntity(HBEntity.HADEAN_ENFORCER.get(), level);
                        entity.m_146884_(pos.m_252807_().m_82520_(0.0, -0.5, 0.0));
                        level.m_7967_((Entity)entity);
                        blockEntity.setSummoning(false);
                        blockEntity.setSummonTick(0);
                        blockEntity.getSummonItem().m_146870_();
                    }
                }
            }
            if (blockEntity.getSummonItem() != null && blockEntity.getSummonItem().m_213877_()) {
                blockEntity.setSummoning(false);
                blockEntity.setSummonTick(0);
                blockEntity.setSummonItem(null);
            }
        }
    }

    public boolean isSummoning() {
        return this.summoning;
    }

    public void setSummoning(boolean summoning) {
        this.summoning = summoning;
    }

    public int getSummonTick() {
        return this.summonTick;
    }

    public void setSummonTick(int summonTick) {
        this.summonTick = summonTick;
    }

    public ItemEntity getSummonItem() {
        return this.summonItem;
    }

    public void setSummonItem(ItemEntity summonItem) {
        this.summonItem = summonItem;
    }
}

