/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.client.particle;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Locale;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vzling.hadean.breathe.init.HBParticle;

@OnlyIn(value=Dist.CLIENT)
public class EyeTrailParticle
extends vzling.lib.client.particle.EyeTrailParticle {
    public EyeTrailParticle(ClientLevel world, double x, double y, double z, int r, int g, int b, int entityId, double offset) {
        super(world, x, y, z, r, g, b, entityId, offset);
    }

    public void m_5989_() {
        Player player;
        Entity entity = this.f_107208_.m_6815_(this.getEntityId());
        if (entity != null && entity instanceof Player && (player = (Player)entity).m_6844_(EquipmentSlot.CHEST).m_41784_().m_128451_("demonTime") == 0) {
            this.m_107274_();
        }
        super.m_5989_();
    }

    public record ColorData(int r, int g, int b, int entityId, double offset) implements ParticleOptions
    {
        public static final ParticleOptions.Deserializer<ColorData> DESERIALIZER = new ParticleOptions.Deserializer<ColorData>(){

            @NotNull
            public ColorData fromCommand(@NotNull ParticleType<ColorData> particleTypeIn, StringReader reader) throws CommandSyntaxException {
                reader.expect(' ');
                int r = reader.readInt();
                reader.expect(' ');
                int g = reader.readInt();
                reader.expect(' ');
                int b = reader.readInt();
                reader.expect(' ');
                int entityId = reader.readInt();
                reader.expect(' ');
                double offset = reader.readDouble();
                return new ColorData(r, g, b, entityId, offset);
            }

            @NotNull
            public ColorData fromNetwork(@NotNull ParticleType<ColorData> particleTypeIn, FriendlyByteBuf buffer) {
                return new ColorData(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readDouble());
            }
        };

        public static Codec<ColorData> CODEC() {
            return RecordCodecBuilder.create(codecBuilder -> codecBuilder.group((App)Codec.INT.fieldOf("r").forGetter(ColorData::r), (App)Codec.INT.fieldOf("g").forGetter(ColorData::g), (App)Codec.INT.fieldOf("b").forGetter(ColorData::b), (App)Codec.INT.fieldOf("entityId").forGetter(ColorData::entityId), (App)Codec.DOUBLE.fieldOf("offset").forGetter(ColorData::offset)).apply((Applicative)codecBuilder, ColorData::new));
        }

        public void m_7711_(FriendlyByteBuf buffer) {
            buffer.writeInt(this.r);
            buffer.writeInt(this.g);
            buffer.writeInt(this.b);
            buffer.writeInt(this.entityId);
            buffer.writeDouble(this.offset);
        }

        @NotNull
        public String m_5942_() {
            return String.format(Locale.ROOT, "%s %d %d %d %d %.2f", BuiltInRegistries.f_257034_.m_7981_(this.m_6012_()), this.r, this.g, this.b, this.entityId, this.offset);
        }

        @NotNull
        public ParticleType<ColorData> m_6012_() {
            return HBParticle.EYE_TRAIL.get();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<ColorData> {
        public Particle createParticle(ColorData data, @NotNull ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new EyeTrailParticle(level, x, y, z, data.r(), data.g(), data.b(), data.entityId(), data.offset());
        }
    }
}

