/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.entity;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Targeting;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vzling.hadean.breathe.entity.HadeanFireballEntity;
import vzling.hadean.breathe.init.HBEntity;
import vzling.lib.client.particle.SpinTrailParticle;
import vzling.lib.client.particle.TrailParticle;
import vzling.lib.entity.AbstractSkillEntity;
import vzling.lib.init.ParticleInit;
import vzling.lib.init.SoundEventInit;
import vzling.lib.util.MiscUtil;

public class HadeanGhastEntity
extends Monster
implements TraceableEntity {
    public static final EntityDataAccessor<Boolean> IS_DUCK = SynchedEntityData.m_135353_(HadeanGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> CHARGING = SynchedEntityData.m_135353_(HadeanGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> SPAWNED = SynchedEntityData.m_135353_(HadeanGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> REMOVE_TIME = SynchedEntityData.m_135353_(HadeanGhastEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    private UUID ownerUUID;
    @Nullable
    private Entity cachedOwner;
    private int shootTime = 0;

    public HadeanGhastEntity(EntityType<? extends Monster> type, Level level) {
        super(type, level);
    }

    public HadeanGhastEntity(Level level, LivingEntity owner, boolean isDuck) {
        super(HBEntity.HADEAN_GHAST.get(), level);
        this.setOwner((Entity)owner);
        this.m_146884_(owner.m_20182_());
        this.m_146922_(owner.f_20883_);
        this.f_20883_ = this.m_146908_();
        this.f_20885_ = this.m_146908_();
        this.setDuck(isDuck);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 50.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(CHARGING, (Object)false);
        this.f_19804_.m_135372_(SPAWNED, (Object)false);
        this.f_19804_.m_135372_(REMOVE_TIME, (Object)0);
        this.f_19804_.m_135372_(IS_DUCK, (Object)false);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            AbstractSkillEntity skillEntity;
            Entity i2;
            if (!this.isSpawned() && this.f_19797_ >= 100) {
                this.setSpawned(true);
                this.m_216990_(this.isDuck() ? (SoundEvent)SoundEventInit.DUCK.get() : SoundEvents.f_11860_);
            }
            if (!this.isSpawned()) {
                Level level;
                if (this.f_19797_ % 60 == Mth.m_216271_((RandomSource)this.f_19796_, (int)20, (int)60)) {
                    this.m_216990_(SoundEvents.f_11919_);
                }
                if ((level = this.m_9236_()) instanceof ServerLevel) {
                    ServerLevel level2 = (ServerLevel)level;
                    for (int i2 = 0; i2 < 4; ++i2) {
                        level2.m_8767_((ParticleOptions)new TrailParticle.ColorData(255, 0, 0), this.m_20185_() + (level2.f_46441_.m_188500_() * 24.0 - 12.0), this.m_20186_() + (level2.f_46441_.m_188500_() * 24.0 - 12.0) + 4.0, this.m_20189_() + (level2.f_46441_.m_188500_() * 24.0 - 12.0), 0, this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_ + 4.0, this.m_20189_() + this.m_20184_().f_82481_, 1.0);
                        level2.m_8767_((ParticleOptions)new SpinTrailParticle.SpinData(0, 0, 0), this.m_20185_() + (level2.f_46441_.m_188500_() * 24.0 - 12.0), this.m_20186_() + (level2.f_46441_.m_188500_() * 24.0 - 12.0) + 4.0, this.m_20189_() + (level2.f_46441_.m_188500_() * 24.0 - 12.0), 0, this.m_20185_() + this.m_20184_().f_82479_, this.m_20186_() + this.m_20184_().f_82480_ + 4.0, this.m_20189_() + this.m_20184_().f_82481_, 1.0);
                    }
                }
            }
            if ((this.m_19749_() == null || !this.m_19749_().m_6084_() || this.m_5448_() == null || !this.m_5448_().m_6084_() || (i2 = this.m_19749_()) instanceof AbstractSkillEntity && !(skillEntity = (AbstractSkillEntity)i2).isUsingSkill()) && this.m_6084_()) {
                this.m_146870_();
            }
            if (this.m_19749_() != null) {
                this.m_146884_(this.m_19749_().m_20182_().m_82520_(0.0, 8.0, 0.0));
            }
            if (this.isCharging() && this.m_5448_() != null && this.m_6084_()) {
                HadeanGhastEntity hadeanGhastEntity;
                this.m_216990_(SoundEvents.f_11705_);
                this.m_216990_(this.isDuck() ? (SoundEvent)SoundEventInit.DUCK.get() : SoundEvents.f_11924_);
                this.m_21391_((Entity)this.m_5448_(), 360.0f, 360.0f);
                this.f_20883_ = this.m_146908_();
                this.f_20885_ = this.m_146908_();
                Vec3 vec = this.m_5448_().m_20182_().m_82546_(this.m_20182_()).m_82549_(this.isDuck() ? new Vec3(this.m_217043_().m_188500_() - 0.5, this.m_217043_().m_188500_() - 0.5, this.m_217043_().m_188500_() - 0.5) : new Vec3(this.m_217043_().m_188500_() * 2.0 - 1.0, this.m_217043_().m_188500_() * 2.0 - 1.0, this.m_217043_().m_188500_() * 2.0 - 1.0)).m_82541_().m_82490_(1.5);
                Entity entity = this.m_19749_();
                if (entity instanceof LivingEntity) {
                    LivingEntity owner = (LivingEntity)entity;
                    hadeanGhastEntity = owner;
                } else {
                    hadeanGhastEntity = this;
                }
                HadeanFireballEntity fireballEntity = new HadeanFireballEntity((LivingEntity)hadeanGhastEntity, vec.m_7096_(), vec.m_7098_(), vec.m_7094_(), this.m_9236_(), this.isDuck());
                fireballEntity.m_146884_(this.m_20182_().m_82520_(0.0, 0.5, 0.0));
                this.m_9236_().m_7967_((Entity)fireballEntity);
            }
            if (this.isCharging()) {
                ++this.shootTime;
            }
            if (this.shootTime >= 40) {
                this.setCharging(false);
                this.shootTime = 0;
            }
            if (this.getRemoveTime() > 0) {
                this.setRemoveTime(this.getRemoveTime() - 1);
                if (this.getRemoveTime() == 0) {
                    this.m_146870_();
                }
            }
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_269533_(DamageTypeTags.f_268738_)) {
            return super.m_6469_(source, amount);
        }
        if (this.isCharging() || this.getRemoveTime() > 0) {
            return false;
        }
        return super.m_6469_(source, Math.min(amount, 10.0f));
    }

    @Nullable
    public Entity m_19749_() {
        Level level;
        if (this.cachedOwner != null && !this.cachedOwner.m_213877_()) {
            return this.cachedOwner;
        }
        if (this.ownerUUID != null && (level = this.m_9236_()) instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            this.cachedOwner = level2.m_8791_(this.ownerUUID);
            return this.cachedOwner;
        }
        return null;
    }

    public void setOwner(@Nullable Entity entity) {
        if (entity != null) {
            this.ownerUUID = entity.m_20148_();
            this.cachedOwner = entity;
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        super.m_7380_(tag);
        if (this.ownerUUID != null) {
            tag.m_128362_("Owner", this.ownerUUID);
        }
        tag.m_128379_("Spawned", this.isSpawned());
        tag.m_128379_("IsDuck", this.isDuck());
    }

    public void m_7378_(@NotNull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128403_("Owner")) {
            this.ownerUUID = tag.m_128342_("Owner");
            this.cachedOwner = null;
        }
        if (tag.m_128441_("Spawned")) {
            this.setSpawned(tag.m_128471_("Spawned"));
        }
        if (tag.m_128441_("IsDuck")) {
            this.setDuck(tag.m_128471_("IsDuck"));
        }
    }

    public LivingEntity m_5448_() {
        Targeting targeting;
        Entity entity = this.m_19749_();
        if (entity instanceof Targeting && (targeting = (Targeting)entity).m_5448_() != null) {
            return targeting.m_5448_();
        }
        return super.m_5448_();
    }

    public boolean isCharging() {
        return (Boolean)this.f_19804_.m_135370_(CHARGING);
    }

    public void setCharging(boolean charging) {
        this.f_19804_.m_135381_(CHARGING, (Object)charging);
    }

    public boolean isSpawned() {
        return (Boolean)this.f_19804_.m_135370_(SPAWNED);
    }

    public void setSpawned(boolean spawned) {
        this.f_19804_.m_135381_(SPAWNED, (Object)spawned);
    }

    public int getRemoveTime() {
        return (Integer)this.f_19804_.m_135370_(REMOVE_TIME);
    }

    public void setRemoveTime(int removeTime) {
        this.f_19804_.m_135381_(REMOVE_TIME, (Object)removeTime);
    }

    public float m_6100_() {
        return 0.6f;
    }

    protected SoundEvent m_7515_() {
        return this.isDuck() ? (SoundEvent)SoundEventInit.DUCK.get() : SoundEvents.f_11919_;
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource source) {
        return this.isDuck() ? (SoundEvent)SoundEventInit.DUCK.get() : SoundEvents.f_11921_;
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11920_;
    }

    public boolean m_20068_() {
        return true;
    }

    protected void m_6153_() {
        super.m_6153_();
        if (this.f_20919_ == 20) {
            MiscUtil.startShake((Level)this.m_9236_(), (double)this.m_20185_(), (double)this.m_20186_(), (double)this.m_20189_(), (double)32.0, (float)12.0f, (int)15);
            if (!this.m_9236_().f_46443_) {
                this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 8.0f, Level.ExplosionInteraction.MOB);
            }
            this.m_9236_().m_7106_(this.isDuck() ? (ParticleOptions)ParticleInit.DUCK_LARGE_HORIZONTAL_RIPPLE.get() : (ParticleOptions)ParticleInit.LARGE_HORIZONTAL_RIPPLE.get(), this.m_20185_(), this.m_20186_(), this.m_20189_(), 0.0, 0.0, 0.0);
        }
    }

    public void remove() {
        this.setRemoveTime(20);
    }

    public boolean isDuck() {
        return (Boolean)this.f_19804_.m_135370_(IS_DUCK);
    }

    public void setDuck(boolean duck) {
        this.f_19804_.m_135381_(IS_DUCK, (Object)duck);
    }
}

