/*
 * Decompiled with CFR 0.152.
 */
package vzling.hadean.breathe.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import vzling.hadean.breathe.client.animation.HadeanBlasterEntityAnimation;
import vzling.hadean.breathe.entity.HadeanBlasterEntity;
import vzling.lib.client.model.AnimatableEntityModel;

@OnlyIn(value=Dist.CLIENT)
public class HadeanBlasterEntityModel<T extends HadeanBlasterEntity>
extends AnimatableEntityModel<T>
implements ArmedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(ResourceLocation.fromNamespaceAndPath((String)"hadean_breathe", (String)"hadean_blaster"), "main");
    private final ModelPart root;
    private final ModelPart entity;
    private final ModelPart body;
    private final ModelPart body2;
    private final ModelPart cape;
    private final ModelPart right_arm;
    private final ModelPart right_item;
    private final ModelPart left_arm;
    private final ModelPart left_item;
    private final ModelPart head;
    private final ModelPart mask;
    private final ModelPart hat;
    private final ModelPart right_leg;
    private final ModelPart left_leg;

    public HadeanBlasterEntityModel(ModelPart root) {
        this.root = root.m_171324_("root");
        this.entity = this.root.m_171324_("entity");
        this.body = this.entity.m_171324_("body");
        this.body2 = this.body.m_171324_("body2");
        this.cape = this.body2.m_171324_("cape");
        this.right_arm = this.body2.m_171324_("right_arm");
        this.right_item = this.right_arm.m_171324_("right_item");
        this.left_arm = this.body2.m_171324_("left_arm");
        this.left_item = this.left_arm.m_171324_("left_item");
        this.head = this.body2.m_171324_("head");
        this.mask = this.head.m_171324_("mask");
        this.hat = this.head.m_171324_("hat");
        this.right_leg = this.entity.m_171324_("right_leg");
        this.left_leg = this.entity.m_171324_("left_leg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition root = partdefinition.m_171599_("root", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition entity = root.m_171599_("entity", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition body = entity.m_171599_("body", CubeListBuilder.m_171558_(), PartPose.m_171419_((float)0.0f, (float)12.0f, (float)0.0f));
        PartDefinition body2 = body.m_171599_("body2", CubeListBuilder.m_171558_().m_171514_(0, 51).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(24, 57).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.25f)).m_171514_(48, 57).m_171488_(-4.0f, -12.0f, -2.0f, 8.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition cape = body2.m_171599_("cape", CubeListBuilder.m_171558_().m_171514_(64, 0).m_171488_(-5.0f, -0.5f, 1.4f, 10.0f, 16.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-11.5f, (float)0.1f, (float)0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition right_arm = body2.m_171599_("right_arm", CubeListBuilder.m_171558_().m_171514_(64, 17).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(72, 65).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.49f)).m_171514_(80, 25).m_171480_().m_171488_(-4.0f, -3.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.25f)).m_171555_(false).m_171514_(64, 81).m_171480_().m_171488_(-7.0f, -6.0f, 0.0f, 8.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-6.0f, (float)-10.0f, (float)0.0f, (float)-0.7027f, (float)-0.5236f, (float)-0.6155f));
        PartDefinition right_item = right_arm.m_171599_("right_item", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, 8.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = body2.m_171599_("left_arm", CubeListBuilder.m_171558_().m_171514_(16, 73).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.49f)).m_171555_(false).m_171514_(64, 33).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(80, 17).m_171488_(-2.0f, -3.0f, -3.0f, 6.0f, 2.0f, 6.0f, new CubeDeformation(0.25f)).m_171514_(64, 81).m_171488_(0.0f, -6.0f, 0.0f, 8.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)5.0f, (float)-10.0f, (float)-1.0f, (float)-0.899f, (float)0.1841f, (float)0.1872f));
        PartDefinition left_item = left_arm.m_171599_("left_item", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(1.0f, 8.0f, 0.0f, 0.0f, 0.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition head = body2.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 35).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 89).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(0.5f)).m_171514_(32, 89).m_171488_(-4.0f, -8.0f, -4.0f, 8.0f, 8.0f, 8.0f, new CubeDeformation(1.0f)), PartPose.m_171419_((float)0.0f, (float)-12.0f, (float)0.0f));
        PartDefinition mask = head.m_171599_("mask", CubeListBuilder.m_171558_().m_171514_(80, 33).m_171488_(-4.0f, -4.6024f, -1.1387f, 8.0f, 9.0f, 2.0f, new CubeDeformation(0.3f)), PartPose.m_171423_((float)0.0f, (float)-3.2415f, (float)-4.2443f, (float)-0.1309f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r1 = mask.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(24, 54).m_171488_(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)1.6562f, (float)-1.383f, (float)0.553f, (float)-0.4968f, (float)-0.2861f));
        PartDefinition cube_r2 = mask.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(24, 51).m_171488_(-0.5f, -0.5f, -2.0f, 1.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)1.6562f, (float)-1.383f, (float)0.553f, (float)0.4968f, (float)0.2861f));
        PartDefinition cube_r3 = mask.m_171599_("cube_r3", CubeListBuilder.m_171558_().m_171514_(0, 83).m_171488_(-1.0f, -7.0f, 1.0f, 2.0f, 2.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(64, 87).m_171488_(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-2.0f, (float)-3.6024f, (float)-0.1387f, (float)0.676f, (float)0.2909f, (float)-0.4418f));
        PartDefinition cube_r4 = mask.m_171599_("cube_r4", CubeListBuilder.m_171558_().m_171514_(86, 0).m_171488_(-1.0f, -7.0f, -1.0f, 2.0f, 7.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-3.6024f, (float)-0.1387f, (float)0.676f, (float)-0.2909f, (float)0.4418f));
        PartDefinition head_r1 = mask.m_171599_("head_r1", CubeListBuilder.m_171558_().m_171514_(64, 49).m_171488_(-1.0f, -0.5f, -1.0f, 2.0f, 1.0f, 1.0f, new CubeDeformation(0.3f)), PartPose.m_171423_((float)0.0f, (float)0.8976f, (float)-1.4387f, (float)-0.1294f, (float)0.0029f, (float)0.0156f));
        PartDefinition hat = head.m_171599_("hat", CubeListBuilder.m_171558_().m_171514_(0, 18).m_171488_(-8.0f, 0.625f, -8.0f, 16.0f, 1.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(0, 0).m_171488_(-8.0f, -0.375f, -8.0f, 16.0f, 2.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(32, 35).m_171488_(-4.0f, -2.375f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(32, 46).m_171488_(-4.0f, -2.375f, -4.0f, 8.0f, 3.0f, 8.0f, new CubeDeformation(0.25f)), PartPose.m_171423_((float)0.0f, (float)-9.625f, (float)0.0f, (float)-0.1309f, (float)0.0019f, (float)0.0436f));
        PartDefinition cube_r5 = hat.m_171599_("cube_r5", CubeListBuilder.m_171558_().m_171514_(63, 73).m_171488_(0.0f, -3.0f, -8.0f, 0.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)2.0f, (float)-3.0f, (float)0.0f, (float)0.0f, (float)-2.9234f, (float)0.0f));
        PartDefinition right_leg = entity.m_171599_("right_leg", CubeListBuilder.m_171558_().m_171514_(0, 67).m_171488_(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(32, 73).m_171488_(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-1.9f, (float)12.0f, (float)0.0f));
        PartDefinition left_leg = entity.m_171599_("left_leg", CubeListBuilder.m_171558_().m_171514_(72, 49).m_171488_(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(48, 73).m_171480_().m_171488_(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171419_((float)1.9f, (float)12.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public ModelPart root() {
        return this.root;
    }

    public ModelPart getHead() {
        return this.head;
    }

    public void setupWalkAnimation(T entity, float limbSwing, float limbSwingAmount) {
        this.animateWalk(HadeanBlasterEntityAnimation.WALK, limbSwing, limbSwingAmount, 1.5f, 2.0f);
    }

    public void m_6002_(@NotNull HumanoidArm arm, @NotNull PoseStack stack) {
        this.root.m_104299_(stack);
        this.entity.m_104299_(stack);
        this.body.m_104299_(stack);
        this.body2.m_104299_(stack);
        ModelPart armPart = arm == HumanoidArm.LEFT ? this.left_arm : this.right_arm;
        armPart.m_104299_(stack);
        ModelPart itemPart = arm == HumanoidArm.LEFT ? this.left_item : this.right_item;
        itemPart.m_104299_(stack);
    }
}

