/*
 * Decompiled with CFR 0.152.
 */
package com.ringoway.mediumcorefix.mixin;

import com.github.alexmodguy.mediumcore.GameRuleRegistry;
import com.github.alexmodguy.mediumcore.Mediumcore;
import com.github.alexmodguy.mediumcore.MediumcoreTags;
import com.github.alexmodguy.mediumcore.event.CommonEvents;
import com.github.alexmodguy.mediumcore.packet.SyncMediumcoreGameRuleMessage;
import com.ringoway.mediumcorefix.MediumcoreFix;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={CommonEvents.class}, remap=false)
public class MixinCommonEvents {
    @Unique
    private static final String HEALTH_MODIFIER_TAG = "MediumcoreHealthModifier";
    @Unique
    private static final String BASE_HEALTH_TAG = "MediumcoreBaseHealth";
    @Unique
    private static final UUID INITIAL_HEALTH_MODIFIER_UUID = Mth.m_216261_((RandomSource)RandomSource.m_216335_((long)2929292911123L));
    @Unique
    private static final UUID HEALTH_MODIFIER_UUID = Mth.m_216261_((RandomSource)RandomSource.m_216335_((long)111222333441249L));

    @Inject(method={"onEntityJoinLevel(Lnet/minecraftforge/event/entity/EntityJoinLevelEvent;)V"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void fixOnEntityJoinLevel(EntityJoinLevelEvent event, CallbackInfo ci) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            boolean mediumcore;
            Player player = (Player)entity;
            if (!event.getLevel().f_46443_ && (mediumcore = GameRuleRegistry.isMediumCoreMode((GameRules)event.getLevel().m_46469_())) && player instanceof ServerPlayer) {
                Mediumcore.sendNonLocal((Object)new SyncMediumcoreGameRuleMessage(mediumcore), (ServerPlayer)((ServerPlayer)player));
                CompoundTag tag = player.getPersistentData().m_128469_("PlayerPersisted");
                if (!tag.m_128441_(BASE_HEALTH_TAG)) {
                    double startingHealth = (Double)Mediumcore.CONFIG.startingPlayerHealth.get();
                    if (tag.m_128441_(HEALTH_MODIFIER_TAG)) {
                        double oldModifier = tag.m_128459_(HEALTH_MODIFIER_TAG);
                        double migratedBaseHealth = startingHealth + oldModifier;
                        tag.m_128347_(BASE_HEALTH_TAG, migratedBaseHealth);
                        MediumcoreFix.LOGGER.info("Migrated player '{}' health data: oldModifier={}, newBaseHealth={}", (Object)player.m_7755_().getString(), (Object)oldModifier, (Object)migratedBaseHealth);
                    } else {
                        tag.m_128347_(BASE_HEALTH_TAG, startingHealth);
                    }
                    tag.m_128347_(HEALTH_MODIFIER_TAG, 0.0);
                    player.getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
                }
                double baseHealth = tag.m_128459_(BASE_HEALTH_TAG);
                this.mediumcorefix$updateHealth(player, baseHealth);
                ci.cancel();
            }
        }
    }

    @Inject(method={"onLivingDeath"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void fixOnLivingDeath(LivingDeathEvent event, CallbackInfo ci) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_ && GameRuleRegistry.isMediumCoreMode((GameRules)player.m_9236_().m_46469_())) {
                CompoundTag tag = player.getPersistentData().m_128469_("PlayerPersisted");
                double baseHealth = tag.m_128459_(BASE_HEALTH_TAG);
                if (baseHealth <= 0.0) {
                    baseHealth = (Double)Mediumcore.CONFIG.startingPlayerHealth.get();
                }
                double newBaseHealth = Mth.m_14008_((double)(baseHealth - (Double)Mediumcore.CONFIG.healthDecreasePerDeath.get()), (double)((Double)Mediumcore.CONFIG.minimumPlayerHealth.get()), (double)((Double)Mediumcore.CONFIG.maxPlayerHealth.get()));
                tag.m_128347_(BASE_HEALTH_TAG, newBaseHealth);
                player.getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
                MediumcoreFix.LOGGER.debug("Player '{}' died. Base health: {} -> {}", (Object)player.m_7755_().getString(), (Object)baseHealth, (Object)newBaseHealth);
                ci.cancel();
            }
        }
    }

    @Inject(method={"onPlayerRespawn"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void fixOnPlayerRespawn(PlayerEvent.PlayerRespawnEvent event, CallbackInfo ci) {
        if (!event.isEndConquered() && !event.getEntity().m_9236_().f_46443_ && GameRuleRegistry.isMediumCoreMode((GameRules)event.getEntity().m_9236_().m_46469_())) {
            Player player = event.getEntity();
            CompoundTag tag = player.getPersistentData().m_128469_("PlayerPersisted");
            double baseHealth = tag.m_128459_(BASE_HEALTH_TAG);
            if (baseHealth <= 0.0) {
                baseHealth = (Double)Mediumcore.CONFIG.startingPlayerHealth.get();
            }
            this.mediumcorefix$updateHealth(player, baseHealth);
            MediumcoreFix.LOGGER.debug("Player '{}' respawned with base health: {}", (Object)player.m_7755_().getString(), (Object)baseHealth);
            ci.cancel();
        }
    }

    @Inject(method={"onLivingFinishUsingItem"}, at={@At(value="HEAD")}, cancellable=true, remap=false)
    private void fixOnLivingFinishUsingItem(LivingEntityUseItemEvent.Finish event, CallbackInfo ci) {
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (!player.m_9236_().f_46443_ && event.getItem().m_204117_(MediumcoreTags.RESTORES_MAX_HEALTH) && GameRuleRegistry.isMediumCoreMode((GameRules)event.getEntity().m_9236_().m_46469_())) {
                CompoundTag tag = player.getPersistentData().m_128469_("PlayerPersisted");
                double baseHealth = tag.m_128459_(BASE_HEALTH_TAG);
                if (baseHealth <= 0.0) {
                    baseHealth = (Double)Mediumcore.CONFIG.startingPlayerHealth.get();
                }
                double newBaseHealth = Mth.m_14008_((double)(baseHealth + (Double)Mediumcore.CONFIG.healthIncreasePerHeal.get()), (double)((Double)Mediumcore.CONFIG.minimumPlayerHealth.get()), (double)((Double)Mediumcore.CONFIG.maxPlayerHealth.get()));
                tag.m_128347_(BASE_HEALTH_TAG, newBaseHealth);
                player.getPersistentData().m_128365_("PlayerPersisted", (Tag)tag);
                this.mediumcorefix$updateHealth(player, newBaseHealth);
                MediumcoreFix.LOGGER.debug("Player '{}' used healing item. Base health: {} -> {}", (Object)player.m_7755_().getString(), (Object)baseHealth, (Object)newBaseHealth);
                ci.cancel();
            }
        }
    }

    @Unique
    private void mediumcorefix$updateHealth(Player player, double baseHealth) {
        AttributeInstance attribute = player.m_21051_(Attributes.f_22276_);
        if (attribute == null) {
            return;
        }
        attribute.m_22127_(INITIAL_HEALTH_MODIFIER_UUID);
        attribute.m_22127_(HEALTH_MODIFIER_UUID);
        double baseModifier = baseHealth - 20.0;
        if (baseModifier != 0.0) {
            attribute.m_22125_(new AttributeModifier(INITIAL_HEALTH_MODIFIER_UUID, "MediumcoreInitialHealthMod", baseModifier, AttributeModifier.Operation.ADDITION));
        }
        player.m_21153_(Mth.m_14036_((float)player.m_21223_(), (float)1.0f, (float)player.m_21233_()));
    }
}

