/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.api;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import jackdaw.applecrates.Constants;
import jackdaw.applecrates.api.CrateWoodType;
import jackdaw.applecrates.api.exception.WoodException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2960;

public class AppleCrateAPI {
    private static final Set<AppleCrateBuilder> VALUES = new ObjectArraySet();
    private static Map<CrateWoodType, class_2960> texturePathFromWood = new HashMap<CrateWoodType, class_2960>();
    private static Map<CrateWoodType, class_2960> originalPlankBlockForWood = new HashMap<CrateWoodType, class_2960>();

    public static Map<CrateWoodType, class_2960> getTexturePathFromWood() {
        return texturePathFromWood;
    }

    public static Map<CrateWoodType, class_2960> getPlanksResourceLocation() {
        return originalPlankBlockForWood;
    }

    protected static void registerForCrate(AppleCrateBuilder builder) {
        if (!builder.yourModId.equals("applecrates") || !Constants.IS_DATA_GEN) {
            try {
                CrateWoodType wood = CrateWoodType.create(builder.compatModId, builder.yourModId, builder.woodName);
                if (!CrateWoodType.values().noneMatch(wood::equals)) {
                    throw WoodException.INSTANCE.alreadyInList(wood);
                }
                CrateWoodType.register(wood);
                texturePathFromWood.put(wood, builder.getTextureResourceLocation());
                originalPlankBlockForWood.put(wood, builder.getPlanksResourceLocation());
            }
            catch (WoodException e) {
                LogUtils.getLogger().error(e.getMessage());
            }
        }
    }

    public static class AppleCrateBuilder {
        protected final String woodName;
        protected final String yourModId;
        protected final String compatModId;
        protected String subFolder = "";
        protected String parentFolder = "block/";
        protected String planksSuffix = "_planks";
        protected String textureName;
        protected String plankRegistryName = "";
        protected boolean optifineTextureOverride = false;

        public AppleCrateBuilder(String compatModId, String yourModId, String woodName) {
            this.compatModId = compatModId;
            this.woodName = woodName;
            this.yourModId = yourModId;
            this.textureName = woodName;
        }

        protected AppleCrateBuilder(String yourModId, String woodName) {
            this("minecraft", yourModId, woodName);
        }

        public static void registerVanilla() {
        }

        public AppleCrateBuilder withSubfolder(String subfolder) {
            this.subFolder = subfolder;
            return this;
        }

        public AppleCrateBuilder withParentFolder(String parentFolder) {
            this.parentFolder = parentFolder;
            return this;
        }

        public AppleCrateBuilder textureInMinecraftDirectory() {
            this.optifineTextureOverride = true;
            return this;
        }

        public AppleCrateBuilder withSuffix(String planksSuffix) {
            this.planksSuffix = planksSuffix;
            return this;
        }

        public AppleCrateBuilder withTextureName(String textureName) {
            this.textureName = textureName;
            return this;
        }

        public AppleCrateBuilder withBlock(String registryName) {
            this.plankRegistryName = registryName;
            return this;
        }

        public class_2960 getTextureResourceLocation() {
            return new class_2960(this.optifineTextureOverride ? "minecraft" : this.compatModId, this.parentFolder.concat(this.subFolder).concat(this.textureName).concat(this.planksSuffix));
        }

        public class_2960 getPlanksResourceLocation() {
            if (this.plankRegistryName.isEmpty()) {
                boolean same = this.woodName.equals(this.textureName);
                String _plank = this.planksSuffix.isEmpty() ? (same ? "" : "_planks") : this.planksSuffix;
                return new class_2960(this.compatModId, this.woodName.concat(_plank));
            }
            return new class_2960(this.compatModId, this.plankRegistryName);
        }

        public void register() {
            AppleCrateAPI.registerForCrate(this);
        }

        static {
            for (String wood : Constants.VANILLAWOODS) {
                new AppleCrateBuilder("applecrates", wood).register();
            }
        }
    }
}

