/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.block.blockentity;

import jackdaw.applecrates.api.CrateWoodType;
import jackdaw.applecrates.container.IStackHandlerAdapter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2499;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class CrateBlockEntityBase
extends class_2586 {
    public final IStackHandlerAdapter stackHandler;
    public boolean isUnlimitedShop = false;
    private Set<UUID> owners = new HashSet<UUID>();

    public CrateBlockEntityBase(CrateWoodType type, class_2338 pos, class_2680 state, IStackHandlerAdapter stackHandler) {
        super(CrateWoodType.getBlockEntityType(type), pos, state);
        this.stackHandler = stackHandler;
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.loadCrateDataFromTag(tag);
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        this.saveCrateDataToTag(tag);
    }

    public class_2596<class_2602> method_38235() {
        return class_2622.method_38585((class_2586)this);
    }

    public class_2487 method_16887() {
        return this.saveCrateDataToTag(new class_2487());
    }

    protected class_2487 saveCrateDataToTag(class_2487 tag) {
        this.stackHandler.saveInventoryData(tag);
        tag.method_10556("isUnlimited", this.isUnlimitedShop);
        if (!this.owners.isEmpty()) {
            class_2499 ownersTag = this.owners.stream().map(class_2512::method_25929).collect(Collectors.toCollection(class_2499::new));
            tag.method_10566("owner", (class_2520)ownersTag);
        }
        return tag;
    }

    protected void loadCrateDataFromTag(class_2487 tag) {
        this.stackHandler.loadInventoryData(tag);
        if (tag.method_10545("isUnlimited")) {
            this.isUnlimitedShop = tag.method_10577("isUnlimited");
        }
        if (tag.method_10545("owner")) {
            class_2520 owner = tag.method_10580("owner");
            if (owner.method_23258() == class_2495.field_21036) {
                this.owners = new HashSet<UUID>(Collections.singleton(class_2512.method_25930((class_2520)owner)));
            } else if (owner instanceof class_2499) {
                class_2499 ownerList = (class_2499)owner;
                this.owners = ownerList.stream().map(class_2512::method_25930).collect(Collectors.toCollection(HashSet::new));
            }
        }
    }

    public Set<UUID> getOwners() {
        return this.owners;
    }

    public void addOwner(UUID player) {
        this.owners.add(player);
    }

    public boolean isOwner(UUID uuid) {
        return this.owners.isEmpty() || this.owners.contains(uuid);
    }

    public boolean isOwner(@Nullable class_1657 player) {
        return this.owners.isEmpty() || player != null && this.owners.contains(player.method_7334().getId());
    }

    public static int getStockSignal(class_1922 blockLevel, class_2338 pos) {
        class_2586 class_25862;
        if (blockLevel.method_8320(pos).method_31709() && (class_25862 = blockLevel.method_8321(pos)) instanceof CrateBlockEntityBase) {
            CrateBlockEntityBase crate = (CrateBlockEntityBase)class_25862;
            return crate.getStockLevel();
        }
        return 0;
    }

    public int getStockLevel() {
        class_1799 outputStack = this.stackHandler.getSavedTradeSlotsItem(1);
        if (!outputStack.method_7960()) {
            double count = this.stackHandler.getCrateStock().getCountOfItemImmediately(outputStack.method_7909());
            double totalPossible = outputStack.method_7914() * 30;
            double ratio = 15.0 * (count / totalPossible);
            return (int)ratio;
        }
        return 0;
    }
}

