/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.api;

import jackdaw.applecrates.Content;
import jackdaw.applecrates.api.CrateWoodType;
import jackdaw.applecrates.block.CrateBlock;
import jackdaw.applecrates.block.blockentity.CrateBlockEntity;
import jackdaw.applecrates.container.CrateMenuBuyer;
import jackdaw.applecrates.container.CrateMenuBuyerService;
import jackdaw.applecrates.container.CrateMenuOwner;
import jackdaw.applecrates.container.CrateMenuOwnerService;
import jackdaw.applecrates.item.CrateItem;
import jackdaw.applecrates.item.datacomponent.CoinCounter;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.extensions.IMenuTypeExtension;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.jetbrains.annotations.Nullable;

public class GeneralRegistry {
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK, (String)"applecrates");
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((Registry)BuiltInRegistries.ITEM, (String)"applecrates");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITY_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE, (String)"applecrates");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)"applecrates");
    private static final DeferredRegister.DataComponents DATA_COMPONENTS = DeferredRegister.createDataComponents((ResourceKey)Registries.DATA_COMPONENT_TYPE, (String)"applecrates");
    private static final DeferredRegister<CreativeModeTab> TABS = DeferredRegister.create((Registry)BuiltInRegistries.CREATIVE_MODE_TAB, (String)"applecrates");
    private static final List<DeferredHolder<Block, CrateBlock>> TAB_REGISTRY = new ArrayList<DeferredHolder<Block, CrateBlock>>();
    private static final List<DeferredHolder<BlockEntityType<?>, BlockEntityType<CrateBlockEntity>>> CAPABILITY_REGISTRY = new ArrayList();
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> CRATE_TAB = TABS.register("tab.crate", () -> CreativeModeTab.builder((CreativeModeTab.Row)CreativeModeTab.Row.TOP, (int)0).title((Component)Component.translatable((String)"tab.crate")).icon(() -> new ItemStack((ItemLike)CrateWoodType.getBlock(CrateWoodType.values().filter(crateWoodType -> crateWoodType.name().equals("oak")).findFirst().get()))).build());
    public static final BlockCapability<IItemHandler, @Nullable Direction> CRATE_CAPABILITY_HOPPER = BlockCapability.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"applecrates", (String)"crate_hopper_handler"), IItemHandler.class, Direction.class);
    public static final DeferredHolder<MenuType<?>, MenuType<CrateMenuOwner>> CRATE_MENU_OWNER = MENU_TYPES.register("crate_menu_owner", () -> IMenuTypeExtension.create((windowId, inv, data) -> {
        boolean unlimited = data.readBoolean();
        return new CrateMenuOwnerService(windowId, inv, unlimited);
    }));
    public static final DeferredHolder<MenuType<?>, MenuType<CrateMenuBuyer>> CRATE_MENU_BUYER = MENU_TYPES.register("crate_menu_buyer", () -> IMenuTypeExtension.create((windowId, inv, data) -> {
        boolean unlimited = data.readBoolean();
        return new CrateMenuBuyerService(windowId, inv, unlimited);
    }));
    public static final DeferredHolder<DataComponentType<?>, DataComponentType<CoinCounter>> COIN_COUNTER = DATA_COMPONENTS.registerComponentType("coin_counter", builder -> builder.persistent(Content.DATA_COIN_CODEC).networkSynchronized(Content.NETWORK_COIN_CODEC));

    public static void prepareForRegistry(String modId, DeferredRegister<Block> blockRegistry, DeferredRegister<Item> itemRegistry, DeferredRegister<BlockEntityType<?>> beRegistry) {
        CrateWoodType.values().filter(crateWoodType -> crateWoodType.getYourModId().equals(modId)).forEach(crateWoodType -> {
            DeferredHolder block = blockRegistry.register(crateWoodType.getBlockRegistryName(), () -> new CrateBlock((CrateWoodType)crateWoodType));
            itemRegistry.register(crateWoodType.getBlockRegistryName(), () -> new CrateItem((Block)block.get()));
            DeferredHolder be = beRegistry.register(crateWoodType.getBeRegistryName(), () -> BlockEntityType.Builder.of((pos, state) -> new CrateBlockEntity((CrateWoodType)crateWoodType, pos, state), (Block[])new Block[]{(Block)block.get()}).build(null));
            TAB_REGISTRY.add((DeferredHolder<Block, CrateBlock>)block);
            CAPABILITY_REGISTRY.add(be);
        });
    }

    public static void startup() {
        IEventBus bus = ((ModContainer)ModList.get().getModContainerById("applecrates").get()).getEventBus();
        BLOCKS.register(bus);
        ITEMS.register(bus);
        BLOCK_ENTITY_TYPES.register(bus);
        MENU_TYPES.register(bus);
        TABS.register(bus);
        DATA_COMPONENTS.register(bus);
    }

    @EventBusSubscriber(modid="applecrates", bus=EventBusSubscriber.Bus.MOD)
    private class EventHandler {
        private EventHandler(GeneralRegistry generalRegistry) {
        }

        @SubscribeEvent
        public static void addToCreativeTab(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey().equals(CRATE_TAB.getKey())) {
                for (DeferredHolder<Block, CrateBlock> block : TAB_REGISTRY) {
                    event.accept((ItemLike)block.get());
                }
            }
        }

        @SubscribeEvent
        public static void registerCapabilities(RegisterCapabilitiesEvent event) {
            for (DeferredHolder<BlockEntityType<?>, BlockEntityType<CrateBlockEntity>> BE : CAPABILITY_REGISTRY) {
                event.registerBlockEntity(CRATE_CAPABILITY_HOPPER, (BlockEntityType)BE.get(), CrateBlockEntity::getCapability);
            }
        }
    }
}

