/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.block;

import jackdaw.applecrates.Content;
import jackdaw.applecrates.api.CrateWoodType;
import jackdaw.applecrates.block.blockentity.CrateBlockEntityBase;
import jackdaw.applecrates.item.datacomponent.CoinCounter;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrateBlockBase
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    protected static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private final CrateWoodType type;

    public CrateBlockBase(CrateWoodType type) {
        super(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).noOcclusion().isValidSpawn(CrateBlockBase::never).isRedstoneConductor(CrateBlockBase::never).isSuffocating(CrateBlockBase::never).isViewBlocking(CrateBlockBase::never));
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
        this.type = type;
    }

    private static Boolean never(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> type) {
        return false;
    }

    private static boolean never(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }

    public BlockState getStateForPlacement(BlockPlaceContext placeContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)placeContext.getHorizontalDirection());
    }

    public void setPlacedBy(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.setPlacedBy(pLevel, pPos, pState, pPlacer, pStack);
        if (pPlacer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlacer;
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof CrateBlockEntityBase) {
                CrateBlockEntityBase crate = (CrateBlockEntityBase)blockEntity;
                crate.addOwner(serverPlayer.getUUID());
            }
        }
    }

    public int getSignal(BlockState blockState, BlockGetter blockLevel, BlockPos pos, Direction dir) {
        return Mth.clamp((int)CrateBlockEntityBase.getStockSignal(blockLevel, pos), (int)0, (int)15);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState blockState, Level blockLevel, BlockPos pos) {
        return blockState.getSignal((BlockGetter)blockLevel, pos, (Direction)blockState.getValue((Property)FACING));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> stateDef) {
        stateDef.add(new Property[]{FACING});
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return CrateWoodType.getBlockEntityType(this.type).create(pos, state);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.is(pNewState.getBlock())) {
            BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
            if (blockEntity instanceof CrateBlockEntityBase) {
                CrateBlockEntityBase crate = (CrateBlockEntityBase)blockEntity;
                if (pLevel instanceof ServerLevel) {
                    int i;
                    ServerLevel serverLevel = (ServerLevel)pLevel;
                    for (i = 0; i < 31; ++i) {
                        ItemStack stack = crate.stackHandler.getCrateStockItem(i);
                        if (i == 30) {
                            if (stack.isEmpty() || ((CoinCounter)stack.getOrDefault(Content.coinCounter, (Object)new CoinCounter(0))).count() <= 0) continue;
                            int pay = ((CoinCounter)stack.get(Content.coinCounter)).count();
                            ItemStack prepCopy = stack.copy();
                            prepCopy.remove(Content.coinCounter);
                            while (pay > 0) {
                                ItemStack toDrop = prepCopy.copy();
                                if (pay >= prepCopy.getMaxStackSize()) {
                                    toDrop.setCount(prepCopy.getMaxStackSize());
                                    pay -= prepCopy.getMaxStackSize();
                                } else {
                                    toDrop.setCount(pay);
                                    pay = 0;
                                }
                                Containers.dropItemStack((Level)serverLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (ItemStack)toDrop);
                            }
                            continue;
                        }
                        if (stack.isEmpty()) continue;
                        Containers.dropItemStack((Level)serverLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (ItemStack)stack);
                    }
                    for (i = 0; i < 2; ++i) {
                        ItemStack toDrop = crate.stackHandler.getInteractableTradeItem(i);
                        Containers.dropItemStack((Level)serverLevel, (double)pPos.getX(), (double)pPos.getY(), (double)pPos.getZ(), (ItemStack)toDrop);
                    }
                    pLevel.updateNeighbourForOutputSignal(pPos, (Block)this);
                }
            }
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getCollisionShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape getVisualShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public float getDestroyProgress(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        CrateBlockEntityBase crate;
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (blockEntity instanceof CrateBlockEntityBase && (crate = (CrateBlockEntityBase)blockEntity).isOwner(pPlayer)) {
            return super.getDestroyProgress(pState, pPlayer, pLevel, pPos);
        }
        return 0.0f;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        block6: {
            CrateBlockEntityBase crate;
            block8: {
                boolean owner;
                block7: {
                    BlockEntity blockEntity = level.getBlockEntity(pos);
                    if (!(blockEntity instanceof CrateBlockEntityBase)) break block6;
                    crate = (CrateBlockEntityBase)blockEntity;
                    if (!hand.equals((Object)InteractionHand.MAIN_HAND)) break block6;
                    if (!(level instanceof ServerLevel)) break block7;
                    ServerLevel server = (ServerLevel)level;
                    if (player.getItemInHand(hand).getItem() instanceof DebugStickItem && server.getServer().getPlayerList().isOp(player.getGameProfile())) break block8;
                }
                boolean bl = owner = !player.isShiftKeyDown() && crate.isOwner(player);
                if (player instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    if (owner) {
                        this.openOwnerUI(serverPlayer, crate);
                    } else {
                        this.openBuyerUI(serverPlayer, crate);
                    }
                }
                level.playSound(player, pos, SoundEvents.WOOD_PLACE, SoundSource.BLOCKS, 1.0f, 1.0f);
                return ItemInteractionResult.sidedSuccess((boolean)level.isClientSide);
            }
            crate.isUnlimitedShop = true;
            player.displayClientMessage((Component)Component.translatable((String)"crate.set.creative"), true);
            crate.setChanged();
            return ItemInteractionResult.FAIL;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    public void openOwnerUI(ServerPlayer serverPlayer, CrateBlockEntityBase commonCrate) {
    }

    public void openBuyerUI(ServerPlayer serverPlayer, CrateBlockEntityBase commonCrate) {
    }
}

