/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.block.blockentity;

import jackdaw.applecrates.api.CrateWoodType;
import jackdaw.applecrates.container.IStackHandlerAdapter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CrateBlockEntityBase
extends BlockEntity {
    public final IStackHandlerAdapter stackHandler;
    public boolean isUnlimitedShop = false;
    private Set<UUID> owners = new HashSet<UUID>();

    public CrateBlockEntityBase(CrateWoodType type, BlockPos pos, BlockState state, IStackHandlerAdapter stackHandler) {
        super(CrateWoodType.getBlockEntityType(type), pos, state);
        this.stackHandler = stackHandler;
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.loadCrateDataFromTag(registries, tag);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.saveCrateDataToTag(registries, tag);
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveCrateDataToTag(registries, new CompoundTag());
    }

    protected CompoundTag saveCrateDataToTag(HolderLookup.Provider registries, CompoundTag tag) {
        this.stackHandler.saveInventoryData(registries, tag);
        tag.putBoolean("isUnlimited", this.isUnlimitedShop);
        if (!this.owners.isEmpty()) {
            ListTag ownersTag = this.owners.stream().map(NbtUtils::createUUID).collect(Collectors.toCollection(ListTag::new));
            tag.put("owner", (Tag)ownersTag);
        }
        return tag;
    }

    protected void loadCrateDataFromTag(HolderLookup.Provider registries, CompoundTag tag) {
        this.stackHandler.loadInventoryData(registries, tag);
        if (tag.contains("isUnlimited")) {
            this.isUnlimitedShop = tag.getBoolean("isUnlimited");
        }
        if (tag.contains("owner")) {
            Tag owner = tag.get("owner");
            if (owner.getType() == IntArrayTag.TYPE) {
                this.owners = new HashSet<UUID>(Collections.singleton(NbtUtils.loadUUID((Tag)owner)));
            } else if (owner instanceof ListTag) {
                ListTag ownerList = (ListTag)owner;
                this.owners = ownerList.stream().map(NbtUtils::loadUUID).collect(Collectors.toCollection(HashSet::new));
            }
        }
    }

    public Set<UUID> getOwners() {
        return this.owners;
    }

    public void addOwner(UUID player) {
        this.owners.add(player);
    }

    public boolean isOwner(UUID uuid) {
        return this.owners.isEmpty() || this.owners.contains(uuid);
    }

    public boolean isOwner(Player player) {
        return this.owners.isEmpty() || player != null && this.owners.contains(player.getGameProfile().getId());
    }

    public static int getStockSignal(BlockGetter blockLevel, BlockPos pos) {
        BlockEntity blockEntity;
        if (blockLevel.getBlockState(pos).hasBlockEntity() && (blockEntity = blockLevel.getBlockEntity(pos)) instanceof CrateBlockEntityBase) {
            CrateBlockEntityBase crate = (CrateBlockEntityBase)blockEntity;
            return crate.getStockLevel();
        }
        return 0;
    }

    public int getStockLevel() {
        ItemStack outputStack = this.stackHandler.getSavedTradeSlotsItem(1);
        if (!outputStack.isEmpty()) {
            double count = this.stackHandler.getCrateStock().getCountOfItemImmediately(outputStack.getItem());
            double totalPossible = outputStack.getMaxStackSize() * 30;
            double ratio = 15.0 * (count / totalPossible);
            return (int)ratio;
        }
        return 0;
    }
}

