/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.client.besr;

import com.mojang.blaze3d.vertex.PoseStack;
import jackdaw.applecrates.Content;
import jackdaw.applecrates.EnumCrateItemRendering;
import jackdaw.applecrates.block.CrateBlockBase;
import jackdaw.applecrates.block.blockentity.CrateBlockEntityBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Quaternionf;

public class CrateBlockEntitySpecialRenderer
implements BlockEntityRenderer<CrateBlockEntityBase> {
    private static final int MAX_RENDERED_ITEMS = 9;
    private static final int ITEMS_PER_ROW = 3;

    public CrateBlockEntitySpecialRenderer(BlockEntityRendererProvider.Context ctx) {
    }

    public void render(CrateBlockEntityBase crateBE, float pPartialTick, PoseStack stack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        float blockRotation = ((Direction)crateBE.getBlockState().getValue((Property)CrateBlockBase.FACING)).toYRot();
        ItemStack selling = crateBE.stackHandler.getSavedTradeSlotsItem(1);
        if (!selling.isEmpty()) {
            boolean three;
            boolean one = Content.clientConfig.getCrateItemRenderingValue() == EnumCrateItemRendering.ONE;
            boolean bl = three = Content.clientConfig.getCrateItemRenderingValue() == EnumCrateItemRendering.THREE;
            int amount = one ? 1 : (three ? 3 : (crateBE.isUnlimitedShop ? 9 : Mth.clamp((int)(crateBE.stackHandler.getCratestacksTotalItemCount(selling.getItem()) / selling.getCount()), (int)1, (int)9)));
            for (int i = 0; i < amount; ++i) {
                float zfront;
                float zoff;
                stack.pushPose();
                int angleSimp = (int)((Direction)crateBE.getBlockState().getValue((Property)CrateBlockBase.FACING)).toYRot() / 90;
                float xoff = angleSimp == 1 || angleSimp == 2 ? 1.0f : 0.0f;
                float f = zoff = angleSimp == 2 || angleSimp == 3 ? 1.0f : 0.0f;
                float f2 = angleSimp % 2 == 1 ? 0.5f * (float)(angleSimp == 3 ? -1 : 1) : (zfront = 0.0f);
                float xfront = angleSimp % 2 == 0 ? 0.5f * (float)(angleSimp == 2 ? -1 : 1) : 0.0f;
                stack.translate(xoff + xfront, 0.0f, zoff + zfront);
                float xAngle = 67.5f * (xfront == 0.0f ? zfront * (zfront < 0.0f ? 2.0f : -2.0f) : xfront * (xfront < 0.0f ? 2.0f : -2.0f));
                Quaternionf angleBlockFacing = new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, blockRotation + (angleSimp % 2 == 0 ? 180.0f : 1.0f));
                Quaternionf angleCrateIncline = new Quaternionf().fromAxisAngleDeg(1.0f, 0.0f, 0.0f, xAngle);
                stack.mulPose(angleBlockFacing);
                stack.mulPose(angleCrateIncline);
                Vec3 offset = CrateBlockEntitySpecialRenderer.calculateOffset(crateBE.getBlockPos());
                float randX = (float)offset.x();
                float randZ = (float)offset.z();
                if (Content.clientConfig.getCrateItemRenderingValue() == EnumCrateItemRendering.THREE) {
                    stack.translate((double)(i == 0 ? 0.0f : randX / (float)i * (float)(i == 1 ? -1 : 1)), (double)(0.25f + (i == 0 ? 0.0f : randZ / (float)i)), (double)0.1f + (double)i * 0.025);
                } else {
                    stack.translate((double)(i % 3) * 0.25 - 0.25, (double)0.17f + (double)((float)(i / 3) / 9.0f) * 2.0, (double)0.1f + (double)(i / 3 % 2) * 0.025 + (double)randX * 0.02 + (double)(i % 2) * 0.01);
                }
                Minecraft.getInstance().getItemRenderer().renderStatic(selling, ItemDisplayContext.GROUND, pPackedLight, pPackedOverlay, stack, pBufferSource, crateBE.getLevel(), 0);
                stack.popPose();
            }
        }
    }

    private static Vec3 calculateOffset(BlockPos pPos) {
        long i = Mth.getSeed((int)pPos.getX(), (int)0, (int)pPos.getZ());
        float horizontalOffset = 0.2f;
        double d0 = Mth.clamp((double)((double)((float)(i & 0xFL) / 15.0f) * 0.5), (double)(-horizontalOffset), (double)horizontalOffset);
        double d2 = Mth.clamp((double)((double)((float)(i >> 8 & 0xFL) / 15.0f) * 0.5), (double)0.0, (double)0.4);
        return new Vec3(d0, 0.0, d2);
    }
}

