/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import jackdaw.applecrates.Content;
import jackdaw.applecrates.client.screen.CrateScreen;
import jackdaw.applecrates.client.screen.widget.HoverTooltipButton;
import jackdaw.applecrates.client.screen.widget.SaleButton;
import jackdaw.applecrates.container.CrateMenuBuyer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class CrateScreenBuyer
extends CrateScreen<CrateMenuBuyer> {
    private static final ResourceLocation BUYER = ResourceLocation.fromNamespaceAndPath((String)"applecrates", (String)"gui/buyer.png");

    public CrateScreenBuyer(CrateMenuBuyer menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, (Component)Component.translatable((String)title.getString()));
        this.imageWidth = 176;
        this.imageHeight = 143;
        this.inventoryLabelX = this.titleLabelX;
        this.inventoryLabelY = this.titleLabelY + 40;
    }

    @Override
    public boolean isUnlimitedShop() {
        return ((CrateMenuBuyer)this.menu).isUnlimitedShop;
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new SaleButtonBuyer(this.guiStartX + 14, this.guiStartY + 19, button -> {
            if (this.isUnlimitedShop() || !((CrateMenuBuyer)this.menu).outOfStock()) {
                Content.buyerGuiButton.accept();
            }
        }));
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        RenderSystem.enableBlend();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)TRADE_ARROW_SPRITE);
        if (((CrateMenuBuyer)this.menu).outOfStock() && !this.isUnlimitedShop()) {
            graphics.blitSprite(TRADE_ARROW_SPRITE, this.guiStartX + 40, this.guiStartY + 24, 0, 10, 9);
        } else {
            graphics.blitSprite(TRADE_ARROW_SPRITE, this.guiStartX + 46, this.guiStartY + 24, 0, 10, 9);
        }
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderTrade(graphics, 0, this.guiStartX, this.guiStartY);
        this.renderTrade(graphics, 1, this.guiStartX, this.guiStartY);
        this.renderTooltip(graphics, pMouseX, pMouseY);
    }

    private void renderTrade(GuiGraphics graphics, int slotId, int x, int y) {
        if (!((CrateMenuBuyer)this.menu).adapter.getSavedTradeSlotsItem(slotId).isEmpty()) {
            ItemStack saleStack = ((CrateMenuBuyer)this.menu).adapter.getSavedTradeSlotsItem(slotId);
            int xo = slotId == 0 ? 16 : 57;
            int yo = 20;
            graphics.renderFakeItem(saleStack, x + xo, y + yo);
            graphics.renderItemDecorations(this.font, saleStack, x + xo, y + yo);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BUYER);
        graphics.blit(BUYER, this.guiStartX, this.guiStartY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
    }

    protected void renderTooltip(GuiGraphics g, int x, int y) {
        super.renderTooltip(g, x, y);
        for (GuiEventListener ren : this.children()) {
            if (!(ren instanceof HoverTooltipButton)) continue;
            HoverTooltipButton htb = (HoverTooltipButton)ren;
            if (!(ren instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)ren;
            if (!widget.active || !widget.isHovered() || !widget.visible) continue;
            htb.renderToolTip(g, x, y);
        }
    }

    public void onClose() {
        super.onClose();
    }

    private class SaleButtonBuyer
    extends SaleButton {
        public SaleButtonBuyer(int x, int y, Button.OnPress press) {
            super(x, y, (Component)Component.translatable((String)"crate.button.sale.buyer"), press);
        }

        @Override
        public void doRenderTip(GuiGraphics graphics, int pMouseX, int pMouseY, int slot) {
        }

        @Override
        public void renderToolTip(GuiGraphics graphics, int pMouseX, int pMouseY) {
            ItemStack pay = ((CrateMenuBuyer)((CrateScreenBuyer)CrateScreenBuyer.this).menu).adapter.getSavedTradeSlotsItem(0);
            ItemStack result = ((CrateMenuBuyer)((CrateScreenBuyer)CrateScreenBuyer.this).menu).adapter.getSavedTradeSlotsItem(1);
            if (pMouseX < this.getX() + 20 && !pay.isEmpty()) {
                graphics.renderTooltip(CrateScreenBuyer.this.font, CrateScreenBuyer.this.getTooltipFromContainerItem(pay), pay.getTooltipImage(), pMouseX, pMouseY);
            } else if (pMouseX > this.getX() + this.width - 25 && !result.isEmpty()) {
                graphics.renderTooltip(CrateScreenBuyer.this.font, CrateScreenBuyer.this.getTooltipFromContainerItem(result), result.getTooltipImage(), pMouseX, pMouseY);
            }
        }
    }
}

