/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import jackdaw.applecrates.Content;
import jackdaw.applecrates.client.screen.CrateScreen;
import jackdaw.applecrates.client.screen.widget.AddOwnerButton;
import jackdaw.applecrates.client.screen.widget.AddOwnerEditBox;
import jackdaw.applecrates.client.screen.widget.ConfirmAddOwnerButton;
import jackdaw.applecrates.client.screen.widget.HoverTooltipButton;
import jackdaw.applecrates.client.screen.widget.SaleButton;
import jackdaw.applecrates.container.CrateMenuOwner;
import jackdaw.applecrates.item.datacomponent.CoinCounter;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class CrateScreenOwner
extends CrateScreen<CrateMenuOwner> {
    private static final ResourceLocation OWNER = ResourceLocation.fromNamespaceAndPath((String)"applecrates", (String)"gui/owner.png");
    private AddOwnerEditBox inputField;
    private ConfirmAddOwnerButton confirmAddOwnerButton;
    private AddOwnerButton addOwnerButton;
    private boolean cancelFocusChange = false;

    public CrateScreenOwner(CrateMenuOwner menu, Inventory playerInventory, Component title) {
        super(menu, playerInventory, (Component)Component.translatable((String)title.getString()));
        this.imageWidth = 198;
        this.imageHeight = 194;
        this.inventoryLabelX = this.titleLabelX + 8;
        this.inventoryLabelY = this.titleLabelY + 90;
    }

    @Override
    public boolean isUnlimitedShop() {
        return ((CrateMenuOwner)this.menu).isUnlimitedShop;
    }

    @Override
    protected void init() {
        super.init();
        this.addRenderableWidget((GuiEventListener)new SaleButtonOwner(this.guiStartX + 70, this.guiStartY + 74, button -> {
            if (!(((CrateMenuOwner)this.menu).adapter.getInteractableTradeItem(0).isEmpty() && ((CrateMenuOwner)this.menu).adapter.getInteractableTradeItem(1).isEmpty() || !((CrateMenuOwner)this.menu).adapter.getCrateStockItem(30).isEmpty() && !this.isSamePayout())) {
                Content.ownerGuiButton.accept();
            }
        }));
        this.inputField = (AddOwnerEditBox)this.addWidget((GuiEventListener)new AddOwnerEditBox(this.font, this.guiStartX + 33, this.guiStartY + 37, 113, 12, (Component)Component.translatable((String)"crate.add.owner")));
        this.confirmAddOwnerButton = (ConfirmAddOwnerButton)this.addWidget((GuiEventListener)new ConfirmAddOwnerButton(this.guiStartX + 151, this.guiStartY + 37, (Component)Component.translatable((String)"crate.add.owner.confirm"), button -> {
            if (!this.inputField.getValue().isBlank()) {
                Content.addOwnerButton.accept(this.inputField.getValue());
            }
            this.addOwnerButton.isOn = !this.addOwnerButton.isOn;
            this.toggleOverlay();
        }));
        this.addOwnerButton = (AddOwnerButton)this.addRenderableWidget((GuiEventListener)new AddOwnerButton(this.guiStartX + 138, this.guiStartY + 74, (Component)Component.translatable((String)"crate.add.owner"), button -> this.toggleOverlay()));
    }

    private void toggleOverlay() {
        boolean isNowOn = this.addOwnerButton.isOn;
        this.inputField.setEditable(isNowOn);
        this.inputField.setVisible(isNowOn);
        if (isNowOn) {
            this.setFocused((GuiEventListener)this.inputField);
            this.cancelFocusChange = true;
        }
        this.inputField.setFocused(isNowOn);
        this.confirmAddOwnerButton.visible = isNowOn;
    }

    public void setFocused(GuiEventListener $$0) {
        if (this.cancelFocusChange) {
            this.cancelFocusChange = false;
            return;
        }
        super.setFocused($$0);
    }

    protected boolean isHovering(int x, int y, int width, int height, double mouseX, double mouseY) {
        if (this.inputField.isVisible() && super.isHovering(10, 15, 180, 54, mouseX, mouseY)) {
            return false;
        }
        return super.isHovering(x, y, width, height, mouseX, mouseY);
    }

    protected boolean isSamePayout() {
        ItemStack payout = ((CrateMenuOwner)this.menu).adapter.getCrateStockItem(30).copy();
        ItemStack give = ((CrateMenuOwner)this.menu).adapter.getInteractableTradeItem(0).copy();
        if (give.isEmpty() || payout.isEmpty()) {
            return true;
        }
        if (((CoinCounter)payout.getOrDefault(Content.coinCounter, (Object)new CoinCounter(0))).count() > 0) {
            payout.remove(Content.coinCounter);
        }
        return ItemStack.isSameItemSameComponents((ItemStack)payout, (ItemStack)give);
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        ItemStack inSlot;
        this.renderBackground(graphics, pMouseX, pMouseY, pPartialTick);
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        RenderSystem.enableBlend();
        if ((!((CrateMenuOwner)this.menu).adapter.getSavedTradeSlotsItem(0).isEmpty() || !((CrateMenuOwner)this.menu).adapter.getSavedTradeSlotsItem(1).isEmpty()) && ((CrateMenuOwner)this.menu).adapter.getInteractableTradeItem(0).isEmpty() && ((CrateMenuOwner)this.menu).adapter.getInteractableTradeItem(1).isEmpty()) {
            RenderSystem.setShaderColor((float)0.0f, (float)1.0f, (float)0.0f, (float)1.0f);
        }
        if (!this.isSamePayout()) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        graphics.blitSprite(TRADE_ARROW_SPRITE, this.guiStartX + 100, this.guiStartY + 79, 0, 10, 9);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.renderTrade(graphics, 0, this.guiStartX, this.guiStartY);
        this.renderTrade(graphics, 1, this.guiStartX, this.guiStartY);
        if (!((CrateMenuOwner)this.menu).adapter.getCrateStockItem(30).isEmpty() && ((CoinCounter)(inSlot = ((CrateMenuOwner)this.menu).adapter.getCrateStockItem(30)).getOrDefault(Content.coinCounter, (Object)new CoinCounter(0))).count() > 0) {
            inSlot.setCount(((CoinCounter)inSlot.get(Content.coinCounter)).count());
        }
        graphics.pose().pushPose();
        graphics.pose().translate(0.0f, 0.0f, 350.0f);
        this.inputField.render(graphics, pMouseX, pMouseY, pPartialTick);
        if (this.confirmAddOwnerButton.visible) {
            this.confirmAddOwnerButton.render(graphics, pMouseX, pMouseY, pPartialTick);
        }
        graphics.pose().popPose();
        this.renderTooltip(graphics, pMouseX, pMouseY);
    }

    private void renderTrade(GuiGraphics graphics, int slotId, int x, int y) {
        if (!((CrateMenuOwner)this.menu).adapter.getInteractableTradeItem(slotId).isEmpty() || !((CrateMenuOwner)this.menu).adapter.getSavedTradeSlotsItem(slotId).isEmpty()) {
            ItemStack saleStack = !((CrateMenuOwner)this.menu).adapter.getInteractableTradeItem(slotId).isEmpty() ? ((CrateMenuOwner)this.menu).adapter.getInteractableTradeItem(slotId) : ((CrateMenuOwner)this.menu).adapter.getSavedTradeSlotsItem(slotId);
            int xo = slotId == 0 ? 72 : 113;
            int yo = 75;
            graphics.renderFakeItem(saleStack, x + xo, y + yo);
            graphics.renderItemDecorations(this.font, saleStack, x + xo, y + yo);
        }
    }

    @Override
    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)OWNER);
        graphics.blit(OWNER, this.guiStartX, this.guiStartY, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 256, 256);
        this.inputField.renderBgCustom(graphics);
    }

    protected void containerTick() {
        super.containerTick();
    }

    public boolean keyPressed(int keyCode, int $$1, int $$2) {
        if (keyCode == 256) {
            this.minecraft.player.closeContainer();
        }
        return this.inputField.keyPressed(keyCode, $$1, $$2) || this.inputField.canConsumeInput() || super.keyPressed(keyCode, $$1, $$2);
    }

    protected void renderTooltip(GuiGraphics g, int x, int y) {
        super.renderTooltip(g, x, y);
        for (GuiEventListener ren : this.children()) {
            if (!(ren instanceof HoverTooltipButton)) continue;
            HoverTooltipButton htb = (HoverTooltipButton)ren;
            if (!(ren instanceof AbstractWidget)) continue;
            AbstractWidget widget = (AbstractWidget)ren;
            if (!widget.active || !widget.isHovered() || !widget.visible) continue;
            htb.renderToolTip(g, x, y);
        }
    }

    public void onClose() {
        super.onClose();
    }

    private class SaleButtonOwner
    extends SaleButton {
        private static final Component CANNOT_SWITCH = Component.translatable((String)"cannot.switch.trade");

        public SaleButtonOwner(int x, int y, Button.OnPress press) {
            super(x, y, (Component)Component.translatable((String)"crate.button.sale.owner"), press);
        }

        @Override
        public void doRenderTip(GuiGraphics graphics, int pMouseX, int pMouseY, int slot) {
        }

        @Override
        public void renderToolTip(GuiGraphics graphics, int pMouseX, int pMouseY) {
            ItemStack pay = ((CrateMenuOwner)((CrateScreenOwner)CrateScreenOwner.this).menu).adapter.getSavedTradeSlotsItem(0);
            ItemStack result = ((CrateMenuOwner)((CrateScreenOwner)CrateScreenOwner.this).menu).adapter.getSavedTradeSlotsItem(1);
            if (pMouseX < this.getX() + 20 && !pay.isEmpty()) {
                graphics.renderTooltip(CrateScreenOwner.this.font, CrateScreenOwner.this.getTooltipFromContainerItem(pay), pay.getTooltipImage(), pMouseX, pMouseY);
            } else if (pMouseX > this.getX() + this.width - 25 && !result.isEmpty()) {
                graphics.renderTooltip(CrateScreenOwner.this.font, CrateScreenOwner.this.getTooltipFromContainerItem(result), result.getTooltipImage(), pMouseX, pMouseY);
            } else if (!CrateScreenOwner.this.isSamePayout()) {
                graphics.renderTooltip(CrateScreenOwner.this.font, List.of(CANNOT_SWITCH), Optional.empty(), pMouseX, pMouseY);
            } else {
                graphics.renderTooltip(Minecraft.getInstance().font, List.of(this.getHovertext()), Optional.empty(), pMouseX, pMouseY);
            }
        }
    }
}

