/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.container;

import jackdaw.applecrates.Constants;
import jackdaw.applecrates.Content;
import jackdaw.applecrates.block.blockentity.CrateBlockEntityBase;
import jackdaw.applecrates.container.IStackHandlerAdapter;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class CrateMenu
extends AbstractContainerMenu {
    public IStackHandlerAdapter adapter;
    public boolean isUnlimitedShop = false;
    protected Level volatileLevel;
    protected BlockPos volatilePos;
    protected CrateBlockEntityBase crate;

    public CrateMenu(MenuType<?> type, int id, Inventory inventory, CrateBlockEntityBase crate, boolean unlimited) {
        this(type, id, inventory, crate.stackHandler, unlimited);
        this.volatileLevel = crate.getLevel();
        this.volatilePos = crate.getBlockPos();
        this.crate = crate;
    }

    protected CrateMenu(MenuType<?> type, int id, Inventory inventory, IStackHandlerAdapter adapter, boolean ul) {
        super(type, id);
        this.adapter = adapter;
        this.isUnlimitedShop = ul;
        Content.menuSlots.accept(this);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index_rotated = (y + 3) % 4;
                int yPos = this.playerInventoryY() + index_rotated * 18 + (index_rotated == 3 ? 4 : 0);
                int xPos = this.playerInventoryX() + x * 18;
                int index = x + y * 9;
                this.addSlot(new Slot((Container)inventory, index, xPos, yPos));
            }
        }
    }

    public boolean isOwner() {
        return false;
    }

    protected int playerInventoryX() {
        return this.isOwner() ? 19 : 8;
    }

    protected int playerInventoryY() {
        return this.isOwner() ? 108 : 57;
    }

    public ItemStack quickMoveStack(Player player, int index) {
        if (!((Slot)this.slots.get(index)).hasItem()) {
            return ItemStack.EMPTY;
        }
        if (Constants.isInCrateStock(index)) {
            this.moveItemStackTo(((Slot)this.slots.get(index)).getItem(), 35, 71, false);
        }
        return ItemStack.EMPTY;
    }

    public void clicked(int $$0, int $$1, ClickType $$2, Player $$3) {
        super.clicked($$0, $$1, $$2, $$3);
        this.markCrateChanged();
    }

    protected void markCrateChanged() {
        BlockEntity blockEntity;
        if (this.volatileLevel != null && this.volatilePos != null && (blockEntity = this.volatileLevel.getBlockEntity(this.volatilePos)) instanceof CrateBlockEntityBase) {
            CrateBlockEntityBase crate = (CrateBlockEntityBase)blockEntity;
            this.volatileLevel.sendBlockUpdated(this.volatilePos, this.volatileLevel.getBlockState(this.volatilePos), this.volatileLevel.getBlockState(this.volatilePos), 3);
            crate.setChanged();
        }
    }

    public boolean stillValid(Player player) {
        return true;
    }

    public void removed(Player pPlayer) {
        pPlayer.getInventory().placeItemBackInInventory(this.adapter.getInteractableTradeItem(0));
        this.adapter.setInteractableTradeItem(0, ItemStack.EMPTY);
        super.removed(pPlayer);
        this.markCrateChanged();
    }

    public boolean canTakeItemForPickAll(ItemStack stack, Slot slot) {
        if (slot.index == 1 || slot.index == 34) {
            return false;
        }
        return super.canTakeItemForPickAll(stack, slot);
    }

    public Slot addSlot(Slot slot) {
        return super.addSlot(slot);
    }

    public void addOwner(ServerPlayer currentOwner, String newOwnerUsername) {
        if (this.crate.isOwner((Player)currentOwner)) {
            currentOwner.server.getPlayerList().getPlayers().stream().filter(player -> player.getGameProfile().getName().equalsIgnoreCase(newOwnerUsername)).findFirst().ifPresentOrElse(player -> {
                UUID newOwner = player.getUUID();
                if (this.crate.isOwner(newOwner)) {
                    currentOwner.sendSystemMessage((Component)Component.translatable((String)"crate.add.owner.already_owner", (Object[])new Object[]{player.getName()}));
                } else {
                    this.crate.addOwner(newOwner);
                    currentOwner.sendSystemMessage((Component)Component.translatable((String)"crate.add.owner.success", (Object[])new Object[]{player.getName()}));
                }
            }, () -> currentOwner.sendSystemMessage((Component)Component.translatable((String)"crate.add.owner.not_found", (Object[])new Object[]{newOwnerUsername})));
        }
    }
}

