/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.container;

import jackdaw.applecrates.Constants;
import jackdaw.applecrates.block.blockentity.CrateBlockEntityBase;
import jackdaw.applecrates.container.CrateMenu;
import jackdaw.applecrates.container.IStackHandlerAdapter;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CrateMenuBuyer
extends CrateMenu {
    public CrateMenuBuyer(MenuType<?> type, int id, Inventory inventory, IStackHandlerAdapter adapter, boolean unlimited) {
        super(type, id, inventory, adapter, unlimited);
    }

    public CrateMenuBuyer(MenuType<?> type, int id, Inventory inventory, CrateBlockEntityBase crate, boolean unlimited) {
        super(type, id, inventory, crate, unlimited);
    }

    @Override
    public void clicked(int slotID, int mouseButton, ClickType click, Player player) {
        if (slotID == 0) {
            super.clicked(slotID, mouseButton, click, player);
            this.updateSellItem();
        } else if (slotID == 1) {
            if (mouseButton != 0 || !click.equals((Object)ClickType.PICKUP) && !click.equals((Object)ClickType.QUICK_MOVE) || this.adapter.getInteractableTradeItem(1).isEmpty() || !this.getCarried().isEmpty() && this.getCarried().getCount() + this.adapter.getInteractableTradeItem(1).getCount() > this.getCarried().getMaxStackSize()) {
                return;
            }
            super.clicked(slotID, mouseButton, click, player);
            this.adapter.getInteractableTradeItem(0).shrink(this.adapter.getSavedTradeSlotsItem(0).getCount());
            this.adapter.getCrateStock().updateStackInPaymentSlot(this.adapter.getSavedTradeSlotsItem(0), this.isUnlimitedShop);
            this.updateSellItem();
        } else {
            super.clicked(slotID, mouseButton, click, player);
            this.updateSellItem();
        }
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        if (Constants.isInPlayerInventory(index) && this.moveItemStackTo(((Slot)this.slots.get(index)).getItem(), 0, 1, false)) {
            this.moveItemStackTo(((Slot)this.slots.get(index)).getItem(), 0, 1, false);
            this.updateSellItem();
        } else if (index == 0) {
            this.moveItemStackTo(this.adapter.getInteractableTradeItem(0), 35, 70, false);
            this.updateSellItem();
        }
        if (index == 1) {
            this.moveItemStackTo(this.adapter.getInteractableTradeItem(1), 35, 70, false);
            return ItemStack.EMPTY;
        }
        return super.quickMoveStack(player, index);
    }

    @Override
    public void removed(Player pPlayer) {
        super.removed(pPlayer);
        this.updateSellItem();
    }

    protected void updateSellItem() {
        boolean hasEnough;
        ItemStack payment = this.adapter.getInteractableTradeItem(0);
        ItemStack toPay = this.adapter.getSavedTradeSlotsItem(0);
        boolean isBuySlotEmpty = this.adapter.getInteractableTradeItem(1).isEmpty();
        boolean isSamePay = ItemStack.isSameItemSameComponents((ItemStack)toPay, (ItemStack)payment) && !toPay.isEmpty();
        boolean bl = hasEnough = payment.getCount() >= toPay.getCount();
        if (isBuySlotEmpty && isSamePay && hasEnough) {
            this.movefromStockToSaleSlot(this.adapter.getSavedTradeSlotsItem(1).copy());
        } else if (!isBuySlotEmpty && !hasEnough || payment.isEmpty()) {
            this.moveItemStackTo(this.adapter.getInteractableTradeItem(1), 4, 33, false);
        }
    }

    public void tryMovePaymentToInteraction() {
        ItemStack itemstack = this.adapter.getInteractableTradeItem(0);
        if (!itemstack.isEmpty()) {
            if (!this.moveItemStackTo(itemstack, 35, 70, false)) {
                return;
            }
            this.adapter.setInteractableTradeItem(0, itemstack);
        }
        if (this.adapter.getInteractableTradeItem(0).isEmpty()) {
            ItemStack give = this.adapter.getSavedTradeSlotsItem(0);
            this.moveFromInventoryToPaymentSlot(give);
        }
    }

    protected void moveFromInventoryToPaymentSlot(ItemStack give) {
        if (!give.isEmpty()) {
            for (int i = 35; i < 70; ++i) {
                ItemStack stackinSlot = ((Slot)this.slots.get(i)).getItem();
                if (stackinSlot.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)give, (ItemStack)stackinSlot)) continue;
                ItemStack paymentSlot = this.adapter.getInteractableTradeItem(0);
                int j = paymentSlot.isEmpty() ? 0 : paymentSlot.getCount();
                int k = Math.min(give.getMaxStackSize() - j, stackinSlot.getCount());
                ItemStack copy = stackinSlot.copy();
                int l = j + k;
                stackinSlot.shrink(k);
                copy.setCount(l);
                this.adapter.setInteractableTradeItem(0, copy);
                if (l >= give.getMaxStackSize()) break;
            }
            this.updateSellItem();
        }
    }

    protected void movefromStockToSaleSlot(ItemStack get) {
        if (!(get.isEmpty() || this.outOfStock() && !this.isUnlimitedShop)) {
            if (this.isUnlimitedShop) {
                this.adapter.setInteractableTradeItem(1, get.copy());
            } else {
                for (int i = 4; i < 33; ++i) {
                    ItemStack stackinSlot = ((Slot)this.slots.get(i)).getItem();
                    if (stackinSlot.isEmpty() || !ItemStack.isSameItem((ItemStack)get, (ItemStack)stackinSlot)) continue;
                    ItemStack pickupSlot = this.adapter.getInteractableTradeItem(1);
                    int j = pickupSlot.isEmpty() ? 0 : pickupSlot.getCount();
                    int k = Math.min(get.getCount() - j, stackinSlot.getCount());
                    ItemStack copy = stackinSlot.copy();
                    int l = j + k;
                    stackinSlot.shrink(k);
                    copy.setCount(l);
                    this.adapter.setInteractableTradeItem(1, copy);
                    if (l >= get.getCount()) break;
                }
            }
        }
    }

    public boolean outOfStock() {
        int total = 0;
        ItemStack buying = this.adapter.getSavedTradeSlotsItem(1);
        for (int i = 0; i < 29; ++i) {
            ItemStack stack = this.adapter.getCrateStockItem(i);
            if (stack.isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)buying)) continue;
            total += stack.getCount();
        }
        return total < buying.getCount();
    }
}

