/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.container;

import jackdaw.applecrates.Constants;
import jackdaw.applecrates.Content;
import jackdaw.applecrates.block.blockentity.CrateBlockEntityBase;
import jackdaw.applecrates.container.CrateMenu;
import jackdaw.applecrates.container.IStackHandlerAdapter;
import jackdaw.applecrates.item.datacomponent.CoinCounter;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;

public class CrateMenuOwner
extends CrateMenu {
    public CrateMenuOwner(MenuType<?> type, int id, Inventory inventory, IStackHandlerAdapter adapter, boolean unlimited) {
        super(type, id, inventory, adapter, unlimited);
    }

    public CrateMenuOwner(MenuType<?> type, int id, Inventory inventory, CrateBlockEntityBase crate, boolean unlimited) {
        super(type, id, inventory, crate, unlimited);
    }

    @Override
    public boolean isOwner() {
        return true;
    }

    @Override
    public void clicked(int slotID, int mouseButton, ClickType click, Player player) {
        if (slotID == 34 && this.getCarried().isEmpty()) {
            if (click.equals((Object)ClickType.PICKUP)) {
                this.setCarried(this.pickUpPayment());
            } else if (click.equals((Object)ClickType.QUICK_MOVE)) {
                this.moveItemStackTo(this.pickUpPayment(), 35, 70, false);
            }
            return;
        }
        super.clicked(slotID, mouseButton, click, player);
    }

    @Override
    public ItemStack quickMoveStack(Player player, int index) {
        if (Constants.isInPlayerInventory(index) && !this.moveItemStackTo(((Slot)this.slots.get(index)).getItem(), 4, 34, false)) {
            return ItemStack.EMPTY;
        }
        if (Constants.isInInteractables(index) && !this.moveItemStackTo(((Slot)this.slots.get(index)).getItem(), 35, 70, false)) {
            return ItemStack.EMPTY;
        }
        if (index == 34) {
            return ItemStack.EMPTY;
        }
        return super.quickMoveStack(player, index);
    }

    protected ItemStack pickUpPayment() {
        ItemStack original = this.adapter.getCrateStockItem(30);
        int amount = ((CoinCounter)original.getOrDefault(Content.coinCounter, (Object)new CoinCounter(0))).count();
        if (amount > 0) {
            ItemStack prepPickup = original.copy();
            prepPickup.remove(Content.coinCounter);
            int pickUp = Math.min(amount, prepPickup.getMaxStackSize());
            prepPickup.setCount(pickUp);
            int updatedAmount = amount - pickUp;
            if (updatedAmount <= 0) {
                this.adapter.setCrateStockItem(30, ItemStack.EMPTY);
            } else {
                ItemStack prepUpdate = original.copy();
                prepUpdate.set(Content.coinCounter, (Object)new CoinCounter(updatedAmount));
                this.adapter.setCrateStockItem(30, prepUpdate);
            }
            return prepPickup;
        }
        return ItemStack.EMPTY;
    }
}

