/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.container;

import jackdaw.applecrates.container.IStackHandlerAdapter;
import jackdaw.applecrates.container.inventory.CrateStackHandler;
import jackdaw.applecrates.container.inventory.GenericStackHandler;
import jackdaw.applecrates.container.inventory.ICrateStock;
import jackdaw.applecrates.container.inventory.IGenericInventory;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class StackHandlerAdapter
implements IStackHandlerAdapter {
    public CrateStackHandler crateStock = new CrateStackHandler();
    public GenericStackHandler interactableTradeSlots = new GenericStackHandler(2);
    public GenericStackHandler savedTradeSlots = new GenericStackHandler(2);

    @Override
    public IGenericInventory getInteractableTradeSlots() {
        return this.interactableTradeSlots;
    }

    @Override
    public IGenericInventory getSavedTradeSlots() {
        return this.savedTradeSlots;
    }

    @Override
    public ICrateStock getCrateStock() {
        return this.crateStock;
    }

    @Override
    public ItemStack getInteractableTradeItem(int slot) {
        return this.interactableTradeSlots.getStackInSlot(slot);
    }

    @Override
    public void setInteractableTradeItem(int slot, ItemStack stack) {
        this.interactableTradeSlots.setStackInSlot(slot, stack);
    }

    @Override
    public ItemStack getSavedTradeSlotsItem(int slot) {
        return this.savedTradeSlots.getStackInSlot(slot);
    }

    @Override
    public void setSavedTradeSlotItem(int slot, ItemStack stack) {
        this.savedTradeSlots.setStackInSlot(slot, stack);
    }

    @Override
    public ItemStack getCrateStockItem(int slot) {
        return this.crateStock.getStackInSlot(slot);
    }

    @Override
    public void setCrateStockItem(int slot, ItemStack stack) {
        this.crateStock.setStackInSlot(slot, stack);
    }

    @Override
    public int getCratestacksTotalItemCount(Item item) {
        return this.crateStock.getCountOfItemCached(item);
    }

    @Override
    public void saveInventoryData(HolderLookup.Provider registries, CompoundTag tag) {
        tag.put("cratestock", (Tag)this.crateStock.serializeNBT(registries));
        tag.put("interactable", (Tag)this.interactableTradeSlots.serializeNBT(registries));
        tag.put("pricensale", (Tag)this.savedTradeSlots.serializeNBT(registries));
    }

    @Override
    public void loadInventoryData(HolderLookup.Provider registries, CompoundTag tag) {
        this.crateStock.deserializeNBT(registries, (CompoundTag)tag.get("cratestock"));
        this.interactableTradeSlots.deserializeNBT(registries, (CompoundTag)tag.get("interactable"));
        this.savedTradeSlots.deserializeNBT(registries, (CompoundTag)tag.get("pricensale"));
    }

    @Override
    public boolean updatePaymentSlot(ItemStack payment, boolean unlimitedShop) {
        return this.crateStock.updateStackInPaymentSlot(payment, unlimitedShop);
    }
}

