/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.container.inventory;

import jackdaw.applecrates.Content;
import jackdaw.applecrates.container.inventory.ICrateStock;
import jackdaw.applecrates.item.datacomponent.CoinCounter;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class CrateStackHandler
extends ItemStackHandler
implements ICrateStock {
    private final Map<Item, Integer> itemCountCache = new HashMap<Item, Integer>();

    public CrateStackHandler() {
        super(31);
    }

    public int getCountOfItemCached(Item item) {
        return this.itemCountCache.computeIfAbsent(item, $ -> this.getCountOfItemImmediately(item));
    }

    @Override
    public int getCountOfItemImmediately(Item item) {
        int count = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (!stack.is(item)) continue;
            count += stack.getCount();
        }
        return count;
    }

    @Override
    public boolean updateStackInPaymentSlot(ItemStack payment, boolean isUnlimitedShop) {
        ItemStack paymentCompare;
        if (isUnlimitedShop) {
            return true;
        }
        ItemStack prepPay = payment.copy();
        if (this.getStackInSlot(30).isEmpty()) {
            prepPay.setCount(1);
            this.setStackInSlot(30, prepPay);
        }
        if ((paymentCompare = this.getStackInSlot(30).copy()).get(Content.coinCounter) != null) {
            paymentCompare.remove(Content.coinCounter);
        }
        if (!ItemStack.isSameItemSameComponents((ItemStack)payment, (ItemStack)paymentCompare)) {
            return false;
        }
        ItemStack prepXchange = this.getStackInSlot(30).copy();
        CoinCounter counter = (CoinCounter)prepXchange.get(Content.coinCounter);
        if (counter != null) {
            prepXchange.set(Content.coinCounter, (Object)new CoinCounter(counter.count() + payment.getCount()));
        } else {
            prepXchange.set(Content.coinCounter, (Object)new CoinCounter(payment.getCount()));
        }
        this.setStackInSlot(30, prepXchange);
        return true;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot == 30) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 30) {
            return ItemStack.EMPTY;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot != 30 && super.isItemValid(slot, stack);
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.itemCountCache.clear();
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.itemCountCache.clear();
    }
}

