/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.datagen;

import com.mojang.logging.LogUtils;
import jackdaw.applecrates.api.AppleCrateAPI;
import jackdaw.applecrates.api.CrateWoodType;
import jackdaw.applecrates.api.exception.WoodException;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackType;
import net.neoforged.neoforge.client.model.generators.BlockModelBuilder;
import net.neoforged.neoforge.client.model.generators.BlockModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;

public class CrateModels
extends BlockModelProvider {
    protected static final ExistingFileHelper.ResourceType TEXTURE = new ExistingFileHelper.ResourceType(PackType.CLIENT_RESOURCES, ".png", "textures");

    public CrateModels(String modId, DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator.getPackOutput(), modId, existingFileHelper);
    }

    protected void registerModels() {
        CrateWoodType.values().forEach(crateWoodType -> {
            try {
                ResourceLocation existingTexture = AppleCrateAPI.getTexturePathFromWood().get(crateWoodType);
                if (existingTexture == null) {
                    throw WoodException.INSTANCE.resLocNotFound((CrateWoodType)crateWoodType);
                }
                this.existingFileHelper.trackGenerated(existingTexture, (ExistingFileHelper.IResourceType)TEXTURE);
                ResourceLocation appleCrateModel = ResourceLocation.fromNamespaceAndPath((String)"applecrates", (String)"block/applecrate");
                this.existingFileHelper.trackGenerated(appleCrateModel, (ExistingFileHelper.IResourceType)MODEL);
                ((BlockModelBuilder)((BlockModelBuilder)this.withExistingParent(crateWoodType.getBlockRegistryName(), appleCrateModel)).texture("particle", existingTexture)).texture("0", existingTexture);
            }
            catch (WoodException e) {
                LogUtils.getLogger().error(e.getMessage());
            }
        });
    }
}

