/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.datagen;

import com.mojang.logging.LogUtils;
import jackdaw.applecrates.api.AppleCrateAPI;
import jackdaw.applecrates.api.CrateWoodType;
import jackdaw.applecrates.api.exception.WoodException;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class CrateRecipes
extends RecipeProvider {
    private String modId;

    public CrateRecipes(String modId, DataGenerator pGenerator, CompletableFuture<HolderLookup.Provider> registries) {
        super(pGenerator.getPackOutput(), registries);
        this.modId = modId;
    }

    protected void buildRecipes(RecipeOutput recipeOutput) {
        CrateWoodType.values().forEach(woodType -> {
            Block plankBlock = (Block)BuiltInRegistries.BLOCK.get(AppleCrateAPI.getPlanksResourceLocation().get(woodType));
            try {
                if (plankBlock.equals(Blocks.AIR)) {
                    throw WoodException.INSTANCE.noSuchBlockError((CrateWoodType)woodType);
                }
                Item crate = Item.BY_BLOCK.getOrDefault(CrateWoodType.getBlock(woodType), Items.AIR);
                ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.DECORATIONS, (ItemLike)crate).pattern("s s").pattern("ppp").define(Character.valueOf('s'), Ingredient.of((ItemLike[])new ItemLike[]{Items.STICK})).define(Character.valueOf('p'), Ingredient.of((ItemLike[])new ItemLike[]{plankBlock})).unlockedBy("has_planks", CrateRecipes.has((TagKey)ItemTags.PLANKS)).group("crates").save(recipeOutput);
            }
            catch (WoodException e) {
                LogUtils.getLogger().error(e.getMessage());
            }
        });
    }
}

