/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.network;

import jackdaw.applecrates.network.PacketId;
import jackdaw.applecrates.network.packetprocessing.ServerAddOwner;
import jackdaw.applecrates.network.packetprocessing.ServerCrateSync;
import jackdaw.applecrates.network.packetprocessing.ServerGetSale;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="applecrates", bus=EventBusSubscriber.Bus.MOD)
public class NetworkSetup {
    private static final String PROTOCOL = "1.0.1";

    @SubscribeEvent
    public static void onRegisterPayload(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar NETWORK = event.registrar("applecrates").versioned(PROTOCOL);
        NETWORK.playToServer(PacketId.SPACKET_ADDOWNER_TYPE, PacketId.SPACKET_ADDOWNER_CODEC, PayLoadHandler::handleAddOwner);
        NETWORK.playToServer(PacketId.SPACKET_TRADE_TYPE, PacketId.SPACKET_TRADE_CODEC, PayLoadHandler::handleCrateSync);
        NETWORK.playToServer(PacketId.SPACKET_SALE_TYPE, PacketId.SPACKET_SALE_CODEC, PayLoadHandler::handleSale);
    }

    private static class PayLoadHandler {
        private PayLoadHandler() {
        }

        private static void handleAddOwner(ServerAddOwner packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    new ServerAddOwner(packet.newOwnerUsername()).run(player);
                }
            }).exceptionally(e -> {
                context.disconnect((Component)Component.literal((String)"Error when adding owner. Closing connection"));
                return null;
            });
        }

        private static void handleSale(ServerGetSale packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    new ServerGetSale().run(player);
                }
            });
        }

        private static void handleCrateSync(ServerCrateSync packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                Player patt0$temp = context.player();
                if (patt0$temp instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)patt0$temp;
                    new ServerCrateSync().run(player);
                }
            });
        }
    }
}

