/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.api;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import jackdaw.applecrates.api.exception.WoodException;
import jackdaw.applecrates.block.blockentity.CrateBlockEntityBase;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;

public class CrateWoodType {
    private static final Set<CrateWoodType> VALUES = new ObjectArraySet();
    private final String woodName;
    private final String yourModId;
    private final String compatId;
    private String beName;
    private ResourceLocation resourceLocation;
    private ResourceLocation resourceLocationBe;

    protected CrateWoodType(String compatId, String yourModId, String woodName) {
        this.woodName = woodName;
        this.yourModId = yourModId;
        this.compatId = compatId;
        this.beName = this.getBlockRegistryName() + "_be";
        this.resourceLocation = new ResourceLocation(yourModId, this.getBlockRegistryName());
        this.resourceLocationBe = new ResourceLocation(yourModId, this.getBeRegistryName());
    }

    public String getBlockRegistryName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name());
        builder.append("_crate");
        return builder.toString();
    }

    public String getCompatId() {
        return this.compatId;
    }

    public String getBeRegistryName() {
        return this.beName;
    }

    public String name() {
        return this.woodName;
    }

    public static void register(CrateWoodType woodType) {
        try {
            if (!VALUES.add(woodType)) {
                throw WoodException.INSTANCE.alreadyInList(woodType);
            }
        }
        catch (WoodException e) {
            LogUtils.getLogger().error(e.getMessage());
        }
    }

    public static Stream<CrateWoodType> values() {
        return VALUES.stream();
    }

    public static CrateWoodType create(String compatId, String yourModId, String woodName) {
        return new CrateWoodType(compatId, yourModId, woodName);
    }

    public static Block getBlock(CrateWoodType type) {
        return (Block)Registry.f_122824_.m_7745_(type.getFullRegistryResLoc());
    }

    public ResourceLocation getFullRegistryResLoc() {
        return this.resourceLocation;
    }

    public static BlockEntityType<CrateBlockEntityBase> getBlockEntityType(CrateWoodType type) {
        return (BlockEntityType)Registry.f_122830_.m_7745_(type.getFullBeRegistryResLoc());
    }

    public ResourceLocation getFullBeRegistryResLoc() {
        return this.resourceLocationBe;
    }

    public boolean isFrom(String modId) {
        return this.getYourModId().equals(modId);
    }

    public String getYourModId() {
        return this.yourModId;
    }

    public int hashCode() {
        return Objects.hash(this.compatId, this.woodName, this.yourModId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof CrateWoodType)) return false;
        CrateWoodType that = (CrateWoodType)o;
        if (!this.name().equals(that.name())) return false;
        if (!this.compatId.equals(that.compatId)) return false;
        if (!this.getYourModId().equals(that.getYourModId())) return false;
        return true;
    }
}

