/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.block.blockentity;

import jackdaw.applecrates.api.CrateWoodType;
import jackdaw.applecrates.container.IStackHandlerAdapter;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CrateBlockEntityBase
extends BlockEntity {
    public final IStackHandlerAdapter stackHandler;
    public boolean isUnlimitedShop = false;
    private Set<UUID> owners = new HashSet<UUID>();

    public CrateBlockEntityBase(CrateWoodType type, BlockPos pos, BlockState state, IStackHandlerAdapter stackHandler) {
        super(CrateWoodType.getBlockEntityType(type), pos, state);
        this.stackHandler = stackHandler;
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.loadCrateDataFromTag(tag);
    }

    protected void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        this.saveCrateDataToTag(tag);
    }

    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.saveCrateDataToTag(new CompoundTag());
    }

    protected CompoundTag saveCrateDataToTag(CompoundTag tag) {
        this.stackHandler.saveInventoryData(tag);
        tag.m_128379_("isUnlimited", this.isUnlimitedShop);
        if (!this.owners.isEmpty()) {
            ListTag ownersTag = this.owners.stream().map(NbtUtils::m_129226_).collect(Collectors.toCollection(ListTag::new));
            tag.m_128365_("owner", (Tag)ownersTag);
        }
        return tag;
    }

    protected void loadCrateDataFromTag(CompoundTag tag) {
        this.stackHandler.loadInventoryData(tag);
        if (tag.m_128441_("isUnlimited")) {
            this.isUnlimitedShop = tag.m_128471_("isUnlimited");
        }
        if (tag.m_128441_("owner")) {
            Tag owner = tag.m_128423_("owner");
            if (owner.m_6458_() == IntArrayTag.f_128599_) {
                this.owners = new HashSet<UUID>(Collections.singleton(NbtUtils.m_129233_((Tag)owner)));
            } else if (owner instanceof ListTag) {
                ListTag ownerList = (ListTag)owner;
                this.owners = ownerList.stream().map(NbtUtils::m_129233_).collect(Collectors.toCollection(HashSet::new));
            }
        }
    }

    public Set<UUID> getOwners() {
        return this.owners;
    }

    public void addOwner(UUID player) {
        this.owners.add(player);
    }

    public boolean isOwner(UUID uuid) {
        return this.owners.isEmpty() || this.owners.contains(uuid);
    }

    public boolean isOwner(@Nullable Player player) {
        return this.owners.isEmpty() || player != null && this.owners.contains(player.m_36316_().getId());
    }

    public static int getStockSignal(BlockGetter blockLevel, BlockPos pos) {
        BlockEntity blockEntity;
        if (blockLevel.m_8055_(pos).m_155947_() && (blockEntity = blockLevel.m_7702_(pos)) instanceof CrateBlockEntityBase) {
            CrateBlockEntityBase crate = (CrateBlockEntityBase)blockEntity;
            return crate.getStockLevel();
        }
        return 0;
    }

    public int getStockLevel() {
        ItemStack outputStack = this.stackHandler.getSavedTradeSlotsItem(1);
        if (!outputStack.m_41619_()) {
            double count = this.stackHandler.getCrateStock().getCountOfItemImmediately(outputStack.m_41720_());
            double totalPossible = outputStack.m_41741_() * 30;
            double ratio = 15.0 * (count / totalPossible);
            return (int)ratio;
        }
        return 0;
    }
}

