/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.container;

import jackdaw.applecrates.Constants;
import jackdaw.applecrates.Content;
import jackdaw.applecrates.block.blockentity.CrateBlockEntityBase;
import jackdaw.applecrates.container.IStackHandlerAdapter;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CrateMenu
extends AbstractContainerMenu {
    public IStackHandlerAdapter adapter;
    public boolean isUnlimitedShop = false;
    protected Level volatileLevel;
    protected BlockPos volatilePos;
    protected CrateBlockEntityBase crate;

    public CrateMenu(MenuType<?> type, int id, Inventory inventory, CrateBlockEntityBase crate, boolean unlimited) {
        this(type, id, inventory, crate.stackHandler, unlimited);
        this.volatileLevel = crate.m_58904_();
        this.volatilePos = crate.m_58899_();
        this.crate = crate;
    }

    protected CrateMenu(MenuType<?> type, int id, Inventory inventory, IStackHandlerAdapter adapter, boolean ul) {
        super(type, id);
        this.adapter = adapter;
        this.isUnlimitedShop = ul;
        Content.menuSlots.accept(this);
        for (int y = 0; y < 4; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index_rotated = (y + 3) % 4;
                int yPos = this.playerInventoryY() + index_rotated * 18 + (index_rotated == 3 ? 4 : 0);
                int xPos = this.playerInventoryX() + x * 18;
                int index = x + y * 9;
                this.m_38897_(new Slot((Container)inventory, index, xPos, yPos));
            }
        }
    }

    public boolean isOwner() {
        return false;
    }

    protected int playerInventoryX() {
        return this.isOwner() ? 19 : 8;
    }

    protected int playerInventoryY() {
        return this.isOwner() ? 108 : 57;
    }

    public ItemStack m_7648_(Player player, int index) {
        if (!((Slot)this.f_38839_.get(index)).m_6657_()) {
            return ItemStack.f_41583_;
        }
        if (Constants.isInCrateStock(index)) {
            this.m_38903_(((Slot)this.f_38839_.get(index)).m_7993_(), 35, 71, false);
        }
        return ItemStack.f_41583_;
    }

    public void m_150399_(int $$0, int $$1, ClickType $$2, Player $$3) {
        super.m_150399_($$0, $$1, $$2, $$3);
        this.markCrateChanged();
    }

    protected void markCrateChanged() {
        BlockEntity blockEntity;
        if (this.volatileLevel != null && this.volatilePos != null && (blockEntity = this.volatileLevel.m_7702_(this.volatilePos)) instanceof CrateBlockEntityBase) {
            CrateBlockEntityBase crate = (CrateBlockEntityBase)blockEntity;
            this.volatileLevel.m_7260_(this.volatilePos, this.volatileLevel.m_8055_(this.volatilePos), this.volatileLevel.m_8055_(this.volatilePos), 3);
            crate.m_6596_();
        }
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public void m_6877_(Player pPlayer) {
        pPlayer.m_150109_().m_150079_(this.adapter.getInteractableTradeItem(0));
        this.adapter.setInteractableTradeItem(0, ItemStack.f_41583_);
        super.m_6877_(pPlayer);
        this.markCrateChanged();
    }

    public boolean m_5882_(ItemStack stack, Slot slot) {
        if (slot.f_40219_ == 1 || slot.f_40219_ == 34) {
            return false;
        }
        return super.m_5882_(stack, slot);
    }

    @NotNull
    public Slot m_38897_(@NotNull Slot slot) {
        return super.m_38897_(slot);
    }

    public void addOwner(ServerPlayer currentOwner, String newOwnerUsername) {
        if (this.crate.isOwner((Player)currentOwner)) {
            currentOwner.f_8924_.m_6846_().m_11314_().stream().filter(player -> player.m_36316_().getName().equalsIgnoreCase(newOwnerUsername)).findFirst().ifPresentOrElse(player -> {
                UUID newOwner = player.m_20148_();
                if (this.crate.isOwner(newOwner)) {
                    currentOwner.m_213846_((Component)Component.m_237110_((String)"crate.add.owner.already_owner", (Object[])new Object[]{player.m_7755_()}));
                } else {
                    this.crate.addOwner(newOwner);
                    currentOwner.m_213846_((Component)Component.m_237110_((String)"crate.add.owner.success", (Object[])new Object[]{player.m_7755_()}));
                }
            }, () -> currentOwner.m_213846_((Component)Component.m_237110_((String)"crate.add.owner.not_found", (Object[])new Object[]{newOwnerUsername})));
        }
    }
}

