/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.block;

import jackdaw.applecrates.api.CrateWoodType;
import jackdaw.applecrates.block.blockentity.CrateBlockEntityBase;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DebugStickItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CrateBlockBase
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    protected static final VoxelShape SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0);
    private final CrateWoodType type;

    public CrateBlockBase(CrateWoodType type) {
        super(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50705_).m_60955_().m_60922_(CrateBlockBase::never).m_60924_(CrateBlockBase::never).m_60960_(CrateBlockBase::never).m_60971_(CrateBlockBase::never));
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
        this.type = type;
    }

    private static Boolean never(BlockState state, BlockGetter getter, BlockPos pos, EntityType<?> type) {
        return false;
    }

    private static boolean never(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos) {
        return false;
    }

    public BlockState m_5573_(BlockPlaceContext placeContext) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)placeContext.m_8125_());
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (pPlacer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlacer;
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof CrateBlockEntityBase) {
                CrateBlockEntityBase crate = (CrateBlockEntityBase)blockEntity;
                crate.addOwner(serverPlayer.m_20148_());
            }
        }
    }

    public int m_6378_(BlockState blockState, BlockGetter blockLevel, BlockPos pos, Direction dir) {
        return Mth.m_14045_((int)CrateBlockEntityBase.getStockSignal(blockLevel, pos), (int)0, (int)15);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState blockState, Level blockLevel, BlockPos pos) {
        return blockState.m_60746_((BlockGetter)blockLevel, pos, (Direction)blockState.m_61143_((Property)FACING));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> stateDef) {
        stateDef.m_61104_(new Property[]{FACING});
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return CrateWoodType.getBlockEntityType(this.type).m_155264_(pos, state);
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof CrateBlockEntityBase) {
                CrateBlockEntityBase crate = (CrateBlockEntityBase)blockEntity;
                if (pLevel instanceof ServerLevel) {
                    int i;
                    ServerLevel serverLevel = (ServerLevel)pLevel;
                    for (i = 0; i < 31; ++i) {
                        ItemStack stack = crate.stackHandler.getCrateStockItem(i);
                        if (i == 30) {
                            if (stack.m_41619_() || !stack.m_41782_() || !stack.m_41783_().m_128441_("cratestock")) continue;
                            int pay = stack.m_41783_().m_128451_("cratestock");
                            ItemStack prepCopy = stack.m_41777_();
                            prepCopy.m_41749_("cratestock");
                            while (pay > 0) {
                                ItemStack toDrop = prepCopy.m_41777_();
                                if (pay >= prepCopy.m_41741_()) {
                                    toDrop.m_41764_(prepCopy.m_41741_());
                                    pay -= prepCopy.m_41741_();
                                } else {
                                    toDrop.m_41764_(pay);
                                    pay = 0;
                                }
                                Containers.m_18992_((Level)serverLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)toDrop);
                            }
                            continue;
                        }
                        if (stack.m_41619_()) continue;
                        Containers.m_18992_((Level)serverLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)stack);
                    }
                    for (i = 0; i < 2; ++i) {
                        ItemStack toDrop = crate.stackHandler.getInteractableTradeItem(i);
                        Containers.m_18992_((Level)serverLevel, (double)pPos.m_123341_(), (double)pPos.m_123342_(), (double)pPos.m_123343_(), (ItemStack)toDrop);
                    }
                    pLevel.m_46717_(pPos, (Block)this);
                }
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public BlockState m_6843_(BlockState state, Rotation rotation) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rotation.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5939_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    public float m_5880_(BlockState pState, Player pPlayer, BlockGetter pLevel, BlockPos pPos) {
        CrateBlockEntityBase crate;
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof CrateBlockEntityBase && (crate = (CrateBlockEntityBase)blockEntity).isOwner(pPlayer)) {
            return super.m_5880_(pState, pPlayer, pLevel, pPos);
        }
        return 0.0f;
    }

    /*
     * Enabled aggressive block sorting
     */
    public InteractionResult m_6227_(BlockState blockState, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        boolean owner;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (!(blockEntity instanceof CrateBlockEntityBase)) return InteractionResult.FAIL;
        CrateBlockEntityBase crate = (CrateBlockEntityBase)blockEntity;
        if (!hand.equals((Object)InteractionHand.MAIN_HAND)) return InteractionResult.FAIL;
        if (level instanceof ServerLevel) {
            ServerLevel server = (ServerLevel)level;
            if (player.m_21120_(hand).m_41720_() instanceof DebugStickItem && server.m_7654_().m_6846_().m_11303_(player.m_36316_())) {
                crate.isUnlimitedShop = true;
                player.m_5661_((Component)Component.m_237115_((String)"crate.set.creative"), true);
                crate.m_6596_();
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
        }
        boolean bl = owner = !player.m_6144_() && crate.isOwner(player);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (owner) {
                this.openOwnerUI(serverPlayer, crate);
            } else {
                this.openBuyerUI(serverPlayer, crate);
            }
        }
        level.m_5594_(player, pos, SoundEvents.f_12635_, SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void openOwnerUI(ServerPlayer serverPlayer, CrateBlockEntityBase commonCrate) {
    }

    public void openBuyerUI(ServerPlayer serverPlayer, CrateBlockEntityBase commonCrate) {
    }
}

