/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.container.inventory;

import jackdaw.applecrates.Content;
import jackdaw.applecrates.container.inventory.ICrateStock;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class CrateStackHandler
extends ItemStackHandler
implements ICrateStock {
    private final Map<Item, Integer> itemCountCache = new HashMap<Item, Integer>();

    public CrateStackHandler() {
        super(31);
    }

    public int getCountOfItemCached(Item item) {
        return this.itemCountCache.computeIfAbsent(item, $ -> this.getCountOfItemImmediately(item));
    }

    @Override
    public int getCountOfItemImmediately(Item item) {
        int count = 0;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (!stack.m_150930_(item)) continue;
            count += stack.m_41613_();
        }
        return count;
    }

    @Override
    public boolean updateStackInPaymentSlot(ItemStack payment, boolean isUnlimitedShop) {
        ItemStack paymentCompare;
        if (isUnlimitedShop) {
            return true;
        }
        ItemStack prepPay = payment.m_41777_();
        if (this.getStackInSlot(30).m_41619_()) {
            prepPay.m_41764_(1);
            this.setStackInSlot(30, prepPay);
        }
        if ((paymentCompare = this.getStackInSlot(30).m_41777_()).m_41782_() && paymentCompare.m_41783_().m_128441_("cratestock")) {
            paymentCompare.m_41749_("cratestock");
        }
        if (!ItemStack.m_150942_((ItemStack)payment, (ItemStack)paymentCompare)) {
            return false;
        }
        ItemStack prepXchange = this.getStackInSlot(30).m_41777_();
        CompoundTag tag = prepXchange.m_41784_();
        if (tag.m_128441_("cratestock")) {
            tag.m_128405_("cratestock", tag.m_128451_("cratestock") + payment.m_41613_());
        } else {
            tag.m_128405_("cratestock", payment.m_41613_());
        }
        this.setStackInSlot(30, prepXchange);
        return true;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot == 30) {
            return stack;
        }
        return super.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (slot == 30) {
            return ItemStack.f_41583_;
        }
        return super.extractItem(slot, amount, simulate);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        return slot != 30 && super.isItemValid(slot, stack);
    }

    protected void onContentsChanged(int slot) {
        super.onContentsChanged(slot);
        this.itemCountCache.clear();
    }

    public void deserializeNBT(CompoundTag nbt) {
        Content.moneyPatch.apply(nbt);
        super.deserializeNBT(nbt);
        this.itemCountCache.clear();
    }
}

