/*
 * Decompiled with CFR 0.152.
 */
package jackdaw.applecrates.api;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import jackdaw.applecrates.api.exception.WoodException;
import jackdaw.applecrates.block.blockentity.CrateBlockEntityBase;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_2248;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class CrateWoodType {
    private static final Set<CrateWoodType> VALUES = new ObjectArraySet();
    private final String woodName;
    private final String yourModId;
    private final String compatId;
    private String beName;
    private class_2960 resourceLocation;
    private class_2960 resourceLocationBe;

    protected CrateWoodType(String compatId, String yourModId, String woodName) {
        this.woodName = woodName;
        this.yourModId = yourModId;
        this.compatId = compatId;
        this.beName = this.getBlockRegistryName() + "_be";
        this.resourceLocation = class_2960.method_60655((String)yourModId, (String)this.getBlockRegistryName());
        this.resourceLocationBe = class_2960.method_60655((String)yourModId, (String)this.getBeRegistryName());
    }

    public String getBlockRegistryName() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.name());
        builder.append("_crate");
        return builder.toString();
    }

    public String getCompatId() {
        return this.compatId;
    }

    public String getBeRegistryName() {
        return this.beName;
    }

    public String name() {
        return this.woodName;
    }

    public static void register(CrateWoodType woodType) {
        try {
            if (!VALUES.add(woodType)) {
                throw WoodException.INSTANCE.alreadyInList(woodType);
            }
        }
        catch (WoodException e) {
            LogUtils.getLogger().error(e.getMessage());
        }
    }

    public static Stream<CrateWoodType> values() {
        return VALUES.stream();
    }

    public static CrateWoodType create(String compatId, String yourModId, String woodName) {
        return new CrateWoodType(compatId, yourModId, woodName);
    }

    public static class_2248 getBlock(CrateWoodType type) {
        return (class_2248)class_7923.field_41175.method_10223(type.getFullRegistryResLoc());
    }

    public class_2960 getFullRegistryResLoc() {
        return this.resourceLocation;
    }

    public static class_2591<CrateBlockEntityBase> getBlockEntityType(CrateWoodType type) {
        return (class_2591)class_7923.field_41181.method_10223(type.getFullBeRegistryResLoc());
    }

    public class_2960 getFullBeRegistryResLoc() {
        return this.resourceLocationBe;
    }

    public boolean isFrom(String modId) {
        return this.getYourModId().equals(modId);
    }

    public String getYourModId() {
        return this.yourModId;
    }

    public int hashCode() {
        return Objects.hash(this.compatId, this.woodName, this.yourModId);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object o) {
        if (!(o instanceof CrateWoodType)) return false;
        CrateWoodType that = (CrateWoodType)o;
        if (!this.name().equals(that.name())) return false;
        if (!this.compatId.equals(that.compatId)) return false;
        if (!this.getYourModId().equals(that.getYourModId())) return false;
        return true;
    }
}

