/*
 * Decompiled with CFR 0.152.
 */
package org.rhm.burnable_cobwebs;

import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.TorchBlock;

public class BurnableCobwebsModCommon {
    public static final String MOD_ID = "burnable_cobwebs";

    public static boolean isLighter(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            return bi.getBlock() instanceof TorchBlock;
        }
        return item instanceof FlintAndSteelItem;
    }

    public static InteractionResult blockInteractEvent(Player player, InteractionHand hand, Level world, BlockPos pos) {
        if (world.getBlockState(pos).getBlock() != Blocks.COBWEB) {
            return InteractionResult.PASS;
        }
        ItemStack itemStack = player.getItemInHand(hand);
        if (BurnableCobwebsModCommon.isLighter(itemStack)) {
            world.setBlockAndUpdate(pos, Blocks.AIR.defaultBlockState());
            world.playSound(null, pos, SoundEvents.GENERIC_EXTINGUISH_FIRE, SoundSource.BLOCKS, 0.75f, world.random.nextFloat() * 0.25f + 0.75f);
            for (int i = 0; i < world.getRandom().nextInt(10, 25); ++i) {
                world.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pos.getX() + 0.5 + (double)world.getRandom().nextFloat(), (double)((float)pos.getY() + world.getRandom().nextFloat()), (double)pos.getZ() + 0.5 + (double)world.getRandom().nextFloat(), 0.0, 0.0, 0.0);
            }
            if (!world.isClientSide()) {
                ServerLevel serverWorld = (ServerLevel)world;
                if (itemStack.isDamageableItem()) {
                    itemStack.hurtAndBreak(1, serverWorld, (ServerPlayer)player, plr -> {});
                }
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }
}

