/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl;

import g_mungus.vlib.dimension.DimensionSettingsManager;
import g_mungus.zpl.block.ModBlockEntities;
import g_mungus.zpl.block.ModBlocks;
import g_mungus.zpl.block.thruster.ThrusterExhaustBlockEntityRenderer;
import g_mungus.zpl.entity.EnergyOrbEntityRenderer;
import g_mungus.zpl.entity.ModEntities;
import g_mungus.zpl.item.ModCreativeTabs;
import g_mungus.zpl.item.ModItems;
import g_mungus.zpl.particle.EnergyOrbParticle;
import g_mungus.zpl.particle.ModParticles;
import g_mungus.zpl.sound.ModSounds;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.RegisterParticleProvidersEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Mod(value="zpl")
public final class ZeroPointLabsMod {
    public static final String MOD_ID = "zpl";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"zpl");

    public ZeroPointLabsMod(FMLJavaModLoadingContext context) {
        IEventBus eventBus = context.getModEventBus();
        ModBlocks.BLOCKS.register(eventBus);
        ModBlockEntities.BLOCK_ENTITIES.register(eventBus);
        ModItems.ITEMS.register(eventBus);
        ModCreativeTabs.register(eventBus);
        ModParticles.PARTICLE_TYPES.register(eventBus);
        ModEntities.ENTITY_TYPES.register(eventBus);
        ModSounds.SOUND_EVENTS.register(eventBus);
        eventBus.addListener(this::registerRenderers);
        eventBus.addListener(this::registerParticleProviders);
    }

    public static double getDimensionScale(Level level) {
        return DimensionSettingsManager.INSTANCE.getSettingsForLevel("minecraft:dimension:" + level.m_46472_().m_135782_()).getShipScale();
    }

    private void registerRenderers(EntityRenderersEvent.RegisterRenderers event) {
        event.registerBlockEntityRenderer((BlockEntityType)ModBlockEntities.THRUSTER_EXHAUST_BLOCK_ENTITY.get(), ThrusterExhaustBlockEntityRenderer::new);
        event.registerEntityRenderer((EntityType)ModEntities.ENERGY_ORB.get(), EnergyOrbEntityRenderer::new);
    }

    private void registerParticleProviders(RegisterParticleProvidersEvent event) {
        event.registerSpriteSet((ParticleType)ModParticles.ENERGY_ORB.get(), EnergyOrbParticle.Provider::new);
    }
}

