/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl.block.assembly;

import g_mungus.vlib.api.VLibGameUtils;
import g_mungus.zpl.block.ModBlocks;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LaunchButtonBlock
extends Block {
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    private static final VoxelShape SHAPE_UNPRESSED = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)10.0, (double)2.0, (double)14.0, (double)13.0, (double)14.0));
    private static final VoxelShape SHAPE_PRESSED = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape)Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)11.0, (double)14.0));
    private final int ticksToStayPressed;

    public LaunchButtonBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false)));
        this.ticksToStayPressed = 20;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{POWERED});
    }

    @NotNull
    public VoxelShape m_5940_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? SHAPE_PRESSED : SHAPE_UNPRESSED;
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            return InteractionResult.CONSUME;
        }
        this.press(state, level, pos, player);
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public void m_7892_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Entity entity) {
        if (!level.f_46443_ && !((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.checkPressed(state, level, pos);
        }
    }

    protected void checkPressed(BlockState state, Level level, BlockPos pos) {
        if (!((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.press(state, level, pos, null);
        }
    }

    public void press(BlockState state, Level level, BlockPos pos, @Nullable Player player) {
        BlockState blockState = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        level.m_7731_(pos, blockState, 3);
        this.updateNeighbours(blockState, level, pos);
        this.playSound(player, (LevelAccessor)level, pos, true);
        level.m_142346_((Entity)player, GameEvent.f_223702_, pos);
        level.m_186460_(pos, (Block)this, this.ticksToStayPressed);
        this.tryAssembly(level, pos);
    }

    private void tryAssembly(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            Block launchButton = (Block)ModBlocks.LAUNCH_BUTTON.get();
            Block launchPlatform = (Block)ModBlocks.LAUNCH_PLATFORM.get();
            HashSet<BlockPos> checked = new HashSet<BlockPos>();
            LinkedList<BlockPos> toCheck = new LinkedList<BlockPos>();
            toCheck.add(pos.m_7495_());
            while (!toCheck.isEmpty()) {
                BlockPos current = (BlockPos)toCheck.poll();
                if (checked.contains(current) || !level.m_8055_(current).m_60713_(launchPlatform)) continue;
                checked.add(current);
                BlockState aboveState = level.m_8055_(current.m_7494_());
                if (!aboveState.m_60713_(launchButton) && !aboveState.m_60795_()) {
                    VLibGameUtils.INSTANCE.assembleByConnectivity(serverLevel, current.m_7494_(), List.of(launchPlatform, launchButton));
                    return;
                }
                toCheck.add(current.m_122012_());
                toCheck.add(current.m_122019_());
                toCheck.add(current.m_122029_());
                toCheck.add(current.m_122024_());
            }
        }
    }

    protected void playSound(@Nullable Player player, LevelAccessor level, BlockPos pos, boolean pressed) {
        level.m_5594_((Player)(pressed ? player : null), pos, this.getSound(pressed), SoundSource.BLOCKS, 1.2f, pressed ? 0.05f : 0.4f);
    }

    protected SoundEvent getSound(boolean pressed) {
        return pressed ? SoundEvents.f_12444_ : SoundEvents.f_12443_;
    }

    public void m_213897_(@NotNull BlockState state, @NotNull ServerLevel level, @NotNull BlockPos pos, @NotNull RandomSource random) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            this.checkPressed(state, level, pos);
        }
    }

    public void m_6810_(BlockState arg, Level arg2, BlockPos arg3, BlockState arg4, boolean bl) {
        if (bl || arg.m_60713_(arg4.m_60734_())) {
            return;
        }
        if (((Boolean)arg.m_61143_((Property)POWERED)).booleanValue()) {
            this.updateNeighbours(arg, arg2, arg3);
        }
        super.m_6810_(arg, arg2, arg3, arg4, bl);
    }

    protected void checkPressed(BlockState state, ServerLevel level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)POWERED)).booleanValue()) {
            BlockState blockState = (BlockState)state.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false));
            level.m_7731_(pos, blockState, 3);
            this.updateNeighbours(blockState, (Level)level, pos);
            this.playSound(null, (LevelAccessor)level, pos, false);
            level.m_142346_(null, GameEvent.f_223703_, pos);
        }
    }

    private void updateNeighbours(BlockState state, Level level, BlockPos pos) {
        level.m_46672_(pos, (Block)this);
        level.m_46672_(pos.m_7495_(), (Block)this);
    }

    public int m_6378_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false ? 15 : 0;
    }

    public int m_6376_(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull Direction direction) {
        return (Boolean)state.m_61143_((Property)POWERED) != false && direction == Direction.DOWN ? 15 : 0;
    }

    public boolean m_7899_(@NotNull BlockState state) {
        return true;
    }
}

