/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl.block.gyro;

import g_mungus.zpl.block.gyro.GyroForceApplier;
import g_mungus.zpl.block.gyro.GyroscopeBlockEntity;
import g_mungus.zpl.block.thruster.ThrusterData;
import g_mungus.zpl.ship.ZPLShipAttachment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class GyroscopeBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;

    public GyroscopeBlock(BlockBehaviour.Properties arg) {
        super(arg);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43723_() != null && context.m_43723_().m_6144_() ? context.m_7820_() : context.m_7820_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos arg, BlockState arg2) {
        return new GyroscopeBlockEntity(arg, arg2);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState arg2, BlockEntityType<T> arg3) {
        return level.m_5776_() ? null : (level1, pos, state, blockEntity) -> {
            if (blockEntity instanceof GyroscopeBlockEntity) {
                GyroscopeBlockEntity gyro = (GyroscopeBlockEntity)blockEntity;
                gyro.tick();
            }
        };
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        if (!level.m_5776_()) {
            GyroscopeBlock.addApplier(state, level, pos);
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }

    public static void addApplier(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        ZPLShipAttachment attachment = ZPLShipAttachment.get(level, pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (attachment != null && blockEntity instanceof GyroscopeBlockEntity) {
            GyroscopeBlockEntity gyro = (GyroscopeBlockEntity)blockEntity;
            gyro.thrust = new ThrusterData(VectorConversionsMCKt.toJOMLD((Vec3i)((Direction)state.m_61143_((Property)FACING)).m_122424_().m_122436_()), 0.0);
            GyroForceApplier applier = new GyroForceApplier(gyro.thrust);
            attachment.addApplier(pos, applier);
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        GyroscopeBlock.removeApplier(level, pos);
        super.m_6810_(state, level, pos, newState, isMoving);
    }

    private static void removeApplier(@NotNull Level level, @NotNull BlockPos pos) {
        ZPLShipAttachment ship;
        if (!level.m_5776_() && (ship = ZPLShipAttachment.get(level, pos)) != null) {
            ship.removeApplier((ServerLevel)level, pos);
        }
    }
}

