/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl.block.launcher;

import g_mungus.zpl.block.ModBlockEntities;
import g_mungus.zpl.block.launcher.EnergyOrbLauncherBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnergyOrbLauncherBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty ROTATION = IntegerProperty.m_61631_((String)"rotation", (int)0, (int)8);
    private static final Vec3[] ROTATION_OFFSETS = new Vec3[]{new Vec3(0.0, 0.0, 0.0), new Vec3(5.0, 0.0, 0.0), new Vec3(10.0, 0.0, 0.0), new Vec3(-5.0, 0.0, 0.0), new Vec3(-10.0, 0.0, 0.0), new Vec3(0.0, 5.0, 0.0), new Vec3(0.0, 10.0, 0.0), new Vec3(0.0, -5.0, 0.0), new Vec3(0.0, -10.0, 0.0)};

    public EnergyOrbLauncherBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING}).m_61104_(new Property[]{ROTATION});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)context.m_7820_().m_122424_());
    }

    @NotNull
    public InteractionResult m_6227_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult result) {
        if (player.m_21120_(hand).m_41619_() && player.m_6144_()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)ROTATION, (Comparable)Integer.valueOf(((Integer)state.m_61143_((Property)ROTATION) + 1) % 9)), 2);
            player.m_6674_(hand);
            return InteractionResult.CONSUME;
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    public static Vec3 getAimVector(BlockState state) {
        double angleRadians;
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        int rotation = (Integer)state.m_61143_((Property)ROTATION);
        Vec3 localDirection = new Vec3(0.0, 0.0, -1.0);
        Vec3 rotationOffset = ROTATION_OFFSETS[rotation];
        if (rotationOffset.f_82479_ != 0.0) {
            angleRadians = -Math.toRadians(rotationOffset.f_82479_);
            localDirection = localDirection.m_82496_((float)angleRadians);
        }
        if (rotationOffset.f_82480_ != 0.0) {
            angleRadians = Math.toRadians(rotationOffset.f_82480_);
            localDirection = localDirection.m_82524_((float)angleRadians);
        }
        if (rotationOffset.f_82481_ != 0.0) {
            angleRadians = Math.toRadians(rotationOffset.f_82481_);
            localDirection = localDirection.m_82535_((float)angleRadians);
        }
        Vec3 worldDirection = EnergyOrbLauncherBlock.transformLocalToWorld(localDirection, facing);
        return worldDirection.m_82541_();
    }

    private static Vec3 transformLocalToWorld(Vec3 local, Direction facing) {
        return switch (facing) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.NORTH -> new Vec3(local.f_82479_, local.f_82480_, local.f_82481_);
            case Direction.SOUTH -> new Vec3(-local.f_82479_, local.f_82480_, -local.f_82481_);
            case Direction.EAST -> new Vec3(-local.f_82481_, local.f_82480_, local.f_82479_);
            case Direction.WEST -> new Vec3(local.f_82481_, local.f_82480_, -local.f_82479_);
            case Direction.UP -> new Vec3(local.f_82479_, -local.f_82481_, local.f_82480_);
            case Direction.DOWN -> new Vec3(local.f_82479_, local.f_82481_, -local.f_82480_);
        };
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new EnergyOrbLauncherBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.f_46443_ ? null : EnergyOrbLauncherBlock.createTickerHelper(blockEntityType, (BlockEntityType)ModBlockEntities.ENERGY_ORB_LAUNCHER.get(), EnergyOrbLauncherBlockEntity::serverTick);
    }

    @Nullable
    protected static <E extends BlockEntity, A extends BlockEntity> BlockEntityTicker<A> createTickerHelper(BlockEntityType<A> givenType, BlockEntityType<E> expectedType, BlockEntityTicker<? super E> ticker) {
        return expectedType == givenType ? ticker : null;
    }
}

