/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl.block.launcher;

import g_mungus.zpl.ZeroPointLabsMod;
import g_mungus.zpl.block.ModBlockEntities;
import g_mungus.zpl.block.launcher.EnergyOrbLauncherBlock;
import g_mungus.zpl.entity.EnergyOrbEntity;
import g_mungus.zpl.sound.ModSounds;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.EnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix4dc;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class EnergyOrbLauncherBlockEntity
extends BlockEntity {
    private static final int MAX_ENERGY = 1000;
    private static final int MAX_TRANSFER = 500;
    private static final int ENERGY_PER_SHOT = 64;
    private int tickCounter = 0;
    private final EnergyStorage energyStorage = new EnergyStorage(1000, 500, 0){

        public int extractEnergy(int maxExtract, boolean simulate) {
            if (!simulate) {
                int energyExtracted = Math.min(this.energy, maxExtract);
                this.energy -= energyExtracted;
                return energyExtracted;
            }
            return Math.min(this.energy, maxExtract);
        }
    };
    private final LazyOptional<EnergyStorage> energyHandler = LazyOptional.of(() -> new EnergyStorage(1000, 500, 0){

        public int receiveEnergy(int maxReceive, boolean simulate) {
            return EnergyOrbLauncherBlockEntity.this.energyStorage.receiveEnergy(maxReceive, simulate);
        }

        public int extractEnergy(int maxExtract, boolean simulate) {
            return 0;
        }

        public int getEnergyStored() {
            return EnergyOrbLauncherBlockEntity.this.energyStorage.getEnergyStored();
        }

        public int getMaxEnergyStored() {
            return EnergyOrbLauncherBlockEntity.this.energyStorage.getMaxEnergyStored();
        }

        public boolean canExtract() {
            return false;
        }

        public boolean canReceive() {
            return EnergyOrbLauncherBlockEntity.this.energyStorage.canReceive();
        }
    });

    public EnergyOrbLauncherBlockEntity(BlockPos pos, BlockState blockState) {
        super((BlockEntityType)ModBlockEntities.ENERGY_ORB_LAUNCHER.get(), pos, blockState);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ENERGY) {
            return this.energyHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.energyHandler.invalidate();
    }

    public void m_142466_(@NotNull CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128441_("Energy")) {
            this.energyStorage.deserializeNBT(tag.m_128423_("Energy"));
        }
    }

    public void m_183515_(@NotNull CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128365_("Energy", this.energyStorage.serializeNBT());
    }

    public static void serverTick(Level level, BlockPos pos, BlockState state, EnergyOrbLauncherBlockEntity blockEntity) {
        if (level.f_46443_) {
            return;
        }
        boolean isPowered = level.m_276867_(pos);
        if (isPowered && blockEntity.tickCounter == 0 && blockEntity.energyStorage.getEnergyStored() >= 64) {
            blockEntity.energyStorage.extractEnergy(64, false);
            blockEntity.fireEnergyOrb(level, pos, state);
        }
        if (blockEntity.tickCounter != 0 || isPowered) {
            int TICKS_PER_SHOT = 5;
            blockEntity.tickCounter = (blockEntity.tickCounter + 1) % TICKS_PER_SHOT;
        }
    }

    private void fireEnergyOrb(Level level, BlockPos pos, BlockState state) {
        EnergyOrbEntity energyOrb;
        Vec3 direction = EnergyOrbLauncherBlock.getAimVector(state);
        double scale = ZeroPointLabsMod.getDimensionScale(level);
        Vec3 blockCenter = Vec3.m_82512_((Vec3i)pos);
        Vec3 spawnPos = blockCenter.m_82549_(direction.m_82490_(0.6));
        Vec3 velocity = scale < 0.5 ? direction.m_82490_(7.0) : direction.m_82490_(3.5);
        Ship ship = VSGameUtilsKt.getShipManagingPos((Level)level, (BlockPos)pos);
        if (ship != null) {
            Matrix4dc transform = ship.getTransform().getShipToWorld();
            Vector3d newVelocity = transform.transformDirection(VectorConversionsMCKt.toJOML((Vec3)velocity));
            Vector3d newPosition = transform.transformPosition(VectorConversionsMCKt.toJOML((Vec3)blockCenter));
            newPosition = newPosition.add((Vector3dc)newVelocity.normalize(0.6, new Vector3d()));
            Vector3dc shipVelocity = ship.getVelocity();
            Vector3d velocityDirection = newVelocity.normalize(new Vector3d());
            double parallelComponent = shipVelocity.dot((Vector3dc)velocityDirection);
            Vector3d parallelVelocity = velocityDirection.mul(parallelComponent, new Vector3d());
            Vector3d finalVelocity = scale < 0.5 ? newVelocity.add((Vector3dc)parallelVelocity.mul(scale), new Vector3d()) : newVelocity;
            energyOrb = new EnergyOrbEntity(level, newPosition.x, newPosition.y, newPosition.z, VectorConversionsMCKt.toMinecraft((Vector3dc)finalVelocity));
            energyOrb.setExcludedShipId(ship.getId());
        } else {
            energyOrb = new EnergyOrbEntity(level, spawnPos.f_82479_, spawnPos.f_82480_, spawnPos.f_82481_, velocity.m_82490_(scale));
        }
        level.m_7967_((Entity)energyOrb);
        level.m_5594_(null, pos, (SoundEvent)ModSounds.ENERGY_ORB_SHOOT.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
    }
}

