/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl.block.thruster;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import g_mungus.zpl.ShaderRegistry;
import g_mungus.zpl.block.thruster.ThrusterExhaustBlock;
import g_mungus.zpl.block.thruster.ThrusterExhaustBlockEntity;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import team.lodestar.lodestone.registry.client.LodestoneRenderTypeRegistry;
import team.lodestar.lodestone.systems.rendering.LodestoneRenderType;
import team.lodestar.lodestone.systems.rendering.StateShards;

public class ThrusterExhaustBlockEntityRenderer
implements BlockEntityRenderer<ThrusterExhaustBlockEntity> {
    private static LodestoneRenderType THRUST;
    private final List<Vector4f> shape = List.of(new Vector4f(0.6667f, 0.0f, 0.5f, 0.0f), new Vector4f(0.5833f, 0.0f, 0.6443f, 0.167f), new Vector4f(0.4167f, 0.0f, 0.6443f, 0.333f), new Vector4f(0.3333f, 0.0f, 0.5f, 0.5f), new Vector4f(0.4167f, 0.0f, 0.3557f, 0.667f), new Vector4f(0.5833f, 0.0f, 0.3557f, 0.833f), new Vector4f(0.6667f, 0.0f, 0.5f, 1.0f), new Vector4f(1.0f, 0.1f, 0.5f, 0.0f), new Vector4f(0.75f, 0.1f, 0.9333f, 0.167f), new Vector4f(0.25f, 0.1f, 0.9333f, 0.333f), new Vector4f(0.0f, 0.1f, 0.5f, 0.5f), new Vector4f(0.25f, 0.1f, 0.0667f, 0.667f), new Vector4f(0.75f, 0.1f, 0.0667f, 0.833f), new Vector4f(1.0f, 0.1f, 0.5f, 1.0f), new Vector4f(0.6667f, 1.0f, 0.5f, 0.0f), new Vector4f(0.5833f, 1.0f, 0.6443f, 0.167f), new Vector4f(0.4167f, 1.0f, 0.6443f, 0.333f), new Vector4f(0.3333f, 1.0f, 0.5f, 0.5f), new Vector4f(0.4167f, 1.0f, 0.3557f, 0.667f), new Vector4f(0.5833f, 1.0f, 0.3557f, 0.833f), new Vector4f(0.6667f, 1.0f, 0.5f, 1.0f));

    public ThrusterExhaustBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    private static LodestoneRenderType getThrustRenderType() {
        if (THRUST == null) {
            THRUST = LodestoneRenderTypeRegistry.createGenericRenderType((String)"thruster_render_type", (VertexFormat)DefaultVertexFormat.f_85817_, (VertexFormat.Mode)VertexFormat.Mode.QUADS, (LodestoneRenderTypeRegistry.LodestoneCompositeStateBuilder)LodestoneRenderTypeRegistry.builder().setShaderState(ShaderRegistry.THRUST_SHADER).setTransparencyState(StateShards.ADDITIVE_TRANSPARENCY));
        }
        return THRUST;
    }

    public int m_142163_() {
        return 256;
    }

    public boolean shouldRenderOffScreen(ThrusterExhaustBlockEntity arg) {
        return true;
    }

    public boolean shouldRender(ThrusterExhaustBlockEntity arg, Vec3 arg2) {
        return true;
    }

    public void render(ThrusterExhaustBlockEntity blockEntity, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        BlockState blockState = blockEntity.m_58900_();
        float power = (float)((Integer)blockState.m_61143_((Property)ThrusterExhaustBlock.POWER)).intValue() / 15.0f;
        if (power < 1.0E-4f) {
            return;
        }
        float hScale = (1.0f + power) / 2.0f;
        poseStack.m_85836_();
        poseStack.m_85837_(0.5, 0.5, 0.5);
        Direction direction = (Direction)blockState.m_61143_((Property)ThrusterExhaustBlock.FACING);
        switch (direction) {
            case UP: {
                break;
            }
            case DOWN: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
                break;
            }
            case NORTH: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(-90.0f));
                break;
            }
            case SOUTH: {
                poseStack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
                break;
            }
            case WEST: {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(90.0f));
                break;
            }
            case EAST: {
                poseStack.m_252781_(Axis.f_252403_.m_252977_(-90.0f));
            }
        }
        poseStack.m_85837_(-0.5, -0.5, -0.5);
        poseStack.m_252880_(-0.5f * power, 1.0f, -0.5f * power);
        poseStack.m_85841_(2.0f * hScale, 6.0f * power, 2.0f * hScale);
        Matrix4f matrix4f = poseStack.m_85850_().m_252922_();
        this.renderCube(blockEntity, matrix4f, bufferSource.m_6299_((RenderType)ThrusterExhaustBlockEntityRenderer.getThrustRenderType()));
        poseStack.m_85849_();
    }

    private void renderCube(ThrusterExhaustBlockEntity blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer) {
        this.renderHex(blockEntity, matrix4f, vertexConsumer, 0);
        this.renderHex(blockEntity, matrix4f, vertexConsumer, 7);
    }

    private void renderHex(ThrusterExhaustBlockEntity blockEntity, Matrix4f matrix4f, VertexConsumer vertexConsumer, int offset) {
        this.renderFace(blockEntity, matrix4f, vertexConsumer, this.shape.get(0 + offset), this.shape.get(1 + offset), this.shape.get(8 + offset), this.shape.get(7 + offset));
        this.renderFace(blockEntity, matrix4f, vertexConsumer, this.shape.get(1 + offset), this.shape.get(2 + offset), this.shape.get(9 + offset), this.shape.get(8 + offset));
        this.renderFace(blockEntity, matrix4f, vertexConsumer, this.shape.get(2 + offset), this.shape.get(3 + offset), this.shape.get(10 + offset), this.shape.get(9 + offset));
        this.renderFace(blockEntity, matrix4f, vertexConsumer, this.shape.get(3 + offset), this.shape.get(4 + offset), this.shape.get(11 + offset), this.shape.get(10 + offset));
        this.renderFace(blockEntity, matrix4f, vertexConsumer, this.shape.get(4 + offset), this.shape.get(5 + offset), this.shape.get(12 + offset), this.shape.get(11 + offset));
        this.renderFace(blockEntity, matrix4f, vertexConsumer, this.shape.get(5 + offset), this.shape.get(6 + offset), this.shape.get(13 + offset), this.shape.get(12 + offset));
    }

    private void renderFace(ThrusterExhaustBlockEntity arg, Matrix4f matrix4f, VertexConsumer vertexConsumer, Vector4f a, Vector4f b, Vector4f c, Vector4f d) {
        vertexConsumer.m_252986_(matrix4f, d.x, d.y, d.z).m_7421_(d.y, d.w).m_5752_();
        vertexConsumer.m_252986_(matrix4f, c.x, c.y, c.z).m_7421_(c.y, c.w).m_5752_();
        vertexConsumer.m_252986_(matrix4f, b.x, b.y, b.z).m_7421_(b.y, b.w).m_5752_();
        vertexConsumer.m_252986_(matrix4f, a.x, a.y, a.z).m_7421_(a.y, a.w).m_5752_();
    }
}

