/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl.block.thruster;

import g_mungus.zpl.block.thruster.ThrusterData;
import g_mungus.zpl.ship.IForceApplier;
import net.minecraft.core.BlockPos;
import org.joml.Vector3d;
import org.joml.Vector3dc;
import org.valkyrienskies.core.api.ships.properties.ShipTransform;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;

public class ThrusterForceApplier
implements IForceApplier {
    public ThrusterData thrust;
    private final Vector3d worldForceDirection = new Vector3d();

    public ThrusterForceApplier(ThrusterData thrust) {
        this.thrust = thrust;
    }

    @Override
    public void applyForces(BlockPos pos, PhysShipImpl ship) {
        ShipTransform transform = ship.getTransform();
        Vector3dc scaling = transform.getShipToWorldScaling();
        double massScaleFactor = scaling.x() * scaling.y() * scaling.z() * 1.5;
        if (this.thrust.strength > 0.01) {
            Vector3d offAxisVelocityShip;
            transform.getShipToWorld().transformDirection((Vector3dc)this.thrust.direction, this.worldForceDirection);
            ship.applyInvariantForce((Vector3dc)this.worldForceDirection.normalize(this.thrust.strength * 800000.0).mul(massScaleFactor).mul(scaling));
            Vector3dc worldVelocity = ship.getPoseVel().getVel();
            Vector3d shipSpaceVelocity = transform.getWorldToShip().transformDirection(worldVelocity, new Vector3d());
            double velocityDotThrust = shipSpaceVelocity.dot((Vector3dc)this.thrust.direction);
            if (velocityDotThrust > 0.0) {
                Vector3d onAxisVelocity = this.thrust.direction.mul(velocityDotThrust, new Vector3d());
                offAxisVelocityShip = shipSpaceVelocity.sub((Vector3dc)onAxisVelocity, new Vector3d());
            } else {
                offAxisVelocityShip = new Vector3d((Vector3dc)shipSpaceVelocity);
            }
            Vector3d offAxisVelocityWorld = transform.getShipToWorld().transformDirection((Vector3dc)offAxisVelocityShip, new Vector3d());
            Vector3d dampingForce = offAxisVelocityWorld.mul(massScaleFactor * -8000.0 * this.thrust.strength, new Vector3d());
            ship.applyInvariantForce((Vector3dc)dampingForce);
        }
        ship.applyInvariantForce((Vector3dc)ship.getPoseVel().getVel().mul(-2400.0, new Vector3d()).mul(massScaleFactor));
    }
}

