/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl.entity;

import g_mungus.zpl.ZeroPointLabsMod;
import g_mungus.zpl.entity.ModEntities;
import g_mungus.zpl.particle.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.core.api.ships.Ship;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class EnergyOrbEntity
extends Projectile {
    private static final EntityDataAccessor<Long> EXCLUDED_SHIP_ID = SynchedEntityData.m_135353_(EnergyOrbEntity.class, (EntityDataSerializer)EntityDataSerializers.f_244073_);
    private static final long NO_SHIP_ID = -1L;

    public EnergyOrbEntity(EntityType<? extends EnergyOrbEntity> entityType, Level level) {
        super(entityType, level);
    }

    public EnergyOrbEntity(Level level, double x, double y, double z, Vec3 velocity) {
        super((EntityType)ModEntities.ENERGY_ORB.get(), level);
        this.m_6034_(x, y, z);
        this.m_20256_(velocity);
    }

    public void setExcludedShipId(@Nullable Long shipId) {
        this.f_19804_.m_135381_(EXCLUDED_SHIP_ID, (Object)(shipId != null ? shipId : -1L));
    }

    @Nullable
    public Long getExcludedShipId() {
        long shipId = (Long)this.f_19804_.m_135370_(EXCLUDED_SHIP_ID);
        return shipId == -1L ? null : Long.valueOf(shipId);
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(EXCLUDED_SHIP_ID, (Object)-1L);
    }

    public void m_8119_() {
        super.m_8119_();
        HitResult hitResult = ProjectileUtil.m_278158_((Entity)this, this::m_5603_);
        Long excludedShipId = this.getExcludedShipId();
        if (hitResult.m_6662_() == HitResult.Type.BLOCK && excludedShipId != null) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            Ship ship = VSGameUtilsKt.getShipManagingPos((Level)this.m_9236_(), (BlockPos)blockHit.m_82425_());
            if (ship == null || ship.getId() != excludedShipId.longValue()) {
                this.m_6532_(hitResult);
            }
        } else if (hitResult.m_6662_() != HitResult.Type.MISS) {
            this.m_6532_(hitResult);
        }
        Vec3 motion = this.m_20184_();
        this.m_6034_(this.m_20185_() + motion.f_82479_, this.m_20186_() + motion.f_82480_, this.m_20189_() + motion.f_82481_);
        if (this.m_9236_().f_46443_) {
            double scale = ZeroPointLabsMod.getDimensionScale(this.m_9236_());
            this.m_9236_().m_7106_((ParticleOptions)ModParticles.ENERGY_ORB.get(), this.f_19790_, this.f_19791_, this.f_19792_, scale, 0.0, 0.0);
        }
        if (this.f_19797_ > 160) {
            this.m_146870_();
        }
    }

    protected void m_8060_(BlockHitResult result) {
        super.m_8060_(result);
        this.explode();
    }

    protected void m_5790_(EntityHitResult result) {
        super.m_5790_(result);
        result.m_82443_().m_6469_(this.m_269291_().m_269390_((Entity)this, this.m_19749_()), 5.0f);
        this.explode();
    }

    private void explode() {
        if (!this.m_9236_().f_46443_) {
            this.m_9236_().m_254849_((Entity)this, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2.0f, Level.ExplosionInteraction.BLOCK);
        }
        this.m_146870_();
    }

    protected boolean m_5603_(Entity target) {
        return super.m_5603_(target) && !target.equals((Object)this.m_19749_());
    }

    public boolean m_6783_(double distance) {
        return distance < 4096.0;
    }

    public boolean m_6128_() {
        return true;
    }

    protected void m_7378_(CompoundTag tag) {
        if (tag.m_128441_("ExcludedShipId")) {
            this.setExcludedShipId(tag.m_128454_("ExcludedShipId"));
        }
    }

    protected void m_7380_(CompoundTag tag) {
        Long shipId = this.getExcludedShipId();
        if (shipId != null) {
            tag.m_128356_("ExcludedShipId", shipId.longValue());
        }
    }
}

