/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl.block.thruster;

import g_mungus.zpl.block.thruster.ThrusterData;
import g_mungus.zpl.block.thruster.ThrusterExhaustBlockEntity;
import g_mungus.zpl.block.thruster.ThrusterForceApplier;
import g_mungus.zpl.ship.ZPLShipAttachment;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.valkyrienskies.mod.common.util.VectorConversionsMCKt;

public class ThrusterExhaustBlock
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61372_;
    public static final IntegerProperty POWER = BlockStateProperties.f_61426_;

    public ThrusterExhaustBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, POWER});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        Direction direction = context.m_43723_() != null && context.m_43723_().m_6144_() ? context.m_7820_() : context.m_7820_().m_122424_();
        return (BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ThrusterExhaustBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return level.m_5776_() ? null : (level1, pos, state1, blockEntity) -> {
            if (blockEntity instanceof ThrusterExhaustBlockEntity) {
                ThrusterExhaustBlockEntity exampleBlockEntity = (ThrusterExhaustBlockEntity)blockEntity;
                exampleBlockEntity.tick();
            }
        };
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        Direction dir = (Direction)state.m_61143_((Property)FACING);
        VoxelShape upShape = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)10.0, (double)14.0), (VoxelShape)Block.m_49796_((double)1.0, (double)10.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));
        VoxelShape downShape = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)6.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0), (VoxelShape)Block.m_49796_((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)6.0, (double)15.0));
        VoxelShape northShape = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)6.0, (double)14.0, (double)14.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)0.0, (double)15.0, (double)15.0, (double)6.0));
        VoxelShape southShape = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)2.0, (double)2.0, (double)0.0, (double)14.0, (double)14.0, (double)10.0), (VoxelShape)Block.m_49796_((double)1.0, (double)1.0, (double)10.0, (double)15.0, (double)15.0, (double)16.0));
        VoxelShape westShape = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)6.0, (double)2.0, (double)2.0, (double)16.0, (double)14.0, (double)14.0), (VoxelShape)Block.m_49796_((double)0.0, (double)1.0, (double)1.0, (double)6.0, (double)15.0, (double)15.0));
        VoxelShape eastShape = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)2.0, (double)2.0, (double)10.0, (double)14.0, (double)14.0), (VoxelShape)Block.m_49796_((double)10.0, (double)1.0, (double)1.0, (double)16.0, (double)15.0, (double)15.0));
        return switch (dir) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> upShape;
            case Direction.DOWN -> downShape;
            case Direction.NORTH -> northShape;
            case Direction.SOUTH -> southShape;
            case Direction.WEST -> westShape;
            case Direction.EAST -> eastShape;
        };
    }

    public void m_6807_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState oldState, boolean isMoving) {
        if (!level.m_5776_()) {
            ThrusterExhaustBlock.addApplier(state, level, pos);
        }
        super.m_6807_(state, level, pos, oldState, isMoving);
    }

    public static void addApplier(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos) {
        ZPLShipAttachment attachment = ZPLShipAttachment.get(level, pos);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (attachment != null && blockEntity instanceof ThrusterExhaustBlockEntity) {
            ThrusterExhaustBlockEntity thrusterBlockEntity = (ThrusterExhaustBlockEntity)blockEntity;
            thrusterBlockEntity.thrust = new ThrusterData(VectorConversionsMCKt.toJOMLD((Vec3i)((Direction)state.m_61143_((Property)FACING)).m_122424_().m_122436_()), 0.0);
            ThrusterForceApplier applier = new ThrusterForceApplier(thrusterBlockEntity.thrust);
            attachment.addApplier(pos, applier);
        }
    }

    public void m_6810_(@NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull BlockState newState, boolean isMoving) {
        ZPLShipAttachment ship;
        if (!level.m_5776_() && (ship = ZPLShipAttachment.get(level, pos)) != null) {
            ship.removeApplier((ServerLevel)level, pos);
        }
        super.m_6810_(state, level, pos, newState, isMoving);
    }
}

