/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl.block.thruster;

import g_mungus.zpl.block.ModBlockEntities;
import g_mungus.zpl.block.ModBlocks;
import g_mungus.zpl.block.thruster.IonModulatorBlock;
import g_mungus.zpl.block.thruster.ThrusterData;
import g_mungus.zpl.block.thruster.ThrusterExhaustBlock;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.energy.IEnergyStorage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ThrusterExhaustBlockEntity
extends BlockEntity {
    public ThrusterData thrust;

    public ThrusterExhaustBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntities.THRUSTER_EXHAUST_BLOCK_ENTITY.get(), pos, state);
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        int prev = (Integer)this.m_58900_().m_61143_((Property)ThrusterExhaustBlock.POWER);
        int current = this.getThrusterStrength(prev);
        double force_strength = (double)current / 15.0;
        if (current != prev) {
            this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)ThrusterExhaustBlock.POWER, (Comparable)Integer.valueOf(current)), 3);
        }
        if (this.thrust == null) {
            ThrusterExhaustBlock.addApplier(this.m_58900_(), this.f_58857_, this.m_58899_());
        }
        if (this.thrust != null) {
            this.thrust.strength = force_strength;
        }
    }

    private int getThrusterStrength(int prev) {
        int output = prev;
        int target = this.getInputSignal();
        if (output < target) {
            ++output;
        } else if (output > target) {
            --output;
        }
        double requestedStrength = (double)output / 15.0;
        double requestedEnergy = requestedStrength * 100.0;
        LazyOptional<IEnergyStorage> energySource = this.getNeighborEnergyStorage();
        AtomicInteger extracted = new AtomicInteger(-1);
        if (requestedEnergy > 0.0) {
            energySource.ifPresent(it -> extracted.set(it.extractEnergy((int)requestedEnergy, false)));
        }
        if ((double)(extracted.get() + 1) <= requestedEnergy) {
            output = prev > 0 ? prev - 1 : 0;
        }
        return output;
    }

    private int getInputSignal() {
        BlockState thisState;
        if (this.f_58857_ == null) {
            return 0;
        }
        BlockPos thisPos = this.m_58899_();
        BlockPos neighbor = thisPos.m_121955_(((Direction)(thisState = this.f_58857_.m_8055_(thisPos)).m_61143_((Property)ThrusterExhaustBlock.FACING)).m_122424_().m_122436_());
        BlockState neighborState = this.f_58857_.m_8055_(neighbor);
        if (neighborState.m_60713_((Block)ModBlocks.ION_MODULATOR_BLOCK.get()) && ((Direction)neighborState.m_61143_((Property)IonModulatorBlock.FACING)).equals((Object)thisState.m_61143_((Property)ThrusterExhaustBlock.FACING))) {
            return this.f_58857_.m_277086_(neighbor);
        }
        return 0;
    }

    @NotNull
    private LazyOptional<IEnergyStorage> getNeighborEnergyStorage() {
        if (this.f_58857_ == null) {
            return LazyOptional.empty();
        }
        BlockState state = this.m_58900_();
        Direction facing = (Direction)state.m_61143_((Property)ThrusterExhaustBlock.FACING);
        BlockPos neighborPos = this.f_58858_.m_121945_(facing.m_122424_());
        BlockEntity neighborEntity = this.f_58857_.m_7702_(neighborPos);
        if (neighborEntity != null) {
            return neighborEntity.getCapability(ForgeCapabilities.ENERGY, facing);
        }
        return LazyOptional.empty();
    }
}

