/*
 * Decompiled with CFR 0.152.
 */
package g_mungus.zpl.ship;

import g_mungus.zpl.ship.IForceApplier;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import org.valkyrienskies.core.api.ships.LoadedServerShip;
import org.valkyrienskies.core.api.ships.PhysShip;
import org.valkyrienskies.core.api.ships.ServerShip;
import org.valkyrienskies.core.api.ships.ShipForcesInducer;
import org.valkyrienskies.core.impl.game.ships.PhysShipImpl;
import org.valkyrienskies.mod.common.VSGameUtilsKt;

public class ZPLShipAttachment
implements ShipForcesInducer {
    public Map<BlockPos, IForceApplier> appliersMapping = new ConcurrentHashMap<BlockPos, IForceApplier>();

    public void applyForces(@NotNull PhysShip physicShip) {
        PhysShipImpl ship = (PhysShipImpl)physicShip;
        this.appliersMapping.forEach((pos, applier) -> applier.applyForces((BlockPos)pos, ship));
    }

    public void addApplier(BlockPos pos, IForceApplier applier) {
        this.appliersMapping.put(pos, applier);
    }

    public void removeApplier(ServerLevel level, BlockPos pos) {
        this.appliersMapping.remove(pos);
        if (this.appliersMapping.isEmpty()) {
            ZPLShipAttachment.getShipAt(level, pos).saveAttachment(ZPLShipAttachment.class, null);
        }
    }

    public static ZPLShipAttachment getOrCreateAsAttachment(ServerShip ship) {
        ZPLShipAttachment attachment = (ZPLShipAttachment)ship.getAttachment(ZPLShipAttachment.class);
        if (attachment == null) {
            attachment = new ZPLShipAttachment();
            ship.saveAttachment(ZPLShipAttachment.class, (Object)attachment);
        }
        return attachment;
    }

    public static ZPLShipAttachment get(Level level, BlockPos pos) {
        ServerShip ship = ZPLShipAttachment.getShipAt((ServerLevel)level, pos);
        return ship != null ? ZPLShipAttachment.getOrCreateAsAttachment(ship) : null;
    }

    private static ServerShip getShipAt(ServerLevel serverLevel, BlockPos pos) {
        LoadedServerShip ship = VSGameUtilsKt.getShipObjectManagingPos((ServerLevel)serverLevel, (Vec3i)pos);
        if (ship == null) {
            ship = VSGameUtilsKt.getShipManagingPos((ServerLevel)serverLevel, (BlockPos)pos);
        }
        return ship;
    }
}

