/*
 * Decompiled with CFR 0.152.
 */
package btwr.core;

import btwr.core.BTWRItemGroup;
import btwr.core.block.BTWR_Blocks;
import btwr.core.config.BTWRSettings;
import btwr.core.entity.CreeperModificationManager;
import btwr.core.item.BTWR_Items;
import com.google.gson.Gson;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.api.ModInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BTWRMod
implements ModInitializer {
    public static final String MOD_ID = "btwr";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"btwr");
    public BTWRSettings settings;
    private static BTWRMod instance;

    public static BTWRMod getInstance() {
        return instance;
    }

    public void onInitialize() {
        LOGGER.info("Initializing BTWR-Core.");
        this.loadSettings();
        instance = this;
        BTWRItemGroup.register();
        BTWR_Blocks.register();
        BTWR_Items.register();
        CreeperModificationManager.registerUseEvent();
    }

    public void loadSettings() {
        File file = new File("./config/btwr/btwrCommon.json");
        Gson gson = new Gson();
        if (file.exists()) {
            try {
                FileReader fileReader = new FileReader(file);
                this.settings = (BTWRSettings)gson.fromJson((Reader)fileReader, BTWRSettings.class);
                fileReader.close();
            }
            catch (IOException e) {
                LOGGER.warn("Could not load btwr settings: " + e.getLocalizedMessage());
            }
        } else {
            this.settings = new BTWRSettings();
        }
    }

    public void saveSettings() {
        Gson gson = new Gson();
        File file = new File("./config/btwr/btwrCommon.json");
        if (!file.getParentFile().exists()) {
            file.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(file);
            fileWriter.write(gson.toJson((Object)this.settings));
            fileWriter.close();
        }
        catch (IOException e) {
            LOGGER.warn("Could not save btwr settings: " + e.getLocalizedMessage());
        }
    }
}

