/*
 * Decompiled with CFR 0.152.
 */
package btwr.core.block.blocks;

import btwr.core.block.BTWR_Blocks;
import btwr.core.block.blocks.BlightRootsBlock;
import btwr.core.tag.BTWRTags;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2758;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_3610;
import net.minecraft.class_3611;
import net.minecraft.class_3612;
import net.minecraft.class_4970;
import net.minecraft.class_5819;
import net.minecraft.class_7134;

public class BlightBlock
extends class_2248 {
    public static final class_2758 LEVEL = class_2758.method_11867((String)"level", (int)0, (int)3);

    public BlightBlock(class_4970.class_2251 settings) {
        super(settings);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(0)));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{LEVEL});
    }

    protected class_2758 getLevelProperty() {
        return LEVEL;
    }

    public int getMaxLevel() {
        return 3;
    }

    public int getLevel(class_2680 state) {
        return (Integer)state.method_11654((class_2769)this.getLevelProperty());
    }

    public class_2680 withLevel(int level) {
        return (class_2680)this.method_9564().method_11657((class_2769)this.getLevelProperty(), (Comparable)Integer.valueOf(level));
    }

    private class_2680 blightRootsWithLevel(int level) {
        return (class_2680)BTWR_Blocks.BLIGHT_ROOTS.method_9564().method_11657((class_2769)BlightRootsBlock.LEVEL, (Comparable)Integer.valueOf(level));
    }

    public final boolean isMature(class_2680 state) {
        return this.getLevel(state) >= this.getMaxLevel();
    }

    protected void method_9514(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        if (this.checkForBlightSurfaceConversions((class_1937)world, pos, state)) {
            return;
        }
        if (this.getLevel(state) == 1) {
            this.blightKillLeaves((class_1937)world, pos, random);
        } else if (this.getLevel(state) >= 2) {
            this.blightKillVinesAndLeaves((class_1937)world, pos, random);
        }
        if (!world.method_40134().method_40226(class_7134.field_37671)) {
            this.checkForBlightSpread((class_1937)world, pos, state, random);
            this.checkForBlightEvolution((class_1937)world, pos, state, random);
        }
    }

    private void checkForBlightSpread(class_1937 world, class_2338 pos, class_2680 state, class_5819 random) {
        int blightLevel = this.getLevel(state);
        if (blightLevel == 0) {
            int randomX = pos.method_10263() + random.method_43048(3) - 1;
            int randomY = pos.method_10264() + random.method_43048(3) - 1;
            int randomZ = pos.method_10260() + random.method_43048(3) - 1;
            class_2338 posToCheck = new class_2338(randomX, randomY, randomZ);
            this.checkForSpreadToLocation(world, state, posToCheck);
        } else if (blightLevel == 1) {
            for (int tempCount = 0; tempCount < 2; ++tempCount) {
                int randomX = pos.method_10263() + random.method_43048(3) - 1;
                int randomY = pos.method_10264() + random.method_43048(4) - 1;
                int randomZ = pos.method_10260() + random.method_43048(3) - 1;
                class_2338 posToCheck = new class_2338(randomX, randomY, randomZ);
                this.checkForSpreadToLocation(world, state, posToCheck);
            }
        } else {
            for (int tempCount = 0; tempCount < 4; ++tempCount) {
                int randomX = pos.method_10263() + random.method_43048(3) - 1;
                int randomY = pos.method_10264() + random.method_43048(5) - 2;
                int randomZ = pos.method_10260() + random.method_43048(3) - 1;
                class_2338 posToCheck = new class_2338(randomX, randomY, randomZ);
                this.checkForSpreadToLocation(world, state, posToCheck);
            }
            int rootsLevel = this.getRootsLevelForBlightLevel(blightLevel);
            if (world.method_8320(pos.method_10074()).method_27852(class_2246.field_10566)) {
                world.method_8652(pos.method_10074(), this.blightRootsWithLevel(rootsLevel), 3);
            }
            if (world.method_8320(pos.method_10084()).method_27852(class_2246.field_10566)) {
                world.method_8652(pos.method_10084(), this.blightRootsWithLevel(rootsLevel), 3);
            }
        }
    }

    private void checkForSpreadToLocation(class_1937 world, class_2680 state, class_2338 targetPos) {
        class_2680 spreadTargetState = world.method_8320(targetPos);
        if (spreadTargetState.method_26215()) {
            return;
        }
        int blightLevel = this.getLevel(state);
        if (spreadTargetState.method_27852((class_2248)this)) {
            int targetBlightLevel = this.getBlightTypeToSpread(spreadTargetState);
            if (targetBlightLevel < blightLevel && targetBlightLevel >= 0) {
                if (this.isSurfaceBlight(spreadTargetState)) {
                    targetBlightLevel = blightLevel == 3 ? 3 : ++targetBlightLevel;
                    world.method_8652(targetPos, this.withLevel(targetBlightLevel), 3);
                } else {
                    world.method_8652(targetPos, this.blightRootsWithLevel(1), 3);
                }
            }
        } else {
            class_2680 targetState = world.method_8320(targetPos);
            class_2680 aboveState = world.method_8320(targetPos.method_10084());
            if (targetState.method_26164(BTWRTags.Blocks.BLIGHT_SPREADS_TO) || targetState.method_27852(class_2246.field_10402) && (Integer)this.method_9564().method_11654((class_2769)LEVEL) >= 2) {
                if (blightLevel < 3) {
                    if (aboveState.method_26193((class_1922)world, targetPos.method_10084()) <= 2) {
                        world.method_8652(targetPos, this.withLevel(0), 3);
                    }
                } else if (aboveState.method_26193((class_1922)world, targetPos.method_10084()) <= 2) {
                    world.method_8652(targetPos, this.withLevel(3), 3);
                } else {
                    world.method_8652(targetPos, this.blightRootsWithLevel(1), 3);
                }
            }
        }
    }

    private void checkForBlightEvolution(class_1937 world, class_2338 pos, class_2680 state, class_5819 random) {
        int randomZ;
        int randomY;
        int randomX;
        class_2680 targetState;
        if (!state.method_28498((class_2769)LEVEL)) {
            return;
        }
        int blightLevel = this.getLevel(state);
        if (this.getLevel(state) == 0) {
            class_2350 randomFacing = class_2350.values()[random.method_43048(6)];
            class_2338 targetPos = pos.method_10093(randomFacing);
            if (this.isMatchingFluid(world, targetPos, class_2246.field_10382)) {
                world.method_8652(pos, this.withLevel(1), 3);
            }
        } else if (this.getLevel(state) == 1) {
            class_2350 randomFacing = class_2350.values()[random.method_43048(6)];
            class_2338 targetPos = pos.method_10093(randomFacing);
            if (this.isMatchingFluid(world, targetPos, class_2246.field_10164)) {
                world.method_8501(pos, (class_2680)state.method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(2)));
            }
        } else if ((this.getLevel(state) == 2 || state.method_27852(BTWR_Blocks.BLIGHT_ROOTS) && this.getLevel(state) == 1) && (targetState = world.method_8320(new class_2338(randomX = pos.method_10263() + random.method_43048(7) - 3, randomY = pos.method_10264() + random.method_43048(7) - 3, randomZ = pos.method_10260() + random.method_43048(7) - 3))).method_27852(class_2246.field_10316)) {
            if (this.getLevel(state) == 2) {
                world.method_8501(pos, this.withLevel(3));
            } else {
                world.method_8501(pos, this.blightRootsWithLevel(1));
            }
        }
    }

    private boolean checkForBlightSurfaceConversions(class_1937 world, class_2338 pos, class_2680 state) {
        class_2680 aboveState = world.method_8320(pos.method_10084());
        int blightLevel = this.getLevel(state);
        if (aboveState.method_26193((class_1922)world, pos.method_10084()) > 2) {
            if (blightLevel == 0) {
                world.method_8652(pos, class_2246.field_10566.method_9564(), 3);
                return true;
            }
            if (blightLevel == 2) {
                world.method_8652(pos, (class_2680)this.method_9564().method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(2)), 3);
                return true;
            }
            if (blightLevel == 3) {
                world.method_8652(pos, (class_2680)this.method_9564().method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(3)), 3);
                return true;
            }
        } else {
            if (state.method_27852(BTWR_Blocks.BLIGHT_ROOTS) && blightLevel == 0) {
                world.method_8501(pos, (class_2680)this.method_9564().method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(2)));
                return true;
            }
            if (state.method_27852(BTWR_Blocks.BLIGHT_ROOTS) && (Integer)state.method_11654((class_2769)LEVEL) == 1) {
                world.method_8501(pos, (class_2680)this.method_9564().method_11657((class_2769)LEVEL, (Comparable)Integer.valueOf(3)));
                return true;
            }
        }
        return false;
    }

    private void blightKillLeaves(class_1937 world, class_2338 pos, class_5819 random) {
        for (int tempCount = 0; tempCount < 4; ++tempCount) {
            int randomZ;
            int randomY;
            int randomX = pos.method_10263() + random.method_43048(3) - 1;
            class_2338 targetPos = new class_2338(randomX, randomY = pos.method_10264() + random.method_43048(9), randomZ = pos.method_10260() + random.method_43048(3) - 1);
            class_2680 targetState = world.method_8320(targetPos);
            if (!targetState.method_26164(class_3481.field_15503)) continue;
            world.method_8652(targetPos, class_2246.field_10124.method_9564(), 2);
        }
    }

    private void blightKillVinesAndLeaves(class_1937 world, class_2338 pos, class_5819 random) {
        for (int tempCount = 0; tempCount < 4; ++tempCount) {
            int randomZ;
            int randomY;
            int randomX = pos.method_10263() + random.method_43048(3) - 1;
            class_2338 targetPos = new class_2338(randomX, randomY = pos.method_10264() + random.method_43048(9), randomZ = pos.method_10264() + random.method_43048(3) - 1);
            class_2680 targetState = world.method_8320(targetPos);
            if (!targetState.method_26164(class_3481.field_15503) && !targetState.method_27852(class_2246.field_10597)) continue;
            world.method_8652(targetPos, class_2246.field_10124.method_9564(), 2);
        }
    }

    public boolean isSurfaceBlight(class_2680 state) {
        int blightLevel = (Integer)state.method_11654((class_2769)LEVEL);
        if (!state.method_28498((class_2769)LEVEL)) {
            return false;
        }
        return blightLevel >= 0 && blightLevel <= 3 && state.method_27852(BTWR_Blocks.BLIGHT_ROOTS) && (Integer)state.method_11654((class_2769)LEVEL) != 1;
    }

    private int getRootsLevelForBlightLevel(int level) {
        return level >= 3 ? 1 : 0;
    }

    private boolean isMatchingFluid(class_1937 world, class_2338 pos, class_2248 fluidBlock) {
        class_3610 state = world.method_8316(pos);
        if (fluidBlock == class_2246.field_10382) {
            return state.method_39360((class_3611)class_3612.field_15910) || state.method_39360((class_3611)class_3612.field_15909);
        }
        if (fluidBlock == class_2246.field_10164) {
            return state.method_39360((class_3611)class_3612.field_15908) || state.method_39360((class_3611)class_3612.field_15907);
        }
        return false;
    }

    public int getBlightTypeToSpread(class_2680 state) {
        if (state.method_27852(BTWR_Blocks.BLIGHT_ROOTS)) {
            return 3;
        }
        return (Integer)state.method_11654((class_2769)LEVEL);
    }
}

