/*
 * Decompiled with CFR 0.152.
 */
package com.blueturtles.desirepaths.config;

import com.blueturtles.desirepaths.config.ModConfigProvider;
import com.blueturtles.desirepaths.config.SimpleConfig;
import com.mojang.datafixers.util.Pair;

public class ModConfigs {
    public static SimpleConfig CONFIG;
    private static ModConfigProvider configs;
    public static int MAX_STEP_COUNT;
    public static int HEIGHT_LOW_VALUE;
    public static int STEP_RESETTER_VALUE;

    public static void registerConfigs() {
        configs = new ModConfigProvider();
        ModConfigs.createConfigs();
        CONFIG = SimpleConfig.of("desirepathsconfig").provider(configs).request();
        ModConfigs.assignConfigs();
    }

    private static void createConfigs() {
        configs.addKeyValuePair(new Pair((Object)"Step Count Maximum", (Object)9), "This is the number of times you need to step on the desire path before it turns into a Dirt Path. If the value is set to 9, then the desire path block will convert to a dirt path on the 10th step.");
        configs.addKeyValuePair(new Pair((Object)"Step Count for Low Height", (Object)5), "When the desire path reaches this value for the STEP_COUNT tag, the block will render as a dirt path that is half the height between a regular dirt path (15.0) and full block (16). This is the number of times you need to step on the desire path to drop its height down to that height (15.5). This is half the maximum by default.");
        configs.addKeyValuePair(new Pair((Object)"Step Resetter Value", (Object)5), "When you initially step on a Grass Block, it will convert into a Desire Path Block and mark the 'Stepped On' tag as true. After a random tick, the 'Stepped On' tag is changed to False. After another random tick while the 'Stepped On' tag is false, the Step Resetter Value will increase up to this value. If the Desire Path is stepped on, the Step Resetter value will revert to 0 and the Step Count will increase. This config value is the number of times a random tick has to happen before it removes one Step Count. If the Step Count reaches 0, then the Desire Path will convert back to Grass.");
    }

    private static void assignConfigs() {
        MAX_STEP_COUNT = CONFIG.getOrDefault("Step Count Maximum", 9);
        System.out.println("STEP_COUNT_MAX: " + MAX_STEP_COUNT);
        HEIGHT_LOW_VALUE = CONFIG.getOrDefault("Step Count for Low Height", 5);
        System.out.println("HEIGHT_LOW_VALUE: " + HEIGHT_LOW_VALUE);
        STEP_RESETTER_VALUE = CONFIG.getOrDefault("Step Resetter Value", 5);
        System.out.println("STEP_RESETTER_VALUE: " + STEP_RESETTER_VALUE);
        System.out.println("All " + configs.getConfigsList().size() + " configurations for desirepaths have been set properly");
    }
}

