/*
 * Decompiled with CFR 0.152.
 */
package world.landfall.verbatim;

import com.electronwill.nightconfig.core.UnmodifiableConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import world.landfall.verbatim.ChatFormattingUtils;
import world.landfall.verbatim.NameStyle;
import world.landfall.verbatim.Verbatim;
import world.landfall.verbatim.VerbatimConfig;
import world.landfall.verbatim.chat.ChatFocus;
import world.landfall.verbatim.chat.FocusTarget;

public class ChatChannelManager {
    private static boolean isInitialized = false;
    private static final Map<UUID, FocusTarget> playerFocus = new HashMap<UUID, FocusTarget>();
    private static final Map<UUID, Set<String>> joinedChannels = new HashMap<UUID, Set<String>>();
    private static final Map<UUID, UUID> lastIncomingDmSender = new HashMap<UUID, UUID>();
    private static final Map<String, ChannelConfig> channelConfigsByName = new HashMap<String, ChannelConfig>();
    private static final Map<String, ChannelConfig> channelConfigsByShortcut = new HashMap<String, ChannelConfig>();

    public static void loadConfiguredChannels() {
        channelConfigsByName.clear();
        channelConfigsByShortcut.clear();
        List channelsFromConfig = (List)VerbatimConfig.CHANNELS.get();
        Verbatim.LOGGER.info("Loading {} channel definitions from config.", (Object)channelsFromConfig.size());
        for (UnmodifiableConfig channelConf : channelsFromConfig) {
            try {
                String name = (String)channelConf.get("name");
                String displayPrefix = (String)channelConf.get("displayPrefix");
                String shortcut = (String)channelConf.get("shortcut");
                String permissionStr = channelConf.getOptional("permission").map(String::valueOf).orElse(null);
                Object rangeObj = channelConf.get("range");
                Number range = rangeObj instanceof Number ? (Number)((Number)rangeObj) : (Number)null;
                String nameColor = channelConf.getOptional("nameColor").map(String::valueOf).orElse(null);
                String separator = channelConf.getOptional("separator").map(String::valueOf).orElse(null);
                String separatorColor = channelConf.getOptional("separatorColor").map(String::valueOf).orElse(null);
                String messageColor = channelConf.getOptional("messageColor").map(String::valueOf).orElse(null);
                Boolean alwaysOn = channelConf.getOptional("alwaysOn").map(v -> (Boolean)v).orElse(false);
                Boolean mature = channelConf.getOptional("mature").map(v -> (Boolean)v).orElse(false);
                String specialChannelType = channelConf.getOptional("specialChannelType").map(String::valueOf).orElse(null);
                String nameStyle = channelConf.getOptional("nameStyle").map(String::valueOf).orElse(null);
                if (name != null && !name.isEmpty() && displayPrefix != null && shortcut != null && !shortcut.isEmpty()) {
                    ChannelConfig parsedConfig = new ChannelConfig(name, displayPrefix, shortcut, permissionStr, range, nameColor, separator, separatorColor, messageColor, alwaysOn, mature, specialChannelType, nameStyle);
                    if (channelConfigsByName.containsKey(name)) {
                        Verbatim.LOGGER.warn("Duplicate channel name in config: '{}'. Ignoring subsequent definition.", (Object)name);
                        continue;
                    }
                    if (channelConfigsByShortcut.containsKey(shortcut)) {
                        Verbatim.LOGGER.warn("Duplicate channel shortcut in config: '{}'. Ignoring subsequent definition.", (Object)shortcut);
                        continue;
                    }
                    channelConfigsByName.put(name, parsedConfig);
                    channelConfigsByShortcut.put(shortcut, parsedConfig);
                    Verbatim.LOGGER.debug("Successfully loaded channel: {}", (Object)name);
                    continue;
                }
                Verbatim.LOGGER.warn("Invalid channel definition (values not matching expected types or missing after validation) from UnmodifiableConfig: {}. Skipping.", (Object)channelConf.valueMap());
            }
            catch (Exception e) {
                Verbatim.LOGGER.error("Unexpected error parsing channel definition from UnmodifiableConfig: {}", (Object)channelConf.valueMap(), (Object)e);
            }
        }
        Verbatim.LOGGER.info("Finished loading chat channels. Total loaded: {}", (Object)channelConfigsByName.size());
        isInitialized = true;
    }

    public static boolean isInitialized() {
        return isInitialized;
    }

    public static Collection<ChannelConfig> getAllChannelConfigs() {
        return channelConfigsByName.values();
    }

    public static Optional<ChannelConfig> getChannelConfigByName(String name) {
        return Optional.ofNullable(channelConfigsByName.get(name));
    }

    public static Optional<ChannelConfig> getChannelConfigByShortcut(String shortcut) {
        return Optional.ofNullable(channelConfigsByShortcut.get(shortcut));
    }

    public static ChannelConfig getDefaultChannelConfig() {
        String defaultChannelName = (String)VerbatimConfig.DEFAULT_CHANNEL_NAME.get();
        ChannelConfig defaultConfig = channelConfigsByName.get(defaultChannelName);
        if (defaultConfig == null) {
            Verbatim.LOGGER.warn("[ChatChannelManager] Default channel named '{}' not found. Falling back.", (Object)defaultChannelName);
            if (!channelConfigsByName.isEmpty()) {
                defaultConfig = channelConfigsByName.values().stream().filter(c -> c.alwaysOn).findFirst().orElse(channelConfigsByName.values().iterator().next());
                Verbatim.LOGGER.warn("[ChatChannelManager] Using first available (preferably alwaysOn) channel '{}' as fallback default.", (Object)defaultConfig.name);
            } else {
                Verbatim.LOGGER.error("[ChatChannelManager] CRITICAL: No channels loaded. Cannot determine a default channel.");
                return null;
            }
        }
        return defaultConfig;
    }

    public static void playerLoggedIn(ServerPlayer player) {
        ChatChannelManager.loadPlayerChannelState(player);
        ChatChannelManager.ensurePlayerIsInADefaultFocus(player);
    }

    private static void loadPlayerChannelState(ServerPlayer player) {
        HashSet<String> loadedJoinedChannels = new HashSet<String>();
        String loadedFocusedChannel = null;
        try {
            if (player.getPersistentData().contains("verbatim:joined_channels")) {
                String[] joined;
                for (String chName : joined = player.getPersistentData().getString("verbatim:joined_channels").split(",")) {
                    if (chName.isEmpty() || !channelConfigsByName.containsKey(chName)) continue;
                    loadedJoinedChannels.add(chName);
                }
            }
            if (player.getPersistentData().contains("verbatim:focused_channel") && !channelConfigsByName.containsKey(loadedFocusedChannel = player.getPersistentData().getString("verbatim:focused_channel"))) {
                loadedFocusedChannel = null;
            }
        }
        catch (Exception e) {
            Verbatim.LOGGER.error("[ChatChannelManager] Error loading player channel state for {}: {}", (Object)player.getName().getString(), (Object)e.getMessage());
        }
        joinedChannels.put(player.getUUID(), loadedJoinedChannels);
        for (ChannelConfig config : channelConfigsByName.values()) {
            if (config.alwaysOn) {
                boolean wasJoined = loadedJoinedChannels.contains(config.name);
                ChatChannelManager.internalJoinChannel(player, config.name, true);
                if (wasJoined || !config.mature) continue;
                player.sendSystemMessage((Component)Component.literal((String)"\u26a0 WARNING: This channel may contain mature content!").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                player.sendSystemMessage((Component)Component.literal((String)"By remaining in this channel, you confirm that you are 18+ and okay with seeing messages posted here.").withStyle(ChatFormatting.YELLOW));
                player.sendSystemMessage((Component)Component.literal((String)"If you are not comfortable with this, please leave immediately using: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"/channel leave").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE})));
                continue;
            }
            if (!loadedJoinedChannels.contains(config.name) || !config.permission.isPresent() || Verbatim.permissionService.hasPermission(player, config.permission.get(), 2)) continue;
            Verbatim.LOGGER.info("[ChatChannelManager] Player {} lost permission for saved joined channel '{}' on login. Removing.", (Object)player.getName().getString(), (Object)config.name);
            ChatChannelManager.internalLeaveChannel(player, config.name);
        }
        if (loadedFocusedChannel != null && ChatChannelManager.getJoinedChannels(player).contains(loadedFocusedChannel)) {
            playerFocus.put(player.getUUID(), ChatFocus.createChannelFocus(loadedFocusedChannel));
        } else {
            playerFocus.remove(player.getUUID());
        }
        ChatChannelManager.savePlayerChannelState(player);
    }

    private static void ensurePlayerIsInADefaultFocus(ServerPlayer player) {
        FocusTarget currentFocus = playerFocus.get(player.getUUID());
        if (currentFocus == null || !currentFocus.isValid() || currentFocus instanceof ChatFocus && !ChatChannelManager.isJoined(player, ((ChatFocus)currentFocus).getChannelName())) {
            ChannelConfig defaultChannel = ChatChannelManager.getDefaultChannelConfig();
            if (defaultChannel != null) {
                Verbatim.LOGGER.info("[ChatChannelManager] Player {} focus invalid or not joined. Focusing to default '{}'.", (Object)player.getName().getString(), (Object)defaultChannel.name);
                ChatChannelManager.focusChannel(player, defaultChannel.name);
            } else {
                Verbatim.LOGGER.error("[ChatChannelManager] Player {} needs focus reset, but no default channel available!", (Object)player.getName().getString());
            }
        }
    }

    private static void savePlayerChannelState(ServerPlayer player) {
        Set currentJoined = joinedChannels.getOrDefault(player.getUUID(), new HashSet());
        player.getPersistentData().putString("verbatim:joined_channels", String.join((CharSequence)",", currentJoined));
        FocusTarget currentFocused = playerFocus.get(player.getUUID());
        if (currentFocused instanceof ChatFocus) {
            ChatFocus chatFocus = (ChatFocus)currentFocused;
            if (chatFocus.getType() == ChatFocus.FocusType.CHANNEL) {
                String channelName = chatFocus.getChannelName();
                if (channelName != null) {
                    player.getPersistentData().putString("verbatim:focused_channel", channelName);
                } else {
                    player.getPersistentData().remove("verbatim:focused_channel");
                }
            } else {
                player.getPersistentData().remove("verbatim:focused_channel");
            }
        } else {
            player.getPersistentData().remove("verbatim:focused_channel");
        }
    }

    public static Set<String> getJoinedChannels(ServerPlayer player) {
        return joinedChannels.getOrDefault(player.getUUID(), new HashSet());
    }

    public static List<ChannelConfig> getJoinedChannelConfigs(ServerPlayer player) {
        return ChatChannelManager.getJoinedChannels(player).stream().map(ChatChannelManager::getChannelConfigByName).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    public static Optional<ChannelConfig> getFocusedChannelConfig(ServerPlayer player) {
        FocusTarget focus = playerFocus.get(player.getUUID());
        if (focus instanceof ChatFocus && ((ChatFocus)focus).getType() == ChatFocus.FocusType.CHANNEL) {
            return ChatChannelManager.getChannelConfigByName(((ChatFocus)focus).getChannelName());
        }
        return Optional.empty();
    }

    public static boolean isJoined(ServerPlayer player, String channelName) {
        return ChatChannelManager.getJoinedChannels(player).contains(channelName);
    }

    private static boolean internalJoinChannel(ServerPlayer player, String channelName, boolean forceJoin) {
        ChannelConfig config = channelConfigsByName.get(channelName);
        if (config == null) {
            return false;
        }
        if (!forceJoin && config.permission.isPresent() && !Verbatim.permissionService.hasPermission(player, config.permission.get(), 2)) {
            return false;
        }
        joinedChannels.computeIfAbsent(player.getUUID(), k -> new HashSet()).add(channelName);
        ChatChannelManager.savePlayerChannelState(player);
        return true;
    }

    public static boolean joinChannel(ServerPlayer player, String channelName) {
        ChannelConfig config = channelConfigsByName.get(channelName);
        if (config == null) {
            player.sendSystemMessage((Component)Component.literal((String)("Channel '" + channelName + "' not found.")).withStyle(ChatFormatting.RED));
            return false;
        }
        if (ChatChannelManager.isJoined(player, channelName)) {
            player.sendSystemMessage((Component)Component.literal((String)"Already joined to channel: ").withStyle(ChatFormatting.YELLOW).append(ChatFormattingUtils.parseColors(config.displayPrefix + " " + config.name)));
            return true;
        }
        if (config.alwaysOn || !config.permission.isPresent() || Verbatim.permissionService.hasPermission(player, config.permission.get(), 2)) {
            ChatChannelManager.internalJoinChannel(player, channelName, config.alwaysOn);
            player.sendSystemMessage((Component)Component.literal((String)"Joined channel: ").withStyle(ChatFormatting.GREEN).append(ChatFormattingUtils.parseColors(config.displayPrefix + " " + config.name)));
            if (config.mature) {
                player.sendSystemMessage((Component)Component.literal((String)"\u26a0 WARNING: This channel may contain mature content. \u26a0").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                player.sendSystemMessage((Component)Component.literal((String)"By remaining in this channel, you confirm that you are 18+ and okay with seeing messages posted here.").withStyle(ChatFormatting.YELLOW));
                player.sendSystemMessage((Component)Component.literal((String)"If you are not comfortable with this, please leave immediately using: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"/channel leave").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE})));
            }
            return true;
        }
        player.sendSystemMessage((Component)Component.literal((String)"You do not have permission to join channel: ").append(ChatFormattingUtils.parseColors(config.displayPrefix + " " + config.name)).withStyle(ChatFormatting.RED));
        return false;
    }

    public static void autoLeaveChannel(ServerPlayer player, String channelName) {
        ChatChannelManager.internalLeaveChannel(player, channelName);
        FocusTarget currentFocus = playerFocus.get(player.getUUID());
        if (currentFocus instanceof ChatFocus && channelName.equals(((ChatFocus)currentFocus).getChannelName())) {
            playerFocus.remove(player.getUUID());
            ChatChannelManager.ensurePlayerIsInADefaultFocus(player);
            player.sendSystemMessage((Component)Component.literal((String)"You were automatically removed from channel '").append((Component)Component.literal((String)channelName).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"' due to permission loss and it was your focus. Focused to default.")).withStyle(ChatFormatting.RED));
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"You were automatically removed from channel '").append((Component)Component.literal((String)channelName).withStyle(ChatFormatting.YELLOW)).append((Component)Component.literal((String)"' due to permission loss.")).withStyle(ChatFormatting.RED));
        }
        ChatChannelManager.savePlayerChannelState(player);
    }

    private static void internalLeaveChannel(ServerPlayer player, String channelName) {
        joinedChannels.computeIfPresent(player.getUUID(), (k, v) -> {
            v.remove(channelName);
            return v.isEmpty() ? null : v;
        });
        if (joinedChannels.get(player.getUUID()) == null) {
            joinedChannels.remove(player.getUUID());
        }
        ChatChannelManager.savePlayerChannelState(player);
    }

    public static boolean leaveChannelCmd(ServerPlayer player, String channelName) {
        ChannelConfig config = channelConfigsByName.get(channelName);
        if (config == null) {
            player.sendSystemMessage((Component)Component.literal((String)("Channel '" + channelName + "' not found.")).withStyle(ChatFormatting.RED));
            return false;
        }
        if (config.alwaysOn) {
            player.sendSystemMessage((Component)Component.literal((String)"Cannot leave channel '").append(ChatFormattingUtils.parseColors(config.displayPrefix + " " + config.name)).append((Component)Component.literal((String)"' as it is marked always-on.")).withStyle(ChatFormatting.RED));
            return false;
        }
        if (!ChatChannelManager.isJoined(player, channelName)) {
            player.sendSystemMessage((Component)Component.literal((String)"You are not currently in channel: ").withStyle(ChatFormatting.YELLOW).append(ChatFormattingUtils.parseColors(config.displayPrefix + " " + config.name)));
            return false;
        }
        ChatChannelManager.internalLeaveChannel(player, channelName);
        player.sendSystemMessage((Component)Component.literal((String)"Left channel: ").withStyle(ChatFormatting.YELLOW).append(ChatFormattingUtils.parseColors(config.displayPrefix + " " + config.name)));
        FocusTarget currentFocus = playerFocus.get(player.getUUID());
        if (currentFocus instanceof ChatFocus && channelName.equals(((ChatFocus)currentFocus).getChannelName())) {
            playerFocus.remove(player.getUUID());
            ChatChannelManager.ensurePlayerIsInADefaultFocus(player);
        }
        ChatChannelManager.savePlayerChannelState(player);
        return true;
    }

    public static void focusChannel(ServerPlayer player, String channelName) {
        ChannelConfig config = channelConfigsByName.get(channelName);
        if (config == null) {
            player.sendSystemMessage((Component)Component.literal((String)("Cannot focus channel '" + channelName + "': Not found.")).withStyle(ChatFormatting.RED));
            return;
        }
        if (config.alwaysOn || !config.permission.isPresent() || Verbatim.permissionService.hasPermission(player, config.permission.get(), 2)) {
            boolean wasJoined = ChatChannelManager.isJoined(player, channelName);
            ChatChannelManager.internalJoinChannel(player, channelName, config.alwaysOn);
            playerFocus.put(player.getUUID(), ChatFocus.createChannelFocus(channelName));
            ChatChannelManager.savePlayerChannelState(player);
            player.sendSystemMessage((Component)Component.literal((String)"Focused channel: ").append(ChatFormattingUtils.parseColors(config.displayPrefix + " " + config.name)).withStyle(ChatFormatting.GREEN));
            if (!wasJoined && config.mature) {
                player.sendSystemMessage((Component)Component.literal((String)"\u26a0 WARNING: This channel may contain mature content. \u26a0").withStyle(new ChatFormatting[]{ChatFormatting.GOLD, ChatFormatting.BOLD}));
                player.sendSystemMessage((Component)Component.literal((String)"By remaining in this channel, you confirm that you are 18+ and okay with seeing messages posted here.").withStyle(ChatFormatting.YELLOW));
                player.sendSystemMessage((Component)Component.literal((String)"If you are not comfortable with this, please leave immediately using: ").withStyle(ChatFormatting.YELLOW).append((Component)Component.literal((String)"/channel leave").withStyle(new ChatFormatting[]{ChatFormatting.WHITE, ChatFormatting.UNDERLINE})));
            }
        } else {
            player.sendSystemMessage((Component)Component.literal((String)"Cannot focus channel '").append(ChatFormattingUtils.parseColors(config.displayPrefix + " " + config.name)).append((Component)Component.literal((String)"': You do not have permission.")).withStyle(ChatFormatting.RED));
        }
    }

    public static void playerLoggedOut(ServerPlayer player) {
        ChatChannelManager.savePlayerChannelState(player);
        playerFocus.remove(player.getUUID());
        joinedChannels.remove(player.getUUID());
        lastIncomingDmSender.remove(player.getUUID());
    }

    public static void focusDm(ServerPlayer player, UUID targetPlayerId) {
        ServerPlayer targetPlayer = ChatChannelManager.getPlayerByUUID(targetPlayerId);
        if (targetPlayer == null) {
            player.sendSystemMessage((Component)Component.literal((String)"Cannot focus DM: Target player is not online.").withStyle(ChatFormatting.RED));
            return;
        }
        playerFocus.put(player.getUUID(), ChatFocus.createDmFocus(targetPlayerId));
        player.sendSystemMessage((Component)Component.literal((String)"Focused DM with: ").append((Component)Component.literal((String)targetPlayer.getName().getString()).withStyle(ChatFormatting.YELLOW)));
    }

    public static void focusDm(ServerPlayer player, String targetPlayerName) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        ServerPlayer targetPlayer = server.getPlayerList().getPlayerByName(targetPlayerName);
        if (targetPlayer == null) {
            player.sendSystemMessage((Component)Component.literal((String)("Cannot focus DM: Player '" + targetPlayerName + "' is not online.")).withStyle(ChatFormatting.RED));
            return;
        }
        ChatChannelManager.focusDm(player, targetPlayer.getUUID());
    }

    public static Optional<FocusTarget> getFocus(ServerPlayer player) {
        return Optional.ofNullable(playerFocus.get(player.getUUID()));
    }

    public static void setLastIncomingDmSender(ServerPlayer recipient, UUID senderId) {
        lastIncomingDmSender.put(recipient.getUUID(), senderId);
    }

    public static Optional<UUID> getLastIncomingDmSender(ServerPlayer player) {
        return Optional.ofNullable(lastIncomingDmSender.get(player.getUUID()));
    }

    public static void handleDPrefix(ServerPlayer player) {
        UUID currentDmTarget;
        FocusTarget currentFocus = playerFocus.get(player.getUUID());
        UUID lastSender = lastIncomingDmSender.get(player.getUUID());
        if (lastSender == null) {
            player.sendSystemMessage((Component)Component.literal((String)"No recent DMs to reply to.").withStyle(ChatFormatting.YELLOW));
            return;
        }
        if (currentFocus instanceof ChatFocus && ((ChatFocus)currentFocus).getType() == ChatFocus.FocusType.DM && !(currentDmTarget = ((ChatFocus)currentFocus).getTargetPlayerId()).equals(lastSender)) {
            ChatChannelManager.focusDm(player, lastSender);
            return;
        }
        ChatChannelManager.focusDm(player, lastSender);
    }

    public static List<ServerPlayer> getPlayersInChannel(MinecraftServer server, String channelName) {
        ArrayList<ServerPlayer> playersInChannel = new ArrayList<ServerPlayer>();
        if (server == null || channelName == null || channelName.isEmpty()) {
            return playersInChannel;
        }
        if (!channelConfigsByName.containsKey(channelName)) {
            return playersInChannel;
        }
        for (ServerPlayer player : server.getPlayerList().getPlayers()) {
            if (!ChatChannelManager.isJoined(player, channelName)) continue;
            playersInChannel.add(player);
        }
        return playersInChannel;
    }

    public static boolean adminKickPlayerFromChannel(ServerPlayer playerToKick, String channelName, ServerPlayer executor) {
        Optional<ChannelConfig> channelConfigOpt = ChatChannelManager.getChannelConfigByName(channelName);
        if (!channelConfigOpt.isPresent()) {
            if (executor != null) {
                executor.sendSystemMessage((Component)Component.literal((String)("Channel '" + channelName + "' not found.")).withStyle(ChatFormatting.RED));
            }
            return false;
        }
        ChannelConfig channelConfig = channelConfigOpt.get();
        if (channelConfig.alwaysOn) {
            if (executor != null) {
                executor.sendSystemMessage((Component)Component.literal((String)("Cannot kick players from '" + channelName + "' as it is an always-on channel.")).withStyle(ChatFormatting.RED));
            }
            return false;
        }
        if (!ChatChannelManager.isJoined(playerToKick, channelName)) {
            if (executor != null) {
                executor.sendSystemMessage((Component)Component.literal((String)(playerToKick.getName().getString() + " is not in channel '" + channelName + "'.")).withStyle(ChatFormatting.RED));
            }
            return false;
        }
        ChatChannelManager.internalLeaveChannel(playerToKick, channelName);
        playerToKick.sendSystemMessage((Component)Component.literal((String)("You have been kicked from channel '" + channelName + "' by " + (executor != null ? executor.getName().getString() : "an administrator") + ".")).withStyle(ChatFormatting.YELLOW));
        FocusTarget currentFocus = playerFocus.get(playerToKick.getUUID());
        if (currentFocus instanceof ChatFocus && channelName.equals(((ChatFocus)currentFocus).getChannelName())) {
            playerFocus.remove(playerToKick.getUUID());
            ChatChannelManager.ensurePlayerIsInADefaultFocus(playerToKick);
            playerToKick.sendSystemMessage((Component)Component.literal((String)"Your focus was reset as you were kicked from your focused channel.").withStyle(ChatFormatting.YELLOW));
        } else {
            ChatChannelManager.savePlayerChannelState(playerToKick);
        }
        Verbatim.LOGGER.info("Player {} was kicked from channel {} by {}.", new Object[]{playerToKick.getName().getString(), channelName, executor != null ? executor.getName().getString() : "CONSOLE"});
        return true;
    }

    public static ServerPlayer getPlayerByUUID(UUID playerId) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        return server != null ? server.getPlayerList().getPlayer(playerId) : null;
    }

    public static class ChannelConfig {
        public final String name;
        public final String displayPrefix;
        public final String shortcut;
        public final Optional<String> permission;
        public final int range;
        public final String nameColor;
        public final String separator;
        public final String separatorColor;
        public final String messageColor;
        public final boolean alwaysOn;
        public final boolean mature;
        public final Optional<String> specialChannelType;
        public final NameStyle nameStyle;

        public ChannelConfig(String name, String displayPrefix, String shortcut, String permission, Number range, String nameColor, String separator, String separatorColor, String messageColor, Boolean alwaysOn, Boolean mature, String specialChannelType, String nameStyle) {
            this.name = name;
            this.displayPrefix = displayPrefix;
            this.shortcut = shortcut;
            this.alwaysOn = alwaysOn == null ? false : alwaysOn;
            this.mature = mature == null ? false : mature;
            this.permission = this.alwaysOn || permission == null || permission.trim().isEmpty() ? Optional.empty() : Optional.of(permission);
            this.range = range == null ? -1 : range.intValue();
            this.messageColor = messageColor == null || messageColor.isEmpty() ? "&f" : messageColor;
            this.nameColor = nameColor == null || nameColor.isEmpty() ? this.messageColor : nameColor;
            this.separator = separator == null || separator.isEmpty() ? ": " : separator;
            this.separatorColor = separatorColor == null || separatorColor.isEmpty() ? this.messageColor : separatorColor;
            this.specialChannelType = specialChannelType == null || specialChannelType.isEmpty() ? Optional.empty() : Optional.of(specialChannelType);
            this.nameStyle = NameStyle.fromConfigValue(nameStyle);
        }
    }
}

